/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver;

import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.MemberValuePair;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.NormalAnnotationExpr;
import japa.parser.ast.expr.QualifiedNameExpr;
import japa.parser.ast.expr.StringLiteralExpr;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.kuali.rice.devtools.jpa.eclipselink.conv.ojb.OjbUtil;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.NodeData;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.AbstractMappedFieldResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.ResolverUtil;

public class PortableSequenceGeneratorResolver
extends AbstractMappedFieldResolver {
    private static final Logger LOG = LogManager.getLogger(PortableSequenceGeneratorResolver.class);
    public static final String PACKAGE = "org.kuali.rice.krad.data.jpa.eclipselink";
    public static final String SIMPLE_NAME = "PortableSequenceGenerator";
    private final boolean upperCaseTableName;

    public PortableSequenceGeneratorResolver(Collection<DescriptorRepository> descriptorRepositories, boolean upperCaseTableName) {
        super(descriptorRepositories);
        this.upperCaseTableName = upperCaseTableName;
    }

    @Override
    public String getFullyQualifiedName() {
        return "org.kuali.rice.krad.data.jpa.eclipselink.PortableSequenceGenerator";
    }

    @Override
    protected NodeData getAnnotationNodes(String enclosingClass, String fieldName, String mappedClass) {
        FieldDescriptor fd = OjbUtil.findFieldDescriptor(mappedClass, fieldName, this.descriptorRepositories);
        if (fd != null) {
            boolean autoInc = fd.isAutoIncrement();
            String seqName = fd.getSequenceName();
            if (autoInc && StringUtils.isBlank((String)seqName)) {
                LOG.error(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has autoincrement set to true but sequenceName is blank.");
            }
            if (!autoInc && StringUtils.isNotBlank((String)seqName)) {
                LOG.error(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has autoincrement set to false but sequenceName is " + seqName + ".");
            }
            if (autoInc || StringUtils.isNotBlank((String)seqName)) {
                return new NodeData((AnnotationExpr)new NormalAnnotationExpr(new NameExpr(SIMPLE_NAME), Collections.singletonList(new MemberValuePair("name", (Expression)new StringLiteralExpr(this.upperCaseTableName ? seqName.toUpperCase() : seqName)))), new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), SIMPLE_NAME), false, false));
            }
        }
        return null;
    }
}

