/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.jpa.eclipselink.conv.parser.visitor;

import japa.parser.ast.CompilationUnit;
import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.FieldDeclaration;
import japa.parser.ast.body.TypeDeclaration;
import japa.parser.ast.visitor.VoidVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.ParserUtil;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.AnnotationHelper;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.AnnotationResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.VoidVisitorHelper;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.ColumnResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.ConvertResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.CustomizerResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.EntityResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.EnumeratedResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.GeneratedValueResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.IdClassResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.IdResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.JoinColumnResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.JoinColumnsResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.JoinTableResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.LobResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.ManyToManyResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.ManyToOneResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.MappedSuperClassResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.OneToManyResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.OneToOneResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.OrderByResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.PortableSequenceGeneratorResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.PrimaryKeyJoinColumnResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.PrimaryKeyJoinColumnsResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.ResolverUtil;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.TableResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.TemporalResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.TransientResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.VersionResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.visitor.OjbDescriptorRepositoryAwareVisitor;

public class EntityVisitor
extends OjbDescriptorRepositoryAwareVisitor {
    private static final Logger LOG = LogManager.getLogger(EntityVisitor.class);
    private static final Map<String, Map<String, CompilationUnit>> PROCESSED_CACHE = new HashMap<String, Map<String, CompilationUnit>>();
    private final VoidVisitorHelper<String> annotationHelper;

    public void setErrorsOnly() {
        LogManager.getLogger((String)"org.kuali.rice.devtools.jpa.eclipselink.conv");
    }

    public EntityVisitor(Collection<DescriptorRepository> descriptorRepositories, Map<String, String> converterMappings, boolean removeExisting, boolean upperCaseDbArtifactNames) {
        super(descriptorRepositories);
        System.out.println("Created new EntityVisitor for JPA Conversion");
        LogManager.getLogger((String)"org.kuali.rice.devtools.jpa.eclipselink.conv");
        if (converterMappings == null || converterMappings.isEmpty()) {
            throw new IllegalArgumentException("converterMappings cannot be null or empty");
        }
        ArrayList<AnnotationResolver> annotations = new ArrayList<AnnotationResolver>();
        annotations.add(new EntityResolver(this.getDescriptorRepositories()));
        annotations.add(new MappedSuperClassResolver(this.getDescriptorRepositories()));
        annotations.add(new TableResolver(this.getDescriptorRepositories(), upperCaseDbArtifactNames));
        annotations.add(new CustomizerResolver(this.getDescriptorRepositories()));
        annotations.add(new TransientResolver(this.getDescriptorRepositories()));
        annotations.add(new PortableSequenceGeneratorResolver(this.getDescriptorRepositories(), upperCaseDbArtifactNames));
        annotations.add(new GeneratedValueResolver(this.getDescriptorRepositories(), upperCaseDbArtifactNames));
        annotations.add(new IdResolver(this.getDescriptorRepositories()));
        annotations.add(new OneToOneResolver(this.getDescriptorRepositories()));
        annotations.add(new OneToManyResolver(this.getDescriptorRepositories()));
        annotations.add(new PrimaryKeyJoinColumnResolver(this.getDescriptorRepositories()));
        annotations.add(new PrimaryKeyJoinColumnsResolver(this.getDescriptorRepositories()));
        annotations.add(new ManyToOneResolver(this.getDescriptorRepositories()));
        annotations.add(new ManyToManyResolver(this.getDescriptorRepositories()));
        annotations.add(new JoinTableResolver(this.getDescriptorRepositories()));
        annotations.add(new JoinColumnResolver(this.getDescriptorRepositories()));
        annotations.add(new JoinColumnsResolver(this.getDescriptorRepositories()));
        annotations.add(new OrderByResolver(this.getDescriptorRepositories()));
        annotations.add(new ColumnResolver(this.getDescriptorRepositories(), upperCaseDbArtifactNames));
        annotations.add(new ConvertResolver(this.getDescriptorRepositories(), converterMappings));
        annotations.add(new VersionResolver(this.getDescriptorRepositories()));
        annotations.add(new TemporalResolver(this.getDescriptorRepositories()));
        annotations.add(new LobResolver(this.getDescriptorRepositories()));
        annotations.add(new EnumeratedResolver(this.getDescriptorRepositories()));
        annotations.add(new IdClassResolver(this.getDescriptorRepositories()));
        this.annotationHelper = new AnnotationHelper(annotations, removeExisting);
    }

    public void visit(CompilationUnit n, String mappedClass) {
        if (StringUtils.isBlank((String)mappedClass)) {
            throw new IllegalArgumentException("mappedClass cannot be blank");
        }
        super.visit(n, (Object)mappedClass);
        ParserUtil.sortImports(n.getImports());
        this.processedCache(n, mappedClass, PROCESSED_CACHE);
    }

    public void visit(ClassOrInterfaceDeclaration n, String mappedClass) {
        this.annotationHelper.visitPre(n, mappedClass);
        ParserUtil.deconstructMultiDeclarations(ParserUtil.getFieldMembers(n.getMembers()));
        if (n.getMembers() != null) {
            for (BodyDeclaration member : n.getMembers()) {
                member.accept((VoidVisitor)this, (Object)mappedClass);
            }
        }
        this.annotationHelper.visitPost(n, mappedClass);
    }

    public void visit(FieldDeclaration n, String mappedClass) {
        this.annotationHelper.visitPre(n, mappedClass);
        this.annotationHelper.visitPost(n, mappedClass);
    }

    private void processedCache(CompilationUnit n, String mappedClass, Map<String, Map<String, CompilationUnit>> cache) {
        String enclosingName = n.getPackage().getName() + "." + ((TypeDeclaration)n.getTypes().get(0)).getName();
        if (!enclosingName.equals(mappedClass)) {
            Map<String, CompilationUnit> entries = cache.get(enclosingName);
            if (entries == null) {
                entries = new HashMap<String, CompilationUnit>();
                entries.put(mappedClass, n);
                cache.put(enclosingName, entries);
            } else if (!this.equalsAny(n, mappedClass, entries, enclosingName)) {
                entries.put(mappedClass, n);
                cache.put(enclosingName, entries);
            }
        }
    }

    private boolean equalsAny(CompilationUnit n, String mappedClass, Map<String, CompilationUnit> entries, String enclosingName) {
        boolean equalsAny = false;
        for (Map.Entry<String, CompilationUnit> entry : entries.entrySet()) {
            if (!entry.getValue().equals((Object)n)) {
                LOG.error(ResolverUtil.logMsgForClass(enclosingName, mappedClass) + " does not equal the modified AST for " + ResolverUtil.logMsgForClass(enclosingName, entry.getKey()) + ". This likely means that a super class' fields have different mapping configurations across mapped subclasses.");
                continue;
            }
            equalsAny = true;
        }
        return equalsAny;
    }
}

