/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.jpa.eclipselink.conv.ojb;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.ConnectionDescriptorXmlHandler;
import org.apache.ojb.broker.metadata.ConnectionRepository;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.RepositoryXmlHandler;
import org.apache.ojb.broker.util.ClassHelper;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class OjbUtil {
    private static final Log LOG = LogFactory.getLog(OjbUtil.class);

    private OjbUtil() {
        throw new UnsupportedOperationException("do not call");
    }

    public static Collection<String> getMappedTree(String rootClass, Collection<DescriptorRepository> descriptorRepositories) {
        HashSet<String> processed = new HashSet<String>();
        OjbUtil.getMappedTree(rootClass, descriptorRepositories, processed);
        return processed;
    }

    private static void getMappedTree(String rootClass, Collection<DescriptorRepository> descriptorRepositories, Set<String> processed) {
        if (processed.contains(rootClass)) {
            return;
        }
        processed.add(rootClass);
        ClassDescriptor cd = OjbUtil.findClassDescriptor(rootClass, descriptorRepositories);
        if (cd != null) {
            Vector clds;
            Vector ords = cd.getObjectReferenceDescriptors();
            if (ords != null) {
                for (ObjectReferenceDescriptor ord : ords) {
                    OjbUtil.getMappedTree(ord.getItemClassName(), descriptorRepositories, processed);
                }
            }
            if ((clds = cd.getCollectionDescriptors()) != null) {
                for (ObjectReferenceDescriptor cld : clds) {
                    OjbUtil.getMappedTree(cld.getItemClassName(), descriptorRepositories, processed);
                }
            }
        } else {
            LOG.warn((Object)("ClassDescriptor not found for " + rootClass));
        }
    }

    public static boolean isMappedColumn(String clazz, String fieldName, Collection<DescriptorRepository> descriptorRepositories) {
        ClassDescriptor cd = OjbUtil.findClassDescriptor(clazz, descriptorRepositories);
        if (cd != null) {
            return cd.getFieldDescriptorByName(fieldName) != null || cd.getObjectReferenceDescriptorByName(fieldName) != null || cd.getCollectionDescriptorByName(fieldName) != null;
        }
        return false;
    }

    public static Collection<DescriptorRepository> getDescriptorRepositories(Collection<String> ojbFiles) throws Exception {
        ArrayList<DescriptorRepository> drs = new ArrayList<DescriptorRepository>();
        for (String file : ojbFiles) {
            DescriptorRepository repository = OjbUtil.readDescriptorRepository(file);
            if (repository == null) continue;
            drs.add(repository);
        }
        return drs;
    }

    public static ClassDescriptor findClassDescriptor(String clazz, Collection<DescriptorRepository> descriptorRepositories) {
        for (DescriptorRepository dr : descriptorRepositories) {
            ClassDescriptor cd = (ClassDescriptor)dr.getDescriptorTable().get(clazz);
            if (cd == null || cd.getExtentClassNames() != null && !cd.getExtentClassNames().isEmpty()) continue;
            return cd;
        }
        return null;
    }

    public static FieldDescriptor findFieldDescriptor(String clazz, String fieldName, Collection<DescriptorRepository> descriptorRepositories) {
        ClassDescriptor cd = OjbUtil.findClassDescriptor(clazz, descriptorRepositories);
        return cd != null ? cd.getFieldDescriptorByName(fieldName) : null;
    }

    public static ObjectReferenceDescriptor findObjectReferenceDescriptor(String clazz, String fieldName, Collection<DescriptorRepository> descriptorRepositories) {
        ClassDescriptor cd = OjbUtil.findClassDescriptor(clazz, descriptorRepositories);
        return cd != null ? cd.getObjectReferenceDescriptorByName(fieldName) : null;
    }

    public static CollectionDescriptor findCollectionDescriptor(String clazz, String fieldName, Collection<DescriptorRepository> descriptorRepositories) {
        ClassDescriptor cd = OjbUtil.findClassDescriptor(clazz, descriptorRepositories);
        return cd != null ? cd.getCollectionDescriptorByName(fieldName) : null;
    }

    public static Collection<String> getPrimaryKeyNames(String clazz, Collection<DescriptorRepository> descriptorRepositories) {
        ArrayList<String> pks = new ArrayList<String>();
        ClassDescriptor cd = OjbUtil.findClassDescriptor(clazz, descriptorRepositories);
        for (FieldDescriptor pk : cd.getPkFields()) {
            pks.add(pk.getAttributeName());
        }
        return pks;
    }

    public static DescriptorRepository readDescriptorRepository(String filename) {
        LOG.info((Object)("Processing Repository: " + filename));
        try {
            return (DescriptorRepository)OjbUtil.buildRepository(filename, DescriptorRepository.class);
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to process descriptor repository: " + filename));
            LOG.error((Object)e.getMessage());
            return null;
        }
    }

    public static Set<String> mappedClasses(Collection<DescriptorRepository> descriptors) throws Exception {
        HashSet<String> mappedClasses = new HashSet<String>();
        for (DescriptorRepository dr : descriptors) {
            for (Map.Entry entry : dr.getDescriptorTable().entrySet()) {
                Vector extents = ((ClassDescriptor)entry.getValue()).getExtentClassNames();
                if (extents != null && !extents.isEmpty()) {
                    mappedClasses.addAll(extents);
                    continue;
                }
                mappedClasses.add((String)entry.getKey());
            }
        }
        return mappedClasses;
    }

    public static Set<String> getSuperClasses(String clazzName, String packagePrefixToStop) throws Exception {
        HashSet<String> superClasses = new HashSet<String>();
        Class<?> clazz = Class.forName(clazzName);
        for (Class<?> sc = clazz.getSuperclass(); sc != null && sc != Object.class && !sc.getName().startsWith(packagePrefixToStop); sc = sc.getSuperclass()) {
            superClasses.add(sc.getName());
        }
        return superClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object buildRepository(String repositoryFileName, Class targetRepository) throws IOException, ParserConfigurationException, SAXException {
        URL url = OjbUtil.buildURL(repositoryFileName);
        String pathName = url.toExternalForm();
        LOG.debug((Object)("Building repository from :" + pathName));
        InputSource source = new InputSource(pathName);
        URLConnection conn = url.openConnection();
        conn.setUseCaches(false);
        conn.connect();
        InputStream i = conn.getInputStream();
        source.setByteStream(i);
        try {
            Object object = OjbUtil.readMetadataFromXML(source, targetRepository);
            return object;
        }
        finally {
            try {
                i.close();
            }
            catch (IOException x) {
                LOG.warn((Object)("unable to close repository input stream [" + x.getMessage() + "]"), (Throwable)x);
            }
        }
    }

    private static Object readMetadataFromXML(InputSource source, Class target) throws ParserConfigurationException, SAXException, IOException {
        DescriptorRepository result;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        LOG.debug((Object)("RepositoryPersistor using SAXParserFactory : " + factory.getClass().getName()));
        SAXParser p = factory.newSAXParser();
        XMLReader reader = p.getXMLReader();
        if (DescriptorRepository.class.equals((Object)target)) {
            DescriptorRepository repository = new DescriptorRepository();
            RepositoryXmlHandler handler = new RepositoryXmlHandler(repository);
            reader.setContentHandler((ContentHandler)handler);
            reader.parse(source);
            result = repository;
        } else if (ConnectionRepository.class.equals((Object)target)) {
            ConnectionRepository repository = new ConnectionRepository();
            ConnectionDescriptorXmlHandler handler = new ConnectionDescriptorXmlHandler(repository);
            reader.setContentHandler((ContentHandler)handler);
            reader.parse(source);
            result = repository;
        } else {
            throw new MetadataException("Could not build a repository instance for '" + target + "', using source " + source);
        }
        return result;
    }

    private static URL buildURL(String repositoryFileName) throws MalformedURLException {
        URL url = ClassHelper.getResource((String)repositoryFileName);
        if (url == null) {
            try {
                url = new File(repositoryFileName).toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (url == null) {
            throw new MalformedURLException("did not find resource " + repositoryFileName);
        }
        LOG.info((Object)("OJB Descriptor Repository: " + url));
        return url;
    }
}

