/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.generators.mo;

import java.util.Arrays;
import java.util.List;

final class Util {
    static final String VERSION_NUMBER_FIELD = "versionNumber";
    static final String OBJECT_ID_FIELD = "objectId";
    static final String CONSTANTS_CLASS_NAME = "Constants";
    static final String ROOT_ELEMENT_NAME_FIELD = "ROOT_ELEMENT_NAME";
    static final String TYPE_NAME_FIELD = "TYPE_NAME";
    static final String TYPE_NAME_SUFFIX = "Type";
    static final String HASH_CODE_EQUALS_EXCLUDE_FIELD = "HASH_CODE_EQUALS_EXCLUDE";
    static final String COMMON_ELEMENTS_CLASS = "CommonElements";
    static final String FUTURE_ELEMENTS_FIELD = "FUTURE_ELEMENTS";
    static final String CONSTANTS_CLASS_JAVADOC = "Defines some internal constants used on this class.";
    static final String ELEMENTS_CLASS_NAME = "Elements";
    static final String ELEMENTS_CLASS_JAVADOC = "A private class which exposes constants which define the XML element names to use when this object is marshalled to XML.";
    static final List<String> COMMON_ELEMENTS = Arrays.asList("versionNumber", "objectId");
    static final String BUILDER_CLASS_NAME = "Builder";

    Util() {
    }

    static String toLowerCaseFirstLetter(String value) {
        return value.substring(0, 1).toLowerCase() + value.substring(1);
    }

    static String toUpperCaseFirstLetter(String value) {
        return value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    static String toConstantsVariable(String fieldName) {
        StringBuilder constantVariable = new StringBuilder();
        fieldName = Util.toLowerCaseFirstLetter(fieldName);
        StringBuilder segAccum = new StringBuilder();
        for (char character : fieldName.toCharArray()) {
            if (Character.isUpperCase(character)) {
                constantVariable.append(segAccum.toString().toUpperCase());
                constantVariable.append("_");
                segAccum = new StringBuilder();
            }
            segAccum.append(character);
        }
        constantVariable.append(segAccum.toString().toUpperCase());
        return constantVariable.toString();
    }

    static String generateGetterName(String fieldName, boolean is) {
        return (is ? "is" : "get") + Util.toUpperCaseFirstLetter(fieldName);
    }

    static String generateGetter(String fieldName, boolean is) {
        return Util.generateGetterName(fieldName, is) + "()";
    }

    static String generateSetterName(String fieldName) {
        return "set" + Util.toUpperCaseFirstLetter(fieldName);
    }

    static String generateSetter(String fieldName, String valueToSet) {
        return Util.generateSetterName(fieldName) + "(" + valueToSet + ")";
    }

    static boolean isCommonElement(String fieldName) {
        return COMMON_ELEMENTS.contains(fieldName);
    }

    static String generateBuilderJavadoc(String simpleClassName, String simpleContractClassName) {
        return "A builder which can be used to construct {@link " + simpleClassName + "} instances.  " + "Enforces the constraints of the {@link " + simpleContractClassName + "}.";
    }
}

