/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver;

import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.QualifiedNameExpr;
import japa.parser.ast.expr.SingleMemberAnnotationExpr;
import japa.parser.ast.expr.StringLiteralExpr;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldHelper;
import org.kuali.rice.devtools.jpa.eclipselink.conv.ojb.OjbUtil;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.NodeData;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.AbstractMappedFieldResolver;

public class OrderByResolver
extends AbstractMappedFieldResolver {
    private static final Log LOG = LogFactory.getLog(OrderByResolver.class);
    public static final String PACKAGE = "javax.persistence";
    public static final String SIMPLE_NAME = "OrderBy";

    public OrderByResolver(Collection<DescriptorRepository> descriptorRepositories) {
        super(descriptorRepositories);
    }

    @Override
    public String getFullyQualifiedName() {
        return "javax.persistence.OrderBy";
    }

    @Override
    protected NodeData getAnnotationNodes(String enclosingClass, String fieldName, String mappedClass) {
        Collection orderBy;
        CollectionDescriptor cld = OjbUtil.findCollectionDescriptor(mappedClass, fieldName, this.descriptorRepositories);
        if (cld != null && (orderBy = cld.getOrderBy()) != null && !orderBy.isEmpty()) {
            String orderByStr = "";
            for (FieldHelper fh : orderBy) {
                orderByStr = orderByStr + fh.name + (fh.isAscending ? "" : " DESC") + ", ";
            }
            orderByStr = orderByStr.replaceAll(", $", "");
            return new NodeData((AnnotationExpr)new SingleMemberAnnotationExpr(new NameExpr(SIMPLE_NAME), (Expression)new StringLiteralExpr(orderByStr)), new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), SIMPLE_NAME), false, false));
        }
        return null;
    }
}

