/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver;

import japa.parser.ast.CompilationUnit;
import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.Node;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.TypeDeclaration;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.MemberValuePair;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.NormalAnnotationExpr;
import japa.parser.ast.expr.QualifiedNameExpr;
import japa.parser.ast.expr.StringLiteralExpr;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.kuali.rice.devtools.jpa.eclipselink.conv.ojb.OjbUtil;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.AnnotationResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.Level;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.NodeData;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.ResolverUtil;

public class TableResolver
implements AnnotationResolver {
    private static final Log LOG = LogFactory.getLog(TableResolver.class);
    public static final String PACKAGE = "javax.persistence";
    public static final String SIMPLE_NAME = "Table";
    private final Collection<DescriptorRepository> descriptorRepositories;
    private final boolean upperCaseTableName;

    public TableResolver(Collection<DescriptorRepository> descriptorRepositories, boolean upperCaseTableName) {
        this.descriptorRepositories = descriptorRepositories;
        this.upperCaseTableName = upperCaseTableName;
    }

    @Override
    public String getFullyQualifiedName() {
        return "javax.persistence.Table";
    }

    @Override
    public Level getLevel() {
        return Level.CLASS;
    }

    @Override
    public NodeData resolve(Node node, String mappedClass) {
        if (!(node instanceof ClassOrInterfaceDeclaration)) {
            throw new IllegalArgumentException("this annotation belongs only on ClassOrInterfaceDeclaration");
        }
        TypeDeclaration dclr = (TypeDeclaration)node;
        if (!(dclr.getParentNode() instanceof CompilationUnit)) {
            return null;
        }
        String name = dclr.getName();
        String pckg = ((CompilationUnit)dclr.getParentNode()).getPackage().getName().toString();
        String enclosingClass = pckg + "." + name;
        ClassDescriptor cd = OjbUtil.findClassDescriptor(enclosingClass, this.descriptorRepositories);
        if (cd != null) {
            String tableName = this.getMappedTable(enclosingClass);
            if (tableName == null) {
                LOG.error((Object)(ResolverUtil.logMsgForClass(enclosingClass, mappedClass) + " table could not be found"));
                return null;
            }
            return new NodeData((AnnotationExpr)new NormalAnnotationExpr(new NameExpr(SIMPLE_NAME), Collections.singletonList(new MemberValuePair("name", (Expression)new StringLiteralExpr(this.upperCaseTableName ? tableName.toUpperCase() : tableName)))), new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), SIMPLE_NAME), false, false));
        }
        return null;
    }

    private String getMappedTable(String clazz) {
        ClassDescriptor cd = OjbUtil.findClassDescriptor(clazz, this.descriptorRepositories);
        if (cd != null) {
            return cd.getFullTableName();
        }
        return null;
    }
}

