/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver;

import japa.parser.ast.CompilationUnit;
import japa.parser.ast.Node;
import japa.parser.ast.body.FieldDeclaration;
import japa.parser.ast.body.TypeDeclaration;
import java.util.Collection;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.kuali.rice.devtools.jpa.eclipselink.conv.ojb.OjbUtil;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.ParserUtil;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.AnnotationResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.Level;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.NodeData;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.ResolverUtil;

public abstract class AbstractMappedFieldResolver
implements AnnotationResolver {
    protected final Collection<DescriptorRepository> descriptorRepositories;

    public AbstractMappedFieldResolver(Collection<DescriptorRepository> descriptorRepositories) {
        this.descriptorRepositories = descriptorRepositories;
    }

    @Override
    public final Level getLevel() {
        return Level.FIELD;
    }

    @Override
    public final NodeData resolve(Node node, String mappedClass) {
        if (!(node instanceof FieldDeclaration)) {
            throw new IllegalArgumentException("this annotation belongs only on FieldDeclaration");
        }
        FieldDeclaration field = (FieldDeclaration)node;
        if (ResolverUtil.canFieldBeAnnotated(field)) {
            TypeDeclaration dclr = (TypeDeclaration)node.getParentNode();
            String name = dclr.getName();
            String pckg = ((CompilationUnit)dclr.getParentNode()).getPackage().getName().toString();
            String fullyQualifiedClass = pckg + "." + name;
            boolean mappedColumn = OjbUtil.isMappedColumn(mappedClass, ParserUtil.getFieldName(field), this.descriptorRepositories);
            if (mappedColumn) {
                return this.getAnnotationNodes(fullyQualifiedClass, ParserUtil.getFieldName(field), mappedClass);
            }
        }
        return null;
    }

    protected abstract NodeData getAnnotationNodes(String var1, String var2, String var3);
}

