/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver;

import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.ArrayInitializerExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.MemberValuePair;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.NormalAnnotationExpr;
import japa.parser.ast.expr.QualifiedNameExpr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.kuali.rice.devtools.jpa.eclipselink.conv.ojb.OjbUtil;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.NodeData;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.AbstractMappedFieldResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.ResolverUtil;

public class ManyToOneResolver
extends AbstractMappedFieldResolver {
    private static final Log LOG = LogFactory.getLog(ManyToOneResolver.class);
    public static final String PACKAGE = "javax.persistence";
    public static final String SIMPLE_NAME = "ManyToOne";

    public ManyToOneResolver(Collection<DescriptorRepository> descriptorRepositories) {
        super(descriptorRepositories);
    }

    @Override
    public String getFullyQualifiedName() {
        return "javax.persistence.ManyToOne";
    }

    @Override
    protected NodeData getAnnotationNodes(String enclosingClass, String fieldName, String mappedClass) {
        ObjectReferenceDescriptor ord = OjbUtil.findObjectReferenceDescriptor(mappedClass, fieldName, this.descriptorRepositories);
        if (ord != null) {
            ArrayList<MemberValuePair> pairs = new ArrayList<MemberValuePair>();
            ArrayList<ImportDeclaration> additionalImports = new ArrayList<ImportDeclaration>();
            Vector fks = ord.getForeignKeyFields();
            if (fks == null || fks.isEmpty()) {
                LOG.error((Object)(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has a reference descriptor for " + fieldName + " but does not have any foreign keys configured"));
                return null;
            }
            Collection<String> pks = OjbUtil.getPrimaryKeyNames(mappedClass, this.descriptorRepositories);
            if (pks.size() != fks.size() || !pks.containsAll(fks)) {
                int autoUpdate;
                boolean refresh;
                String className = ord.getItemClassName();
                if (StringUtils.isBlank((String)className)) {
                    LOG.error((Object)(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has a reference descriptor for " + fieldName + " but does not class name attribute"));
                } else {
                    String shortClassName = ClassUtils.getShortClassName((String)className);
                    String packageName = ClassUtils.getPackageName((String)className);
                    pairs.add(new MemberValuePair("targetEntity", (Expression)new NameExpr(shortClassName + ".class")));
                    additionalImports.add(new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(packageName), shortClassName), false, false));
                }
                boolean proxy = ord.isLazy();
                if (proxy) {
                    pairs.add(new MemberValuePair("fetch", (Expression)new NameExpr("FetchType.LAZY")));
                    additionalImports.add(new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), "FetchType"), false, false));
                }
                if (refresh = ord.isRefresh()) {
                    LOG.error((Object)(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has refresh set to " + refresh + ", unsupported conversion to @OneToOne attributes"));
                }
                ArrayList<NameExpr> cascadeTypes = new ArrayList<NameExpr>();
                boolean autoRetrieve = ord.getCascadeRetrieve();
                if (autoRetrieve) {
                    cascadeTypes.add(new NameExpr("CascadeType.REFRESH"));
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has auto-retrieve set to " + autoRetrieve + ", unsupported conversion to CascadeType"));
                }
                int autoDelete = ord.getCascadingDelete();
                if (autoDelete == 17) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has auto-delete set to none, unsupported conversion to CascadeType"));
                    }
                } else if (autoDelete == 19) {
                    LOG.warn((Object)(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has auto-delete set to link, unsupported conversion to CascadeType"));
                } else if (autoDelete == 23) {
                    cascadeTypes.add(new NameExpr("CascadeType.REMOVE"));
                } else {
                    LOG.error((Object)(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has auto-delete set to an invalid value"));
                }
                if ((autoUpdate = ord.getCascadingStore()) == 17) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has auto-update set to none, unsupported conversion to CascadeType"));
                    }
                } else if (autoUpdate == 19) {
                    LOG.warn((Object)(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has auto-update set to link, unsupported conversion to CascadeType"));
                } else if (autoUpdate == 23) {
                    cascadeTypes.add(new NameExpr("CascadeType.PERSIST"));
                } else {
                    LOG.error((Object)(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has auto-update set to an invalid value"));
                }
                if (!cascadeTypes.isEmpty()) {
                    pairs.add(new MemberValuePair("cascade", (Expression)new ArrayInitializerExpr(cascadeTypes)));
                    additionalImports.add(new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), "CascadeType"), false, false));
                }
                return new NodeData((AnnotationExpr)new NormalAnnotationExpr(new NameExpr(SIMPLE_NAME), pairs), new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), SIMPLE_NAME), false, false), additionalImports);
            }
        }
        return null;
    }
}

