/**
 * Copyright 2005-2016 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.rice.krad.uif.component;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation for <code>Component</code> fields to indicate only the property
 * reference should be made (as opposed to a new object) when doing a component
 * copy
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@Target({ ElementType.FIELD })
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface ReferenceCopy {

	/**
	 * Indicates whether a new collection instance should be made with
	 * collection elements copied by reference
	 *
	 * @return boolean true if new collection instance should be made, false if
	 *         the whole collection should be copied by reference
	 */
	boolean newCollectionInstance() default false;

    /**
     * Indicates that a field should be omitted from copying.
     * 
     * @return true if the field should be omitted from copying, false to follow
     *         {@link #newCollectionInstance()} semantics.
     */
    boolean referenceTransient() default false;

}
