--
-- Copyright 2005-2016 The Kuali Foundation
--
-- Licensed under the Educational Community License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
--
-- http://www.opensource.org/licenses/ecl2.php
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.
--


-----------------------------------------------------------------------------
-- TRAV_DOC_2_ACCOUNTS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'TRAV_DOC_2_ACCOUNTS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE TRAV_DOC_2_ACCOUNTS CASCADE CONSTRAINTS PURGE'; END IF;
END;
/

CREATE TABLE TRAV_DOC_2_ACCOUNTS
(
      FDOC_NBR VARCHAR2(14)
        , ACCT_NUM VARCHAR2(10)
)
/

ALTER TABLE TRAV_DOC_2_ACCOUNTS
    ADD CONSTRAINT TRAV_DOC_2_ACCOUNTSP1
PRIMARY KEY (FDOC_NBR,ACCT_NUM)
/

-----------------------------------------------------------------------------
-- TRV_ACCT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'TRV_ACCT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE TRV_ACCT CASCADE CONSTRAINTS PURGE'; END IF;
END;
/

CREATE TABLE TRV_ACCT (
  ACCT_NUM varchar2(10) NOT NULL,
  ACCT_NAME varchar2(50),
  ACCT_TYPE varchar2(100),
  ACCT_FO_ID number(14),
  OBJ_ID varchar2(36),
  VER_NBR number(8,0) DEFAULT 0,
  SUB_ACCT varchar2(10),
  SUB_ACCT_NAME varchar2(50),
  CREATE_DT date,
  SUBSIDIZED_PCT float(126)
)

ALTER TABLE TRV_ACCT
    ADD CONSTRAINT TRV_ACCTP1
PRIMARY KEY (ACCT_NUM)
/

-----------------------------------------------------------------------------
-- TRV_ACCT_EXT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'TRV_ACCT_EXT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE TRV_ACCT_EXT CASCADE CONSTRAINTS PURGE'; END IF;
END;
/

CREATE TABLE TRV_ACCT_EXT
(
      ACCT_NUM VARCHAR2(10)
        , ACCT_TYPE VARCHAR2(100)
)
/

ALTER TABLE TRV_ACCT_EXT
    ADD CONSTRAINT TRV_ACCT_EXTP1
PRIMARY KEY (ACCT_NUM,ACCT_TYPE)
/

-----------------------------------------------------------------------------
-- TRV_ACCT_FO
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'TRV_ACCT_FO';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE TRV_ACCT_FO CASCADE CONSTRAINTS PURGE'; END IF;
END;
/

CREATE TABLE TRV_ACCT_FO
(
      ACCT_FO_ID NUMBER(14)
        , ACCT_FO_USER_NAME VARCHAR2(50) NOT NULL
)
/

ALTER TABLE TRV_ACCT_FO
    ADD CONSTRAINT TRV_ACCT_FOP1
PRIMARY KEY (ACCT_FO_ID)
/

-----------------------------------------------------------------------------
-- TRV_ACCT_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'TRV_ACCT_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE TRV_ACCT_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
END;
/

CREATE TABLE TRV_ACCT_TYPE
(
      ACCT_TYPE VARCHAR2(10)
        , ACCT_TYPE_NAME VARCHAR2(50)
)
/

ALTER TABLE TRV_ACCT_TYPE
    ADD CONSTRAINT TRV_ACCT_TYPEP1
PRIMARY KEY (ACCT_TYPE)
/

-----------------------------------------------------------------------------
-- TRV_DOC_2
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'TRV_DOC_2';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE TRV_DOC_2 CASCADE CONSTRAINTS PURGE'; END IF;
END;
/

CREATE TABLE TRV_DOC_2
(
      FDOC_NBR VARCHAR2(14)
        , OBJ_ID VARCHAR2(36) default SYS_GUID() NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , FDOC_EXPLAIN_TXT VARCHAR2(400)
        , REQUEST_TRAV VARCHAR2(30) NOT NULL
        , TRAVELER VARCHAR2(200)
        , ORG VARCHAR2(60)
        , DEST VARCHAR2(60)
)
/

ALTER TABLE TRV_DOC_2
    ADD CONSTRAINT TRV_DOC_2P1
PRIMARY KEY (FDOC_NBR)
/

-----------------------------------------------------------------------------
-- TRV_DOC_ACCT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'TRV_DOC_ACCT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE TRV_DOC_ACCT CASCADE CONSTRAINTS PURGE'; END IF;
END;
/

CREATE TABLE TRV_DOC_ACCT
(
      DOC_HDR_ID VARCHAR2(40)
        , ACCT_NUM VARCHAR2(10)
)
/

ALTER TABLE TRV_DOC_ACCT
    ADD CONSTRAINT TRV_DOC_ACCTP1
PRIMARY KEY (DOC_HDR_ID,ACCT_NUM)
/

# -----------------------------------------------------------------------------
# Travel Approval
# -----------------------------------------------------------------------------

CREATE TABLE IF NOT EXISTS TRVL_ADV_T 
  (
    ID INT NOT NULL AUTO_INCREMENT ,
    FDOC_NBR VARCHAR2(45) NULL ,
    FDOC_LINE_NBR NUMBER(19) NULL ,
    TVL_ADV_REQ NUMBER(19,2) NULL ,
    AR_CUST_ID VARCHAR2(45) NULL ,
    AR_INV_DOC_NBR VARCHAR2(45) NULL ,
    DUE_DT DATE NULL ,
    PYMT_MTHD VARCHAR2(45) NULL ,
    FIN_COA_CD VARCHAR2(45) NULL ,
    ACCOUNT_NBR VARCHAR2(45) NULL ,
    SUB_ACCT_NBR VARCHAR2(45) NULL ,
    FIN_OBJECT_CD VARCHAR2(45) NULL ,
    FIN_SUB_OBJ_CD VARCHAR2(45) NULL ,
    ADV_PMNT_RSN_CD VARCHAR2(45) NULL ,
    TRVL_ADV_PLCY VARCHAR2(45) NULL ,
    ADD_JUST VARCHAR2(45) NULL ,
    TAX_RAM_NTF_DT DATE NULL ,
    OBJ_ID VARCHAR2(45) NULL ,
    VER_NBR NUMBER(19) NULL ,
    CONSTRAINT TRVL_ADV_T_TC0 UNIQUE (OBJ_ID),
    CONSTRAINT TRVL_ADV_T_TP1 PRIMARY KEY(ID)
  )
/


CREATE  TABLE IF NOT EXISTS TRVL_IMP_EXP_T
  (
    ID INT NOT NULL AUTO_INCREMENT ,
    FDOC_NBR VARCHAR2(45) NULL ,
    FDOC_LINE_NBR NUMBER(19) NULL ,
    EXP_TYPE_CD VARCHAR2(45) NULL ,
    EXP_PARENT_ID NUMBER(19) NULL ,
    EXP_DESC VARCHAR2(45) NULL ,
    EXP_DT DATE NULL ,
    EXP_AMT NUMBER(19,2) NULL ,
    CUR_RT NUMBER(19,2) NULL ,
    TEM_EXP_TYP_ID NUMBER(19) NULL ,
    DV_EXP_CO_NM VARCHAR2(45) NULL ,
    NON_REIMB_IND VARCHAR2(45) NULL ,
    TAXABLE_IND VARCHAR2(45) NULL ,
    MISG_RCPT_IND VARCHAR2(45) NULL ,
    CONVERTED_AMT NUMBER(19,2) NULL ,
    RCPT_RQD_IND VARCHAR2(45) NULL ,
    CARD_TYPE VARCHAR2(45) NULL ,
    HIST_EXP_ID NUMBER(19) NULL ,
    OBJ_ID VARCHAR2(45) NULL ,
    VER_NBR NUMBER(19) NULL,
    CONSTRAINT TRVL_IMP_EXP_T_TC0 UNIQUE (OBJ_ID),
    CONSTRAINT TRVL_IMP_EXP_T_TP1 PRIMARY KEY(ID)
  )
/

CREATE  TABLE IF NOT EXISTS TRVL_EXP_T
  (
    ID INT NOT NULL AUTO_INCREMENT ,
    FDOC_NBR VARCHAR2(45) NULL ,
    FDOC_LINE_NBR NUMBER(19) NULL ,
    EXP_TYPE_CD VARCHAR2(45) NULL ,
    EXP_PARENT_ID NUMBER(19) NULL ,
    EXP_DESC VARCHAR2(45) NULL ,
    EXP_DT DATE NULL ,
    EXP_AMT NUMBER(19,2) NULL ,
    CUR_RT NUMBER(19,2) NULL ,
    TEM_EXP_TYP_ID NUMBER(19) NULL ,
    DV_EXP_CO_NM VARCHAR2(45) NULL ,
    NON_REIMB_IND VARCHAR2(45) NULL ,
    TAXABLE_IND VARCHAR2(45) NULL ,
    MISG_RCPT_IND VARCHAR2(45) NULL ,
    CONVERTED_AMT NUMBER(19) NULL ,
    AIRFARE_SRC_CD VARCHAR2(45) NULL ,
    CLASS_SVC_CODE VARCHAR2(45) NULL ,
    MILEAGE_RT_ID NUMBER(19) NULL ,
    MILES NUMBER(19) NULL ,
    MILEAGE_OTHR_RT NUMBER(19,2) NULL ,
    RENTAL_CAR_INSURANCE VARCHAR2(45) NULL ,
    OBJ_ID VARCHAR2(45) NULL ,
    VER_NBR NUMBER(19) NULL ,
    CONSTRAINT TRVL_EXP_T_TC0 UNIQUE (OBJ_ID),
    CONSTRAINT TRVL_EXP_T_TP1 PRIMARY KEY(ID)
  )
/

CREATE TABLE IF NOT EXISTS TRVL_PER_DIEM_T
    (
       ID                NUMBER(19) NOT NULL,
       TRIP_TYP_CD       VARCHAR2(3) NOT NULL,
       COUNTRY           VARCHAR2(100) NULL,
       COUNTRY_NM        VARCHAR2(100) NULL,
       COUNTY_CD         VARCHAR2(100) NULL,
       PRI_DEST          VARCHAR2(100) NULL,
       SSN_BGN_DT        DATE NULL,
       EFFECT_FROM_DT    DATE NULL,
       EFFECT_TO_DT      DATE DEFAULT NULL NULL,
       LOAD_DT           DATE DEFAULT NULL NULL,
       SSN_BGN_MONTH_DAY VARCHAR2(5) DEFAULT NULL NULL,
       BKFST             NUMBER(19) NULL,
       LUNCH             NUMBER(19) NULL,
       DIN               NUMBER(19) NULL,
       LODGING           NUMBER(19,2) DEFAULT 0 NULL,
       INC               NUMBER(19,2) DEFAULT 0 NULL,
       MEALS_INC         NUMBER(19,2) DEFAULT 0 NULL,
       ACTV_IND          VARCHAR2(1) NOT NULL,
       VER_NBR           NUMBER(8, 0) DEFAULT 1 NOT NULL,
       OBJ_ID            VARCHAR2(36) NOT NULL,
       CONSTRAINT TRVL_PER_DIEM_T_TC0 UNIQUE (OBJ_ID),
       CONSTRAINT TRVL_PER_DIEM_T_TP1 PRIMARY KEY(ID)
    )
/

CREATE  TABLE IF NOT EXISTS TRVL_TRANS_MD_T
  (
    CODE VARCHAR2(45) NOT NULL,
    NAME VARCHAR2(45) NOT NULL,
    ACTIVE VARCHAR2(45) NOT NULL,
    OBJ_ID VARCHAR2(45) NULL ,
    VER_NBR NUMBER(19) NULL ,
    CONSTRAINT TRVL_TRANS_MD_T_TC0 UNIQUE (OBJ_ID),
    CONSTRAINT TRVL_TRANS_MD_T_TP1 PRIMARY KEY(CODE)
  )
/

CREATE  TABLE IF NOT EXISTS TRVL_TRANS_MD_DTL_T
  (
    FDOC_NBR VARCHAR2(45) NULL ,
    TRANS_MODE_CD VARCHAR2(45) NULL ,
    OBJ_ID VARCHAR2(45) NULL ,
    VER_NBR NUMBER(19) NULL  ,
    CONSTRAINT TRVL_TRANS_MD_DTL_T_TC0 UNIQUE (OBJ_ID),
    CONSTRAINT TRVL_TRANS_MD_DTL_T_TP1 PRIMARY KEY(FDOC_NBR)
  )
/

CREATE TABLE IF NOT EXISTS TRVL_TRIP_TYP_T
    (
       CODE              		VARCHAR2(3) 		NOT NULL,
       NM                		VARCHAR2(40) 	NOT NULL,
       GEN_ENC_IND       		VARCHAR2(1) 		NOT NULL,
       ENC_BAL_TYP       		VARCHAR2(2) 		NULL,
       ENC_OBJ_CD        		VARCHAR2(4) 		NULL,
       CONT_INFO_REQ_IND 		VARCHAR2(1) 		NOT NULL,
       BLANKET_IND       		VARCHAR2(1) 		NOT NULL,
       AUTO_TR_LIMIT			NUMBER(19,2)  	NOT NULL,
       USE_PER_DIEM 			VARCHAR2(1) 		NOT NULL,
       TA_REQUIRED 			VARCHAR2(1) 		NOT NULL,
       PER_DIEM_CALC_METHOD 	VARCHAR2(1) 		NOT NULL,
       ACTV_IND          		VARCHAR2(1) 		NOT NULL,
       VER_NBR           		NUMBER(8, 0) 	DEFAULT 1 NOT NULL,
       OBJ_ID            		VARCHAR2(36) 	NOT NULL,
       CONSTRAINT TRVL_TRIP_TYP_T_TC0 UNIQUE (OBJ_ID),
       CONSTRAINT TRVL_TRIP_TYP_T_TP1 PRIMARY KEY(CODE)
    )
/

CREATE  TABLE IF NOT EXISTS TRVL_EM_CONT_T
  (
    ID INT NOT NULL AUTO_INCREMENT ,
    TRAVELER_DTL_ID INT NULL ,
    FDOC_NBR VARCHAR2(45) NULL ,
    FDOC_LINE_NBR INT NULL ,
    CONT_REL_TYP_CD VARCHAR2(45) NULL ,
    CONT_NM VARCHAR2(45) NULL ,
    PHONE_NBR VARCHAR2(45) NULL ,
    EMAIL_ADDR VARCHAR2(45) NULL ,
    PRIMARY_IND VARCHAR2(45) NULL ,
    OBJ_ID VARCHAR2(45) NULL ,
    VER_NBR BIGINT NULL ,
    CONSTRAINT TRVL_EM_CONT_T_TC0 UNIQUE (OBJ_ID),
    CONSTRAINT TRVL_EM_CONT_T_TP1 PRIMARY KEY(ID)
  )
/

CREATE  TABLE IF NOT EXISTS  TRVL_TRAVELER_TYP_T
  (
    CODE VARCHAR2(45) NOT NULL ,
    SRC_CODE VARCHAR2(45) NULL ,
    NM VARCHAR2(45) NULL ,
    ADVANCES_IND VARCHAR2(45) NULL ,
    ACTV_IND VARCHAR2(45) NULL ,
    OBJ_ID VARCHAR2(45) NULL ,
    VER_NBR BIGINT NULL ,
    CONSTRAINT TRVL_TRAVELER_TYP_T_TC0 UNIQUE (OBJ_ID),
    CONSTRAINT TRVL_TRAVELER_TYP_T_TP1 PRIMARY KEY(CODE)
  )
/

CREATE  TABLE IF NOT EXISTS TRVL_TRAVELER_DTL_T
  (
    ID INT NOT NULL AUTO_INCREMENT ,
    DOC_NBR VARCHAR2(45) NULL ,
    EMP_PRINCIPAL_ID VARCHAR2(45) NULL ,
    CUST_NBR VARCHAR2(45) NULL ,
    FIRST_NM VARCHAR2(45) NULL ,
    LAST_NM VARCHAR2(45) NULL ,
    ADDR_LINE_1 VARCHAR2(45) NULL ,
    ADDR_LINE_2 VARCHAR2(45) NULL ,
    CITY_NM VARCHAR2(45) NULL ,
    POSTAL_STATE_CD VARCHAR2(45) NULL ,
    POSTAL_CD VARCHAR2(45) NULL ,
    COUNTRY_CD VARCHAR2(45) NULL ,
    EMAIL_ADDR VARCHAR2(45) NULL ,
    PHONE_NBR VARCHAR2(45) NULL ,
    LIABILITY_INSURANCE VARCHAR2(45) NULL ,
    TRAVELER_TYP_CD VARCHAR2(45) NULL ,
    OBJ_ID VARCHAR2(45) NULL ,
    CITIZENSHIP VARCHAR2(45) NULL ,
    ACTV_IN VARCHAR2(45) NULL ,
    VER_NBR BIGINT NULL ,
    CONSTRAINT TRVL_TRAVELER_DTL_T_TC0 UNIQUE (OBJ_ID),
    CONSTRAINT TRVL_TRAVELER_DTL_T_TP1 PRIMARY KEY(ID)
  )
/

CREATE TABLE IF NOT EXISTS TRVL_AUTH_DOC_T
  (
     FDOC_NBR                VARCHAR2(14) NOT NULL,
     TRVL_ID                 VARCHAR2(19) NULL,
     TRAVELER_DTL_ID         NUMBER(19) NULL,
     TEM_PROFILE_ID          NUMBER(19) NULL,
     TRIP_TYP_CD             VARCHAR2(3) NULL,
     TRIP_BGN_DT             DATE NULL,
     TRIP_END_DT             DATE NULL,
     PRIMARY_DEST_ID         NUMBER(19) NULL,
     PRIMARY_DEST_NAME       VARCHAR2(100) NULL,
     PRIMARY_DEST_CNTRY_ST   VARCHAR2(100) NULL,
     PRIMARY_DEST_CNTY       VARCHAR2(100) NULL,
     EXP_LMT                 NUMBER(19,2) DEFAULT 0 NULL,
     MEAL_WITHOUT_LODGING    VARCHAR2(255) NULL,
     TRIP_DESC               VARCHAR2(255) NULL,
     DELINQUENT_TR_EXCEPTION VARCHAR2(1) NULL,
     PER_DIEM_ADJ            NUMBER(19,2) DEFAULT 0 NULL,
     AR_CUST_ID              VARCHAR2(255) NULL,
     AR_INV_DOC_NBR          VARCHAR2(255) NULL,
     CELL_PH_NUM             VARCHAR2(20) NULL,
     RGN_FAMIL               VARCHAR2(255) NULL,
     CTZN_CNTRY_CD           VARCHAR2(255) NULL,
     FDOC_NXT_EXP_NBR        NUMBER(7, 0) NULL,
     VER_NBR                 NUMBER(8, 0) DEFAULT 1 NOT NULL,
     OBJ_ID                  VARCHAR2(36) NOT NULL
  )
/

