/**
 * Copyright 2005-2018 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.rice.krad.demo.uif.library.containers;

import org.junit.Test;

import org.kuali.rice.testtools.selenium.WebDriverLegacyITBase;

/**
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class LibraryContainerLinkGroupAft extends WebDriverLegacyITBase {

    /**
     * /kr-krad/kradsampleapp?viewId=Demo-LinkGroupView&methodToCall=start
     */
    public static final String BOOKMARK_URL = "/kr-krad/kradsampleapp?viewId=Demo-LinkGroupView&methodToCall=start";

    @Override
    protected String getBookmarkUrl() {
        return BOOKMARK_URL;
    }

    @Override
    protected void navigate() throws Exception {
        waitAndClickLibraryLink();
        waitAndClickByLinkText("Containers");
        waitAndClickByLinkText("Link Group");
    }

    protected void testLibraryContainerLinkGroup() throws Exception {
        waitAndClickByLinkText("Link 1");
        alertAccept();
        assertTextPresent("|");
        waitAndClickByLinkText("Link 2");
        alertAccept();
        waitAndClickByLinkText("Link 3");
        alertAccept();
    }
    
    @Test
    public void testContainerLinkGroupBookmark() throws Exception {
        testLibraryContainerLinkGroup();
        passed();
    }

    @Test
    public void testContainerLinkGroupNav() throws Exception {
        testLibraryContainerLinkGroup();
        passed();
    }  
}
