/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.framework.util;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.document.node.RouteNodeInstance;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.kuali.rice.krad.util.GlobalVariables;

public class EDLFunctions {
    private static final Logger LOG = Logger.getLogger(EDLFunctions.class);

    public static boolean isUserInitiator(String id) throws WorkflowException {
        boolean initiator = false;
        UserSession userSession = GlobalVariables.getUserSession();
        if (userSession != null) {
            try {
                String documentId = id.trim();
                if (userSession.getPrincipalId().equals(KewApiServiceLocator.getWorkflowDocumentService().getDocument(documentId).getInitiatorPrincipalId())) {
                    initiator = true;
                }
            }
            catch (Exception e) {
                LOG.debug((Object)("Exception encountered trying to determine if user is the document initiator:" + e));
            }
        }
        return initiator;
    }

    public static boolean isUserRouteLogAuthenticated(String documentId) {
        boolean authenticated = false;
        UserSession userSession = GlobalVariables.getUserSession();
        if (userSession != null) {
            String principalId = userSession.getPrincipalId();
            try {
                authenticated = KewApiServiceLocator.getWorkflowDocumentActionsService().isUserInRouteLog(documentId, principalId, true);
            }
            catch (NumberFormatException e) {
                LOG.debug((Object)("Invalid format documentId (should be LONG): " + documentId));
            }
            catch (RiceRuntimeException e) {
                LOG.error((Object)("Runtime Exception checking if user is route log authenticated: userId: " + principalId + ";documentId: " + documentId));
            }
        }
        return authenticated;
    }

    public static boolean isPrincipalIdAuthenticated(String principalId) {
        return GlobalVariables.getUserSession().getPrincipalId().equals(principalId);
    }

    public static boolean isPrincipalNameAuthenticated(String principalName) {
        return GlobalVariables.getUserSession().getPrincipalName().equals(principalName);
    }

    public static boolean isEmployeeIdAuthenticated(String employeeId) {
        return GlobalVariables.getUserSession().getPerson().getEmployeeId().equals(employeeId);
    }

    public static Person getAuthenticatedPerson() {
        UserSession userSession = GlobalVariables.getUserSession();
        Person user = userSession.getPerson();
        return user;
    }

    public static String getUserId() {
        return EDLFunctions.getAuthenticatedPerson().getPrincipalId();
    }

    public static String getLastName() {
        return EDLFunctions.getAuthenticatedPerson().getLastName();
    }

    public static String getGivenName() {
        return EDLFunctions.getAuthenticatedPerson().getFirstName();
    }

    public static String getEmailAddress() {
        return EDLFunctions.getAuthenticatedPerson().getEmailAddress();
    }

    public static String getCampus() {
        return EDLFunctions.getAuthenticatedPerson().getCampusCode();
    }

    public static String getPrimaryDeptCd() {
        return EDLFunctions.getAuthenticatedPerson().getPrimaryDepartmentCode();
    }

    public static String getEmpTypCd() {
        return EDLFunctions.getAuthenticatedPerson().getEmployeeTypeCode();
    }

    public static String getEmpPhoneNumber() {
        return EDLFunctions.getAuthenticatedPerson().getPhoneNumber();
    }

    public static String getCurrentNodeName(String documentId) {
        List routeNodeInstances = null;
        routeNodeInstances = KewApiServiceLocator.getWorkflowDocumentService().getCurrentRouteNodeInstances(documentId);
        Iterator iterator = routeNodeInstances.iterator();
        if (iterator.hasNext()) {
            RouteNodeInstance currentNode = (RouteNodeInstance)iterator.next();
            return currentNode.getName();
        }
        return null;
    }

    public static boolean isNodeInPreviousNodeList(String nodeName, String id) {
        List previousNodeNames;
        LOG.debug((Object)("nodeName came in as: " + nodeName));
        LOG.debug((Object)("id came in as: " + id));
        try {
            previousNodeNames = KewApiServiceLocator.getWorkflowDocumentService().getPreviousRouteNodeNames(id);
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException("Problem generating list of previous node names for documentID = " + id, (Throwable)e);
        }
        for (String previousNodeName : previousNodeNames) {
            if (!previousNodeName.equals(nodeName)) continue;
            return true;
        }
        return false;
    }

    public static String escapeJavascript(String value) {
        return value.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    public static boolean isNodeBetween(String firstNodeName, String lastNodeName, String id) {
        if (EDLFunctions.isNodeInPreviousNodeList(firstNodeName, id)) {
            return !EDLFunctions.isNodeInPreviousNodeList(lastNodeName, id);
        }
        return false;
    }

    public static boolean isAtNode(String documentId, String nodeName) throws Exception {
        List activeNodeInstances = KewApiServiceLocator.getWorkflowDocumentService().getActiveRouteNodeInstances(documentId);
        for (RouteNodeInstance nodeInstance : activeNodeInstances) {
            if (!nodeInstance.getName().equals(nodeName)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasActiveNode(String documentId) throws Exception {
        List activeNodeInstances = KewApiServiceLocator.getWorkflowDocumentService().getActiveRouteNodeInstances(documentId);
        return !activeNodeInstances.isEmpty();
    }

    public static String getAuthenticationId() {
        UserSession userSession = GlobalVariables.getUserSession();
        return userSession.getPrincipalName();
    }

    public static boolean isUserInGroup(String namespace, String groupName) {
        boolean isUserInGroup = false;
        if (!StringUtils.isEmpty((String)groupName)) {
            String principalId = EDLFunctions.getUserId();
            try {
                isUserInGroup = EDLFunctions.isMemberOfGroupWithName(namespace, groupName, principalId);
            }
            catch (Exception e) {
                LOG.error((Object)("Exception encountered trying to determine if user is member of a group: userId: " + principalId + ";groupNamespace/Name: " + namespace + "/" + groupName + " resulted in error:" + e));
            }
        }
        return isUserInGroup;
    }

    private static boolean isMemberOfGroupWithName(String namespace, String groupName, String principalId) {
        for (Group group : KimApiServiceLocator.getGroupService().getGroupsByPrincipalId(principalId)) {
            if (!StringUtils.equals((String)namespace, (String)group.getNamespaceCode()) || !StringUtils.equals((String)groupName, (String)group.getName())) continue;
            return true;
        }
        return false;
    }

    public static String createDocumentLock(String documentId) {
        PessimisticLockService lockService = KRADServiceLocatorWeb.getPessimisticLockService();
        PessimisticLock lock = lockService.generateNewLock(documentId);
        Long lockLong = lock.getId();
        return lockLong.toString();
    }

    public static void removeDocumentLocksByUser(String documentId) {
        try {
            PessimisticLockService lockService = KRADServiceLocatorWeb.getPessimisticLockService();
            List pessimisticLocks = lockService.getPessimisticLocksForDocument(documentId);
            lockService.releaseAllLocksForUser(pessimisticLocks, EDLFunctions.getAuthenticatedPerson());
        }
        catch (Exception e) {
            LOG.error((Object)("Exception encountered trying to delete document locks:" + e));
        }
    }

    public static Boolean isDocumentLocked(String documentId) {
        List pessimisticLocks = KRADServiceLocatorWeb.getPessimisticLockService().getPessimisticLocksForDocument(documentId);
        if (pessimisticLocks.isEmpty()) {
            return false;
        }
        return true;
    }

    public static String getDocumentLockOwner(String documentId) {
        List pessimisticLocks = KRADServiceLocatorWeb.getPessimisticLockService().getPessimisticLocksForDocument(documentId);
        if (pessimisticLocks.isEmpty()) {
            return "NoLockOnDoc";
        }
        if (pessimisticLocks.size() == 1) {
            PessimisticLock lock = (PessimisticLock)pessimisticLocks.get(0);
            return lock.getOwnedByUser().getPrincipalName();
        }
        return "MoreThanOneLockOnDoc";
    }
}

