/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.extract.dao.impl;

import java.util.List;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.kuali.rice.edl.impl.extract.Dump;
import org.kuali.rice.edl.impl.extract.Fields;
import org.kuali.rice.edl.impl.extract.dao.ExtractDAO;
import org.kuali.rice.kew.notes.Note;
import org.springmodules.orm.ojb.support.PersistenceBrokerDaoSupport;

public class ExtractDAOOjbImpl
extends PersistenceBrokerDaoSupport
implements ExtractDAO {
    private static final Logger LOG = Logger.getLogger(ExtractDAOOjbImpl.class);

    @Override
    public Dump getDumpByDocumentId(String docId) {
        LOG.debug((Object)("finding Document Extract by documentId " + docId));
        Criteria crit = new Criteria();
        crit.addEqualTo("docId", (Object)docId);
        return (Dump)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(Dump.class, crit));
    }

    @Override
    public List getFieldsByDocumentId(String docId) {
        LOG.debug((Object)("finding Extract Fileds by documentId " + docId));
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)docId);
        QueryByCriteria query = new QueryByCriteria(Fields.class, crit);
        query.addOrderByAscending("docId");
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    @Override
    public void saveDump(Dump dump) {
        LOG.debug((Object)"check for null values in Extract document");
        this.checkNull(dump.getDocId(), "Document ID");
        this.checkNull(dump.getDocCreationDate(), "Creation Date");
        this.checkNull(dump.getDocCurrentNodeName(), "Current Node Name");
        this.checkNull(dump.getDocModificationDate(), "Modification Date");
        this.checkNull(dump.getDocRouteStatusCode(), "Route Status Code");
        this.checkNull(dump.getDocInitiatorId(), "Initiator ID");
        this.checkNull(dump.getDocTypeName(), "Doc Type Name");
        LOG.debug((Object)("saving EDocLite document: routeHeader " + dump.getDocId()));
        this.getPersistenceBrokerTemplate().store((Object)dump);
    }

    @Override
    public void saveField(Fields field) {
        LOG.debug((Object)"saving EDocLite Extract fields");
        this.checkNull(field.getDocId(), "Document ID");
        this.checkNull(field.getFieldValue(), "Field Value");
        this.checkNull(field.getFiledName(), "Field Name");
        LOG.debug((Object)("saving Fields: routeHeader " + field.getFieldId()));
        this.getPersistenceBrokerTemplate().store((Object)field);
    }

    private void checkNull(Object value, String valueName) throws RuntimeException {
        if (value == null) {
            throw new RuntimeException("Null value for " + valueName);
        }
    }

    @Override
    public void deleteDump(String documentId) {
        LOG.debug((Object)"deleting record form Extract Dump table");
        Criteria crit = new Criteria();
        crit.addEqualTo("docId", (Object)documentId);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)new QueryByCriteria(Note.class, crit));
    }
}

