/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.components;

import java.util.List;
import org.kuali.rice.core.api.uif.RemotableAttributeErrorContract;
import org.kuali.rice.edl.impl.EDLContext;
import org.kuali.rice.edl.impl.RequestParser;
import org.kuali.rice.edl.impl.components.MatchingParam;
import org.kuali.rice.edl.impl.components.SimpleWorkflowEDLConfigComponent;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.document.PropertyDefinition;
import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;
import org.w3c.dom.Element;

public class AttributeEDLConfigComponent
extends SimpleWorkflowEDLConfigComponent {
    @Override
    public List getMatchingParams(Element originalConfigElement, RequestParser requestParser, EDLContext edlContext) {
        List matchingParams = super.getMatchingParams(originalConfigElement, requestParser, edlContext);
        if (!edlContext.getUserAction().isLoadAction()) {
            String attributeName = originalConfigElement.getAttribute("attributeName");
            String attributePropertyName = originalConfigElement.getAttribute("name");
            WorkflowDocument document = (WorkflowDocument)requestParser.getAttribute("workflowDocument");
            document.clearAttributeContent();
            WorkflowAttributeDefinition.Builder attributeDefBuilder = this.getWorkflowAttributeDefinitionVO(attributeName, document);
            for (MatchingParam param : matchingParams) {
                PropertyDefinition property = attributeDefBuilder.getPropertyDefinition(attributePropertyName);
                if (property == null) {
                    property = PropertyDefinition.create((String)attributePropertyName, (String)param.getParamValue());
                } else {
                    attributeDefBuilder.getPropertyDefinitions().remove(property);
                    property = PropertyDefinition.create((String)property.getName(), (String)param.getParamValue());
                }
                attributeDefBuilder.addPropertyDefinition(property);
            }
            WorkflowAttributeDefinition attributeDef = attributeDefBuilder.build();
            document.addAttributeDefinition(attributeDef);
            if (edlContext.getUserAction().isValidatableAction()) {
                List errors = document.validateAttributeDefinition(attributeDef);
                if (!errors.isEmpty()) {
                    this.getEdlContext().setInError(true);
                }
                for (RemotableAttributeErrorContract error : errors) {
                    MatchingParam param = this.getMatchingParam(matchingParams, error.getAttributeName());
                    if (param == null) {
                        List globalErrors = (List)this.getEdlContext().getRequestParser().getAttribute("org.kuali.rice.edl.impl.GlobalErrors");
                        globalErrors.add(error.getMessage());
                        continue;
                    }
                    param.setError(Boolean.TRUE);
                    param.setErrorMessage(error.getMessage());
                }
            }
        }
        return matchingParams;
    }

    private WorkflowAttributeDefinition.Builder getWorkflowAttributeDefinitionVO(String attributeName, WorkflowDocument document) {
        for (WorkflowAttributeDefinition attributeDefinition : document.getAttributeDefinitions()) {
            if (!attributeDefinition.getAttributeName().equals(attributeName)) continue;
            return WorkflowAttributeDefinition.Builder.create((WorkflowAttributeDefinition)attributeDefinition);
        }
        return WorkflowAttributeDefinition.Builder.create((String)attributeName);
    }

    private MatchingParam getMatchingParam(List matchingParams, String name) {
        for (MatchingParam param : matchingParams) {
            if (!param.getParamName().equals(name)) continue;
            return param;
        }
        return null;
    }
}

