/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.dao.impl;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.core.framework.persistence.jpa.criteria.Criteria;
import org.kuali.rice.core.framework.persistence.jpa.criteria.QueryByCriteria;
import org.kuali.rice.edl.impl.bo.EDocLiteAssociation;
import org.kuali.rice.edl.impl.bo.EDocLiteDefinition;
import org.kuali.rice.edl.impl.dao.EDocLiteDAO;

public class EDocLiteDAOJpaImpl
implements EDocLiteDAO {
    private static final Logger LOG = Logger.getLogger(EDocLiteDAOJpaImpl.class);
    private static final String ACTIVE_IND_CRITERIA = "activeInd";
    private static final String NAME_CRITERIA = "name";
    @PersistenceContext(unitName="kew-unit")
    private EntityManager entityManager;

    @Override
    public void saveEDocLiteDefinition(EDocLiteDefinition edocLiteData) {
        if (edocLiteData.getEDocLiteDefId() == null) {
            this.entityManager.persist((Object)edocLiteData);
        } else {
            OrmUtils.merge((EntityManager)this.entityManager, (Object)((Object)edocLiteData));
        }
    }

    @Override
    public void saveEDocLiteAssociation(EDocLiteAssociation assoc) {
        if (assoc.getEdocLiteAssocId() == null) {
            this.entityManager.persist((Object)assoc);
        } else {
            OrmUtils.merge((EntityManager)this.entityManager, (Object)assoc);
        }
    }

    @Override
    public EDocLiteDefinition getEDocLiteDefinition(String defName) {
        Criteria crit = new Criteria(EDocLiteDefinition.class.getName());
        crit.eq(NAME_CRITERIA, (Object)defName);
        crit.eq(ACTIVE_IND_CRITERIA, (Object)Boolean.TRUE);
        return (EDocLiteDefinition)((Object)new QueryByCriteria(this.entityManager, crit).toQuery().getSingleResult());
    }

    @Override
    public EDocLiteAssociation getEDocLiteAssociation(String docTypeName) {
        Criteria crit = new Criteria(EDocLiteAssociation.class.getName());
        crit.eq("edlName", (Object)docTypeName);
        crit.eq(ACTIVE_IND_CRITERIA, (Object)Boolean.TRUE);
        return (EDocLiteAssociation)new QueryByCriteria(this.entityManager, crit).toQuery().getSingleResult();
    }

    @Override
    public List<String> getEDocLiteDefinitions() {
        Criteria crit = new Criteria(EDocLiteDefinition.class.getName());
        crit.eq(ACTIVE_IND_CRITERIA, (Object)Boolean.TRUE);
        List defs = new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
        ArrayList<String> names = new ArrayList<String>(defs.size());
        for (EDocLiteDefinition def : defs) {
            names.add(def.getName());
        }
        return names;
    }

    @Override
    public List<EDocLiteAssociation> getEDocLiteAssociations() {
        Criteria crit = new Criteria(EDocLiteAssociation.class.getName());
        crit.eq(ACTIVE_IND_CRITERIA, (Object)Boolean.TRUE);
        return new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
    }

    @Override
    public List<EDocLiteAssociation> search(EDocLiteAssociation edocLite) {
        Criteria crit = new Criteria(EDocLiteAssociation.class.getName());
        if (edocLite.getActiveInd() != null) {
            crit.eq(ACTIVE_IND_CRITERIA, (Object)edocLite.getActiveInd());
        }
        if (edocLite.getDefinition() != null) {
            crit.like("UPPER(definition)", (Object)("%" + edocLite.getDefinition().toUpperCase() + "%"));
        }
        if (edocLite.getEdlName() != null) {
            crit.like("UPPER(edlName)", (Object)("%" + edocLite.getEdlName().toUpperCase() + "%"));
        }
        if (edocLite.getStyle() != null) {
            crit.like("UPPER(style)", (Object)("%" + edocLite.getStyle().toUpperCase() + "%"));
        }
        return new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
    }

    @Override
    public EDocLiteAssociation getEDocLiteAssociation(Long associationId) {
        Criteria crit = new Criteria(EDocLiteAssociation.class.getName());
        crit.eq("edocLiteAssocId", (Object)associationId);
        return (EDocLiteAssociation)new QueryByCriteria(this.entityManager, crit).toQuery().getSingleResult();
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

