/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.extract.dao.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.core.framework.persistence.jpa.criteria.Criteria;
import org.kuali.rice.core.framework.persistence.jpa.criteria.QueryByCriteria;
import org.kuali.rice.edl.impl.extract.Dump;
import org.kuali.rice.edl.impl.extract.Fields;
import org.kuali.rice.edl.impl.extract.dao.ExtractDAO;
import org.kuali.rice.kew.notes.Note;

public class ExtractDAOJpaImpl
implements ExtractDAO {
    private static final Logger LOG = Logger.getLogger(ExtractDAOJpaImpl.class);
    @PersistenceContext(unitName="kew-unit")
    private EntityManager entityManager;

    @Override
    public Dump getDumpByDocumentId(String docId) {
        LOG.debug((Object)("finding Document Extract by documentId " + docId));
        Criteria crit = new Criteria(Dump.class.getName());
        crit.eq("docId", (Object)docId);
        return (Dump)new QueryByCriteria(this.entityManager, crit).toQuery().getSingleResult();
    }

    @Override
    public List<Fields> getFieldsByDocumentId(String docId) {
        LOG.debug((Object)("finding Extract Fileds by documentId " + docId));
        Criteria crit = new Criteria(Fields.class.getName());
        crit.eq("documentId", (Object)docId);
        crit.orderBy("docId", true);
        return new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
    }

    @Override
    public void saveDump(Dump dump) {
        LOG.debug((Object)"check for null values in Extract document");
        this.checkNull(dump.getDocId(), "Document ID");
        this.checkNull(dump.getDocCreationDate(), "Creation Date");
        this.checkNull(dump.getDocCurrentNodeName(), "Current Node Name");
        this.checkNull(dump.getDocModificationDate(), "Modification Date");
        this.checkNull(dump.getDocRouteStatusCode(), "Route Status Code");
        this.checkNull(dump.getDocInitiatorId(), "Initiator ID");
        this.checkNull(dump.getDocTypeName(), "Doc Type Name");
        LOG.debug((Object)("saving EDocLite document: routeHeader " + dump.getDocId()));
        if (dump.getDocId() == null) {
            this.entityManager.persist((Object)dump);
        } else {
            OrmUtils.merge((EntityManager)this.entityManager, (Object)dump);
        }
    }

    @Override
    public void saveField(Fields field) {
        LOG.debug((Object)"saving EDocLite Extract fields");
        this.checkNull(field.getDocId(), "Document ID");
        this.checkNull(field.getFieldValue(), "Field Value");
        this.checkNull(field.getFiledName(), "Field Name");
        LOG.debug((Object)("saving Fields: routeHeader " + field.getFieldId()));
        if (field.getFieldId() == null) {
            this.entityManager.persist((Object)field);
        } else {
            OrmUtils.merge((EntityManager)this.entityManager, (Object)field);
        }
    }

    private void checkNull(Object value, String valueName) throws RuntimeException {
        if (value == null) {
            throw new RuntimeException("Null value for " + valueName);
        }
    }

    @Override
    public void deleteDump(String documentId) {
        LOG.debug((Object)"deleting record form Extract Dump table");
        this.entityManager.remove(this.entityManager.find(Note.class, (Object)documentId));
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

