/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.service.impl;

import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.impex.ExportDataSet;
import org.kuali.rice.core.api.impex.xml.XmlIngestionException;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.coreservice.api.style.StyleService;
import org.kuali.rice.edl.impl.EDLController;
import org.kuali.rice.edl.impl.EDLControllerFactory;
import org.kuali.rice.edl.impl.EDLGlobalConfig;
import org.kuali.rice.edl.impl.EDLGlobalConfigFactory;
import org.kuali.rice.edl.impl.EDLXmlUtils;
import org.kuali.rice.edl.impl.bo.EDocLiteAssociation;
import org.kuali.rice.edl.impl.bo.EDocLiteDefinition;
import org.kuali.rice.edl.impl.dao.EDocLiteDAO;
import org.kuali.rice.edl.impl.service.EDocLiteService;
import org.kuali.rice.edl.impl.xml.EDocLiteXmlParser;
import org.kuali.rice.edl.impl.xml.export.EDocLiteXmlExporter;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.exception.WorkflowServiceError;
import org.kuali.rice.kew.exception.WorkflowServiceErrorException;
import org.kuali.rice.kew.exception.WorkflowServiceErrorImpl;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class EDocLiteServiceImpl
implements EDocLiteService {
    private static final Logger LOG = LogManager.getLogger(EDocLiteServiceImpl.class);
    private final AtomicReference<EDLGlobalConfig> edlGlobalConfig = new AtomicReference<Object>(null);
    private EDocLiteDAO dao;
    private StyleService styleService;

    public void setEDocLiteDAO(EDocLiteDAO dao) {
        this.dao = dao;
    }

    @Override
    public EDLController getEDLControllerUsingEdlName(String edlName) {
        EDocLiteAssociation edlAssociation = this.dao.getEDocLiteAssociation(edlName);
        if (edlAssociation == null) {
            throw new WorkflowRuntimeException("No document association active for EDL: " + edlName);
        }
        this.initEDLGlobalConfig();
        return EDLControllerFactory.createEDLController(edlAssociation, this.edlGlobalConfig.get());
    }

    @Override
    public EDLController getEDLControllerUsingDocumentId(String documentId) {
        EDocLiteAssociation edlAssociation;
        DocumentRouteHeaderValue document = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId);
        String edlName = document.getAppDocId();
        if (edlName == null) {
            edlName = document.getDocumentType().getName();
        }
        if ((edlAssociation = this.dao.getEDocLiteAssociation(edlName)) == null) {
            throw new WorkflowRuntimeException("No document association active for EDL: " + edlName);
        }
        this.initEDLGlobalConfig();
        return EDLControllerFactory.createEDLController(edlAssociation, this.edlGlobalConfig.get(), document);
    }

    @Override
    public void initEDLGlobalConfig() {
        this.edlGlobalConfig.compareAndSet(null, this.getEDLGlobalConfig());
    }

    private EDLGlobalConfig getEDLGlobalConfig() {
        try {
            return EDLGlobalConfigFactory.createEDLGlobalConfig(ConfigContext.getCurrentContextConfig().getEDLConfigLocation());
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
    }

    @Override
    public Document getDefinitionXml(EDocLiteAssociation edlAssociation) {
        try {
            Document def = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(this.getEDocLiteDefinition(edlAssociation.getDefinition()).getXmlContent())));
            return def;
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException("Caught exception parsing EDL definition " + edlAssociation.getDefinition(), (Throwable)e);
        }
    }

    private static XmlIngestionException generateException(String error, Throwable cause) {
        return new XmlIngestionException(error, cause);
    }

    private static XmlIngestionException generateMissingAttribException(String element, String attrib) {
        return EDocLiteServiceImpl.generateException("EDocLite '" + element + "' element must contain a '" + attrib + "' attribute", null);
    }

    private static XmlIngestionException generateMissingChildException(String element, String child) {
        return EDocLiteServiceImpl.generateException("EDocLite '" + element + "' element must contain a '" + child + "' child element", null);
    }

    private static XmlIngestionException generateSerializationException(String element, XmlException cause) {
        return EDocLiteServiceImpl.generateException("Error serializing EDocLite '" + element + "' element", cause);
    }

    private static Document parse(InputStream stream) {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(stream);
        }
        catch (Exception e) {
            WorkflowServiceErrorException wsee = new WorkflowServiceErrorException("Error parsing EDocLite XML file", (WorkflowServiceError)new WorkflowServiceErrorImpl("Error parsing XML file.", "general.error.parsexml"));
            wsee.initCause((Throwable)e);
            throw wsee;
        }
    }

    private static EDocLiteAssociation parseEDocLiteAssociation(Element e) {
        String docType = EDLXmlUtils.getChildElementTextValue(e, "docType");
        if (docType == null) {
            throw EDocLiteServiceImpl.generateMissingChildException("association", "docType");
        }
        EDocLiteAssociation assoc = new EDocLiteAssociation();
        assoc.setEdlName(docType);
        assoc.setDefinition(EDLXmlUtils.getChildElementTextValue(e, "definition"));
        assoc.setStyle(EDLXmlUtils.getChildElementTextValue(e, "style"));
        assoc.setActiveInd(Boolean.valueOf(EDLXmlUtils.getChildElementTextValue(e, "active")));
        return assoc;
    }

    private static EDocLiteDefinition parseEDocLiteDefinition(Element e) {
        NodeList fields;
        EDocLiteDefinition def = new EDocLiteDefinition();
        String name = e.getAttribute("name");
        if (name == null || name.length() == 0) {
            throw EDocLiteServiceImpl.generateMissingAttribException("edl", "name");
        }
        def.setName(name);
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            fields = (NodeList)xpath.evaluate("fieldDef", e, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xpee) {
            throw new RuntimeException("Invalid EDocLiteDefinition", xpee);
        }
        if (fields != null) {
            ArrayList<String> invalidAttributes = new ArrayList<String>(5);
            for (int i = 0; i < fields.getLength(); ++i) {
                RuleAttribute ruleAttrib;
                Node node = fields.item(i);
                if (!(node instanceof Element)) continue;
                Element field = (Element)node;
                String fieldName = field.getAttribute("name");
                String attribute = field.getAttribute("attributeName");
                if (attribute == null || attribute.length() <= 0 || (ruleAttrib = KEWServiceLocator.getRuleAttributeService().findByName(attribute)) != null) continue;
                LOG.error("Invalid attribute referenced in EDocLite definition: " + attribute);
                invalidAttributes.add("Attribute '" + attribute + "' referenced in field '" + fieldName + "' not found");
            }
            if (invalidAttributes.size() > 0) {
                LOG.error("Invalid attributes referenced in EDocLite definition");
                StringBuffer message = new StringBuffer("EDocLite definition contains references to non-existent attributes;\n");
                Iterator it = invalidAttributes.iterator();
                while (it.hasNext()) {
                    message.append(it.next());
                    message.append("\n");
                }
                throw new RuntimeException(message.toString());
            }
        }
        try {
            def.setXmlContent(XmlJotter.jotNode((Node)e, (boolean)true));
        }
        catch (XmlException te) {
            throw EDocLiteServiceImpl.generateSerializationException("edl", te);
        }
        return def;
    }

    @Override
    public void saveEDocLiteDefinition(EDocLiteDefinition data) {
        EDocLiteDefinition existingData = this.getEDocLiteDefinition(data.getName());
        if (existingData != null) {
            existingData.setActiveInd(Boolean.FALSE);
            this.dao.saveEDocLiteDefinition(existingData);
        }
        if (data.getActiveInd() == null) {
            data.setActiveInd(Boolean.TRUE);
        }
        this.dao.saveEDocLiteDefinition(data);
    }

    @Override
    public void saveEDocLiteAssociation(EDocLiteAssociation assoc) {
        EDocLiteAssociation existingData = this.getEDocLiteAssociation(assoc.getEdlName());
        if (existingData != null) {
            existingData.setActiveInd(Boolean.FALSE);
            this.dao.saveEDocLiteAssociation(existingData);
        }
        if (assoc.getActiveInd() == null) {
            assoc.setActiveInd(Boolean.TRUE);
        }
        this.dao.saveEDocLiteAssociation(assoc);
    }

    @Override
    public void saveEDocLiteDefinition(InputStream xml) {
        EDocLiteDefinition data = EDocLiteServiceImpl.parseEDocLiteDefinition(EDocLiteServiceImpl.parse(xml).getDocumentElement());
        this.saveEDocLiteDefinition(data);
    }

    @Override
    public void saveEDocLiteAssociation(InputStream xml) {
        EDocLiteAssociation assoc = EDocLiteServiceImpl.parseEDocLiteAssociation(EDocLiteServiceImpl.parse(xml).getDocumentElement());
        this.saveEDocLiteAssociation(assoc);
    }

    @Override
    public EDocLiteDefinition getEDocLiteDefinition(String definitionName) {
        return this.dao.getEDocLiteDefinition(definitionName);
    }

    @Override
    public EDocLiteAssociation getEDocLiteAssociation(String docTypeName) {
        return this.dao.getEDocLiteAssociation(docTypeName);
    }

    public List getEDocLiteDefinitions() {
        return this.dao.getEDocLiteDefinitions();
    }

    public List getEDocLiteAssociations() {
        return this.dao.getEDocLiteAssociations();
    }

    @Override
    public Templates getStyleAsTranslet(String name) throws TransformerConfigurationException {
        if (name == null || "null".equals(name)) {
            name = "Default";
        }
        return this.styleService.getStyleAsTranslet(name);
    }

    public List search(EDocLiteAssociation edocLite) {
        return this.dao.search(edocLite);
    }

    @Override
    public EDocLiteAssociation getEDocLiteAssociation(Long associationId) {
        return this.dao.getEDocLiteAssociation(associationId);
    }

    public void loadXml(InputStream inputStream, String principalId) {
        EDocLiteXmlParser.loadXml(inputStream, principalId);
    }

    public org.jdom2.Element export(ExportDataSet dataSet) {
        return new EDocLiteXmlExporter().export(dataSet);
    }

    public boolean supportPrettyPrint() {
        return false;
    }

    public void setStyleService(StyleService styleService) {
        this.styleService = styleService;
    }
}

