/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl;

import java.io.OutputStream;
import java.util.Stack;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.edl.impl.EDLContext;
import org.kuali.rice.edl.impl.EDLController;
import org.kuali.rice.edl.impl.RequestParser;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.util.GlobalVariables;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class EDLControllerChain {
    private static final Logger LOG = LogManager.getLogger(EDLControllerChain.class);
    private Stack<EDLController> edlControllers = new Stack();

    public void renderEDL(RequestParser requestParser, HttpServletResponse response) throws Exception {
        EDLController edlController = this.edlControllers.pop();
        edlController.setEdlContext(this.getInitialEDLContext(edlController, requestParser, edlController.getStyle().newTransformer()));
        Document dom = edlController.notifyComponents();
        if (this.edlControllers.isEmpty()) {
            this.transform(edlController.getEdlContext(), dom, response);
        } else {
            this.renderEDL(requestParser, response);
        }
    }

    public void addEdlController(EDLController edlController) {
        this.edlControllers.add(edlController);
    }

    private void transform(EDLContext edlContext, Document dom, HttpServletResponse response) throws Exception {
        if (StringUtils.isNotBlank((String)edlContext.getRedirectUrl())) {
            response.sendRedirect(edlContext.getRedirectUrl());
            return;
        }
        response.setContentType("text/html; charset=UTF-8");
        Transformer transformer = edlContext.getTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("indent", "yes");
        String user = null;
        String loggedInUser = null;
        if (edlContext.getUserSession() != null) {
            Person wu = edlContext.getUserSession().getPerson();
            if (wu != null) {
                user = wu.getPrincipalId();
            }
            if ((wu = edlContext.getUserSession().getPerson()) != null) {
                loggedInUser = wu.getPrincipalId();
            }
        }
        transformer.setParameter("user", user);
        transformer.setParameter("loggedInUser", loggedInUser);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Transforming dom " + XmlJotter.jotNode((Node)dom, (boolean)true));
        }
        transformer.transform(new DOMSource(dom), new StreamResult((OutputStream)response.getOutputStream()));
    }

    private EDLContext getInitialEDLContext(EDLController edlController, RequestParser requestParser, Transformer transformer) {
        EDLContext edlContext = new EDLContext();
        edlContext.setEdlControllerChain(this);
        edlContext.setEdocLiteAssociation(edlController.getEdocLiteAssociation());
        edlContext.setUserSession(GlobalVariables.getUserSession());
        edlContext.setTransformer(transformer);
        edlContext.setRequestParser(requestParser);
        edlContext.setXpath(XPathFactory.newInstance().newXPath());
        return edlContext;
    }
}

