/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.components;

import java.util.ArrayList;
import org.kuali.rice.edl.impl.EDLContext;
import org.kuali.rice.edl.impl.EDLModelComponent;
import org.kuali.rice.edl.impl.EDLXmlUtils;
import org.kuali.rice.edl.impl.RequestParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VersioningPreprocessor
implements EDLModelComponent {
    @Override
    public void updateDOM(Document dom, Element configElement, EDLContext edlContext) {
        RequestParser requestParser = edlContext.getRequestParser();
        boolean incrementVersion = edlContext.getUserAction().isIncrementVersionAction();
        boolean replaceVersion = edlContext.getUserAction().isReplaceVersionAction();
        Element edlContentElement = EDLXmlUtils.getEDLContent(dom, false);
        Element dataElement = EDLXmlUtils.getDataFromEDLDocument(edlContentElement, false);
        Element currentVersion = VersioningPreprocessor.findCurrentVersion(dom);
        if (currentVersion == null) {
            Integer currentVersionCount = new Integer(0);
            currentVersion = EDLXmlUtils.getVersionFromData(dataElement, currentVersionCount);
        } else if (incrementVersion) {
            currentVersion.getAttributeNode("current").setNodeValue("false");
            int currentVersionCount = new Integer(currentVersion.getAttribute("version")) + 1;
            EDLXmlUtils.getVersionFromData(dataElement, new Integer(currentVersionCount));
        } else if (replaceVersion) {
            NodeList children = currentVersion.getChildNodes();
            ArrayList<Node> childrenToRemove = new ArrayList<Node>();
            for (int index = 0; index < children.getLength(); ++index) {
                childrenToRemove.add(children.item(index));
            }
            for (Node childToRemove : childrenToRemove) {
                currentVersion.removeChild(childToRemove);
            }
        }
        requestParser.setAttribute("currentVersion", currentVersion.getAttribute("currentVersion"));
    }

    public static Element findCurrentVersion(Document dom) {
        Element edlContentElement = EDLXmlUtils.getEDLContent(dom, false);
        Element dataElement = EDLXmlUtils.getDataFromEDLDocument(edlContentElement, false);
        NodeList versionElements = dataElement.getElementsByTagName("version");
        for (int i = 0; i < versionElements.getLength(); ++i) {
            Element version = (Element)versionElements.item(i);
            Boolean currentVersion = new Boolean(version.getAttribute("current"));
            if (!currentVersion.booleanValue()) continue;
            return version;
        }
        return null;
    }
}

