/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.components;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.edl.impl.EDLContext;
import org.kuali.rice.edl.impl.EDLModelComponent;
import org.kuali.rice.edl.impl.EDLXmlUtils;
import org.kuali.rice.edl.impl.RequestParser;
import org.kuali.rice.edl.impl.UserAction;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WorkflowDocumentActions
implements EDLModelComponent {
    private static final Logger LOG = LogManager.getLogger(WorkflowDocumentActions.class);
    public static final String ACTION_TAKEN = "actionTaken";
    boolean isPreProcessor;

    @Override
    public void updateDOM(Document dom, Element configElement, EDLContext edlContext) {
        try {
            this.isPreProcessor = configElement.getTagName().equals("preProcessor");
            if (this.isPreProcessor) {
                this.doPreProcessWork(edlContext);
            } else {
                this.doPostProcessWork(dom, edlContext);
            }
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
    }

    private void doPreProcessWork(EDLContext edlContext) throws Exception {
        RequestParser requestParser = edlContext.getRequestParser();
        UserAction userAction = edlContext.getUserAction();
        WorkflowDocument document = null;
        if ("initiate".equals(userAction.getAction())) {
            document = WorkflowDocumentFactory.createDocument((String)edlContext.getUserSession().getPrincipalId(), (String)edlContext.getEdocLiteAssociation().getEdlName());
            document.setTitle("Routing Document Type '" + document.getDocumentTypeName() + "'");
            document.getDocumentId();
            LOG.info("Created document " + document.getDocumentId());
        } else {
            document = (WorkflowDocument)requestParser.getAttribute("workflowDocument");
            if (document == null) {
                String docId = (String)requestParser.getAttribute("docId");
                if (docId == null) {
                    LOG.info("no document found for edl " + edlContext.getEdocLiteAssociation().getEdlName());
                    return;
                }
                document = WorkflowDocumentFactory.loadDocument((String)edlContext.getUserSession().getPrincipalId(), (String)docId);
            }
        }
        requestParser.setAttribute("workflowDocument", document);
    }

    private void doPostProcessWork(Document dom, EDLContext edlContext) throws Exception {
        RequestParser requestParser = edlContext.getRequestParser();
        if (edlContext.isInError()) {
            return;
        }
        WorkflowDocument document = (WorkflowDocument)edlContext.getRequestParser().getAttribute("workflowDocument");
        if (document == null) {
            return;
        }
        Element dataElement = (Element)dom.getElementsByTagName("data").item(0);
        String docContent = XmlJotter.jotNode((Node)dataElement);
        document.setApplicationContent(docContent);
        WorkflowDocumentActions.takeAction(document, dom, edlContext);
    }

    public static void takeAction(WorkflowDocument document, Document dom, EDLContext edlContext) throws WorkflowException {
        RequestParser requestParser = edlContext.getRequestParser();
        UserAction userAction = edlContext.getUserAction();
        String annotation = requestParser.getParameterValue("annotation");
        String action = userAction.getAction();
        String previousNodeName = requestParser.getParameterValue("previousNode");
        if (!userAction.isValidatableAction()) {
            document.clearAttributeDefinitions();
        }
        boolean actionTaken = true;
        if ("route".equals(action)) {
            document.route(annotation);
        } else if ("initiate".equals(action)) {
            document.saveDocumentData();
        } else if ("approve".equals(action)) {
            document.approve(annotation);
        } else if ("disapprove".equals(action)) {
            document.disapprove(annotation);
        } else if ("cancel".equals(action)) {
            document.cancel(annotation);
        } else if ("blanketApprove".equals(action)) {
            document.blanketApprove(annotation);
        } else if ("fyi".equals(action)) {
            document.fyi();
        } else if ("acknowledge".equals(action)) {
            document.acknowledge(annotation);
        } else if ("save".equals(action)) {
            if (document.getStatus().equals((Object)DocumentStatus.INITIATED)) {
                document.saveDocument(annotation);
            } else {
                document.saveDocumentData();
            }
        } else if ("complete".equals(action)) {
            document.complete(annotation);
        } else if ("delete".equals(action)) {
            document.delete();
        } else if ("returnToPrevious".equals(action)) {
            document.returnToPreviousNode(annotation, previousNodeName);
        } else {
            actionTaken = false;
        }
        if (actionTaken) {
            Element actionTakenElement = EDLXmlUtils.getOrCreateChildElement(dom.getDocumentElement(), ACTION_TAKEN, true);
            actionTakenElement.appendChild(dom.createTextNode(action));
        }
    }
}

