/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.dao.impl;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.edl.impl.bo.EDocLiteAssociation;
import org.kuali.rice.edl.impl.bo.EDocLiteDefinition;
import org.kuali.rice.edl.impl.dao.EDocLiteDAO;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;

public class EDocLiteDAOJpaImpl
implements EDocLiteDAO {
    private static final String ACTIVE_IND_CRITERIA = "activeInd";
    private static final String NAME_CRITERIA = "name";
    private static final String EDL_NAME = "edlName";
    private static final String UPPER = "UPPER";
    private static final String DEFINITION = "definition";
    private static final String STYLE = "style";
    private DataObjectService dataObjectService;

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    @Override
    public EDocLiteDefinition saveEDocLiteDefinition(EDocLiteDefinition edocLiteData) {
        return (EDocLiteDefinition)((Object)this.dataObjectService.save((Object)edocLiteData, new PersistenceOption[]{PersistenceOption.FLUSH}));
    }

    @Override
    public EDocLiteAssociation saveEDocLiteAssociation(EDocLiteAssociation assoc) {
        return (EDocLiteAssociation)((Object)this.dataObjectService.save((Object)assoc, new PersistenceOption[]{PersistenceOption.FLUSH}));
    }

    @Override
    public EDocLiteDefinition getEDocLiteDefinition(String defName) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)NAME_CRITERIA, (Object)defName), PredicateFactory.equal((String)ACTIVE_IND_CRITERIA, (Object)Boolean.TRUE)});
        List edls = this.dataObjectService.findMatching(EDocLiteDefinition.class, criteria.build()).getResults();
        if (null != edls && !edls.isEmpty()) {
            return (EDocLiteDefinition)((Object)edls.get(0));
        }
        return null;
    }

    @Override
    public EDocLiteAssociation getEDocLiteAssociation(String docTypeName) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)EDL_NAME, (Object)docTypeName), PredicateFactory.equal((String)ACTIVE_IND_CRITERIA, (Object)Boolean.TRUE)});
        List edls = this.dataObjectService.findMatching(EDocLiteAssociation.class, criteria.build()).getResults();
        if (null != edls && !edls.isEmpty()) {
            return (EDocLiteAssociation)((Object)edls.get(0));
        }
        return null;
    }

    @Override
    public List<String> getEDocLiteDefinitions() {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)ACTIVE_IND_CRITERIA, (Object)Boolean.TRUE)});
        List defs = this.dataObjectService.findMatching(EDocLiteDefinition.class, criteria.build()).getResults();
        ArrayList<String> names = new ArrayList<String>(defs.size());
        if (!defs.isEmpty()) {
            for (EDocLiteDefinition def : defs) {
                names.add(def.getName());
            }
        }
        return names;
    }

    @Override
    public List<EDocLiteAssociation> getEDocLiteAssociations() {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)ACTIVE_IND_CRITERIA, (Object)Boolean.TRUE)});
        return this.dataObjectService.findMatching(EDocLiteAssociation.class, criteria.build()).getResults();
    }

    @Override
    public List<EDocLiteAssociation> search(EDocLiteAssociation edocLite) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (edocLite.getActiveInd() != null) {
            predicates.add(PredicateFactory.equal((String)ACTIVE_IND_CRITERIA, (Object)edocLite.getActiveInd()));
        }
        if (edocLite.getDefinition() != null) {
            predicates.add(PredicateFactory.like((String)"UPPER(definition)", (CharSequence)("%" + edocLite.getDefinition().toUpperCase() + "%")));
        }
        if (edocLite.getEdlName() != null) {
            predicates.add(PredicateFactory.like((String)"UPPER(edlName)", (CharSequence)("%" + edocLite.getEdlName().toUpperCase() + "%")));
        }
        if (edocLite.getStyle() != null) {
            predicates.add(PredicateFactory.like((String)"UPPER(style)", (CharSequence)("%" + edocLite.getStyle().toUpperCase() + "%")));
        }
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(predicates.toArray(new Predicate[predicates.size()]));
        return this.dataObjectService.findMatching(EDocLiteAssociation.class, builder.build()).getResults();
    }

    @Override
    public EDocLiteAssociation getEDocLiteAssociation(Long associationId) {
        return (EDocLiteAssociation)((Object)this.dataObjectService.find(EDocLiteAssociation.class, (Object)associationId));
    }
}

