/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.ArrayUtils;
import org.kuali.rice.kew.api.WorkflowRuntimeException;

public class RequestParser {
    private static final String PARSED_MULTI_REQUEST_KEY = "__parsedRequestStruct";
    private static final String UPLOADED_FILES_KEY = "__uploadedFiles";
    public static final String WORKFLOW_DOCUMENT_SESSION_KEY = "workflowDocument";
    public static final String GLOBAL_ERRORS_KEY = "org.kuali.rice.edl.impl.GlobalErrors";
    public static final String GLOBAL_MESSAGES_KEY = "org.kuali.rice.edl.impl.GlobalMessages";
    public static final String GLOBAL_FIELD_ERRORS_KEY = "org.kuali.rice.edl.impl.GlobalFieldErrors";
    private HttpServletRequest request;
    private Map<String, String[]> additionalParameters = new HashMap<String, String[]>();

    public RequestParser(HttpServletRequest request) {
        this.request = request;
        request.setAttribute(GLOBAL_ERRORS_KEY, new ArrayList());
        request.setAttribute(GLOBAL_MESSAGES_KEY, new ArrayList());
        request.setAttribute(GLOBAL_FIELD_ERRORS_KEY, new HashMap());
    }

    private static void parseRequest(HttpServletRequest request) {
        if (request.getAttribute(PARSED_MULTI_REQUEST_KEY) != null) {
            return;
        }
        HashMap<String, Object[]> requestParams = new HashMap<String, Object[]>();
        request.setAttribute(PARSED_MULTI_REQUEST_KEY, requestParams);
        DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
        diskFileItemFactory.setSizeThreshold(100);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)diskFileItemFactory);
        List items = null;
        try {
            items = upload.parseRequest(request);
        }
        catch (FileUploadException fue) {
            throw new WorkflowRuntimeException((Throwable)fue);
        }
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            try {
                FileItem item = (FileItem)iter.next();
                if (item.isFormField()) {
                    String fieldName = item.getFieldName();
                    String fieldValue = item.getString("utf-8");
                    Object[] paramVals = null;
                    if (requestParams.containsKey(fieldName)) {
                        paramVals = (String[])requestParams.get(fieldName);
                        paramVals = (String[])ArrayUtils.add((Object[])paramVals, (Object)fieldValue);
                    } else {
                        paramVals = new String[]{fieldValue};
                    }
                    requestParams.put(fieldName, paramVals);
                    continue;
                }
                ArrayList<FileItem> uploadedFiles = (ArrayList<FileItem>)request.getAttribute(UPLOADED_FILES_KEY);
                if (uploadedFiles == null) {
                    uploadedFiles = new ArrayList<FileItem>();
                    request.setAttribute(UPLOADED_FILES_KEY, uploadedFiles);
                }
                uploadedFiles.add(item);
            }
            catch (UnsupportedEncodingException e) {
                throw new WorkflowRuntimeException((Throwable)e);
            }
        }
    }

    public String[] getParameterValues(String paramName) {
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)this.getRequest());
        String[] params = null;
        if (isMultipart) {
            RequestParser.parseRequest(this.getRequest());
            params = (String[])((Map)this.request.getAttribute(PARSED_MULTI_REQUEST_KEY)).get(paramName);
        } else {
            params = this.getRequest().getParameterValues(paramName);
        }
        if (params == null) {
            params = this.additionalParameters.get(paramName);
        }
        return params;
    }

    public void setAttribute(String name, Object value) {
        this.getRequest().setAttribute(name, value);
    }

    public Object getAttribute(String name) {
        return this.getRequest().getAttribute(name);
    }

    public String getParameterValue(String paramName) {
        String[] paramVals = this.getParameterValues(paramName);
        if (paramVals != null) {
            return paramVals[0];
        }
        return null;
    }

    public void setParameterValue(String paramName, String paramValue) {
        this.additionalParameters.put(paramName, new String[]{paramValue});
    }

    public void setParameterValue(String paramName, String[] paramValue) {
        this.additionalParameters.put(paramName, paramValue);
    }

    public List<String> getParameterNames() {
        ArrayList<String> names = new ArrayList<String>();
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)this.getRequest());
        if (isMultipart) {
            RequestParser.parseRequest(this.getRequest());
            Map paramMap = (Map)this.request.getAttribute(PARSED_MULTI_REQUEST_KEY);
            for (String parameterName : paramMap.keySet()) {
                names.add(parameterName);
            }
        } else {
            Enumeration nameEnum = this.getRequest().getParameterNames();
            while (nameEnum.hasMoreElements()) {
                names.add((String)nameEnum.nextElement());
            }
        }
        return names;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public List getUploadList() {
        return (List)this.request.getAttribute(UPLOADED_FILES_KEY);
    }
}

