/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.extract;

import org.apache.log4j.Logger;
import org.kuali.rice.edl.framework.extract.DumpDTO;
import org.kuali.rice.edl.framework.extract.ExtractService;
import org.kuali.rice.edl.impl.extract.Dump;
import org.kuali.rice.edl.impl.extract.Fields;
import org.kuali.rice.edl.impl.extract.dao.ExtractDAO;

public class ExtractServiceImpl
implements ExtractService {
    private static final Logger LOG = Logger.getLogger(ExtractServiceImpl.class);
    private ExtractDAO extractDAO;

    public DumpDTO getDumpByDocumentId(String documentId) {
        return Dump.to(this.getExtractDAO().getDumpByDocumentId(documentId));
    }

    public void saveDump(DumpDTO dumpDTO) {
        try {
            Dump dump = Dump.from(dumpDTO);
            this.getExtractDAO().saveDump(dump);
            if (!dump.getFields().isEmpty()) {
                for (Fields field : dump.getFields()) {
                    this.getExtractDAO().saveField(field);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setExtractDAO(ExtractDAO extractDAO) {
        this.extractDAO = extractDAO;
    }

    public void deleteDump(String docId) {
        try {
            this.getExtractDAO().deleteDump(docId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ExtractDAO getExtractDAO() {
        return this.extractDAO;
    }
}

