/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.exception.DuplicateKeyException;
import org.kuali.rice.krad.exception.PropertiesException;
import org.kuali.rice.krad.service.impl.ConfigurationServiceImpl;

public class PropertyHolderTest {
    private static final String KNOWN_KEY1 = "key1";
    private static final String KNOWN_VALUE1 = "value1";
    private static final String KNOWN_KEY2 = "key 2";
    private static final String KNOWN_VALUE2 = "value 2";
    private static final String KNOWN_KEY3 = "";
    private static final String KNOWN_VALUE3 = "";

    @Test
    public void testIsEmpty_emptyHolder() {
        ConfigurationServiceImpl.PropertyHolder propertyHolder = new ConfigurationServiceImpl.PropertyHolder();
        Assert.assertTrue((boolean)propertyHolder.isEmpty());
    }

    @Test
    public void testIsEmpty_notEmptyHolder() {
        ConfigurationServiceImpl.PropertyHolder propertyHolder = this.buildNonEmpty();
        Assert.assertTrue((!propertyHolder.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testContainsKey_invalidKey() {
        ConfigurationServiceImpl.PropertyHolder propertyHolder = new ConfigurationServiceImpl.PropertyHolder();
        boolean failedAsExpected = false;
        try {
            propertyHolder.containsKey(null);
        }
        catch (IllegalArgumentException e) {
            failedAsExpected = true;
        }
        Assert.assertTrue((boolean)failedAsExpected);
    }

    @Test
    public void testContainsKey_emptyHolder() {
        ConfigurationServiceImpl.PropertyHolder propertyHolder = new ConfigurationServiceImpl.PropertyHolder();
        Assert.assertFalse((boolean)propertyHolder.containsKey(KNOWN_KEY1));
        Assert.assertFalse((boolean)propertyHolder.containsKey(KNOWN_KEY2));
        Assert.assertFalse((boolean)propertyHolder.containsKey(""));
    }

    @Test
    public void testContainsKey_notContains() {
        ConfigurationServiceImpl.PropertyHolder propertyHolder = this.buildNonEmpty();
        Assert.assertFalse((boolean)propertyHolder.containsKey("key1foo"));
        Assert.assertFalse((boolean)propertyHolder.containsKey("key 2foo"));
        Assert.assertFalse((boolean)propertyHolder.containsKey("foo"));
    }

    @Test
    public void testContainsKey_contains() {
        ConfigurationServiceImpl.PropertyHolder propertyHolder = this.buildNonEmpty();
        Assert.assertTrue((boolean)propertyHolder.containsKey(KNOWN_KEY1));
        Assert.assertTrue((boolean)propertyHolder.containsKey(KNOWN_KEY2));
        Assert.assertTrue((boolean)propertyHolder.containsKey(""));
    }

    @Test
    public void testGetProperty_invalidKey() {
        ConfigurationServiceImpl.PropertyHolder propertyHolder = new ConfigurationServiceImpl.PropertyHolder();
        boolean failedAsExpected = false;
        try {
            propertyHolder.getProperty(null);
        }
        catch (IllegalArgumentException e) {
            failedAsExpected = true;
        }
        Assert.assertTrue((boolean)failedAsExpected);
    }

    @Test
    public void testGetProperty_emptyHolder() {
        ConfigurationServiceImpl.PropertyHolder propertyHolder = new ConfigurationServiceImpl.PropertyHolder();
        Assert.assertNull((Object)propertyHolder.getProperty(KNOWN_KEY1));
        Assert.assertNull((Object)propertyHolder.getProperty(KNOWN_KEY2));
        Assert.assertNull((Object)propertyHolder.getProperty(""));
    }

    @Test
    public void testGetProperty_notContains() {
        ConfigurationServiceImpl.PropertyHolder propertyHolder = this.buildNonEmpty();
        Assert.assertNull((Object)propertyHolder.getProperty("key1foo"));
        Assert.assertNull((Object)propertyHolder.getProperty("key 2foo"));
        Assert.assertNull((Object)propertyHolder.getProperty("foo"));
    }

    @Test
    public void testGetProperty_contains() {
        ConfigurationServiceImpl.PropertyHolder propertyHolder = this.buildNonEmpty();
        String value = propertyHolder.getProperty(KNOWN_KEY1);
        Assert.assertEquals((Object)KNOWN_VALUE1, (Object)value);
        value = propertyHolder.getProperty(KNOWN_KEY2);
        Assert.assertEquals((Object)KNOWN_VALUE2, (Object)value);
        value = propertyHolder.getProperty("");
        Assert.assertEquals((Object)"", (Object)value);
    }

    @Test
    public void testSetProperty_invalidKey() {
        ConfigurationServiceImpl.PropertyHolder propertyHolder = new ConfigurationServiceImpl.PropertyHolder();
        boolean failedAsExpected = false;
        try {
            propertyHolder.setProperty(null, KNOWN_VALUE1);
        }
        catch (IllegalArgumentException e) {
            failedAsExpected = true;
        }
        Assert.assertTrue((boolean)failedAsExpected);
    }

    @Test
    public void testSetProperty_invalidValue() {
        ConfigurationServiceImpl.PropertyHolder propertyHolder = new ConfigurationServiceImpl.PropertyHolder();
        boolean failedAsExpected = false;
        try {
            propertyHolder.setProperty(KNOWN_KEY1, null);
        }
        catch (IllegalArgumentException e) {
            failedAsExpected = true;
        }
        Assert.assertTrue((boolean)failedAsExpected);
    }

    @Test
    public void testSetProperty_uniqueKey() {
        ConfigurationServiceImpl.PropertyHolder propertyHolder = new ConfigurationServiceImpl.PropertyHolder();
        propertyHolder.setProperty(KNOWN_KEY1, KNOWN_VALUE1);
        Assert.assertTrue((boolean)propertyHolder.containsKey(KNOWN_KEY1));
        Assert.assertEquals((Object)KNOWN_VALUE1, (Object)propertyHolder.getProperty(KNOWN_KEY1));
    }

    @Test
    public void testSetProperty_duplicateKey() {
        ConfigurationServiceImpl.PropertyHolder propertyHolder = this.buildNonEmpty();
        boolean failedAsExpected = false;
        Assert.assertTrue((boolean)propertyHolder.containsKey(KNOWN_KEY1));
        try {
            propertyHolder.setProperty(KNOWN_KEY1, KNOWN_VALUE1);
        }
        catch (DuplicateKeyException e) {
            failedAsExpected = true;
        }
        Assert.assertTrue((boolean)failedAsExpected);
    }

    @Test
    public void testClearProperty_invalidKey() {
        ConfigurationServiceImpl.PropertyHolder propertyHolder = this.buildNonEmpty();
        boolean failedAsExpected = false;
        try {
            propertyHolder.clearProperty(null);
        }
        catch (IllegalArgumentException e) {
            failedAsExpected = true;
        }
        Assert.assertTrue((boolean)failedAsExpected);
    }

    @Test
    public void testClearProperty_unknownKey() {
        ConfigurationServiceImpl.PropertyHolder propertyHolder = this.buildNonEmpty();
        Assert.assertTrue((boolean)propertyHolder.containsKey(KNOWN_KEY1));
        propertyHolder.clearProperty("key1foo");
        Assert.assertTrue((boolean)propertyHolder.containsKey(KNOWN_KEY1));
    }

    @Test
    public void testClearProperty_knownKey() {
        ConfigurationServiceImpl.PropertyHolder propertyHolder = this.buildNonEmpty();
        Assert.assertTrue((boolean)propertyHolder.containsKey(KNOWN_KEY1));
        Assert.assertTrue((boolean)propertyHolder.containsKey(KNOWN_KEY2));
        propertyHolder.clearProperty(KNOWN_KEY1);
        Assert.assertFalse((boolean)propertyHolder.containsKey(KNOWN_KEY1));
        Assert.assertTrue((boolean)propertyHolder.containsKey(KNOWN_KEY2));
    }

    @Test
    public void testClearProperties_empty() {
        ConfigurationServiceImpl.PropertyHolder propertyHolder = new ConfigurationServiceImpl.PropertyHolder();
        Assert.assertTrue((boolean)propertyHolder.isEmpty());
        propertyHolder.clearProperties();
        Assert.assertTrue((boolean)propertyHolder.isEmpty());
    }

    @Test
    public void testClearProperties_nonEmpty() {
        ConfigurationServiceImpl.PropertyHolder propertyHolder = this.buildNonEmpty();
        Assert.assertFalse((boolean)propertyHolder.isEmpty());
        propertyHolder.clearProperties();
        Assert.assertTrue((boolean)propertyHolder.isEmpty());
    }

    @Test
    public void testGetKeys_empty() {
        ConfigurationServiceImpl.PropertyHolder propertyHolder = new ConfigurationServiceImpl.PropertyHolder();
        Assert.assertTrue((boolean)propertyHolder.isEmpty());
        Iterator i = propertyHolder.getKeys();
        Assert.assertFalse((boolean)i.hasNext());
    }

    @Test
    public void testGetKeys_nonEmpty() {
        ConfigurationServiceImpl.PropertyHolder propertyHolder = this.buildNonEmpty();
        Assert.assertFalse((boolean)propertyHolder.isEmpty());
        Iterator i = propertyHolder.getKeys();
        Assert.assertTrue((boolean)i.hasNext());
        while (i.hasNext()) {
            String key = (String)i.next();
            Assert.assertTrue((boolean)propertyHolder.containsKey(key));
        }
    }

    @Test
    public void testLoadProperties_nullPropertySource() {
        ConfigurationServiceImpl.PropertyHolder propertyHolder = new ConfigurationServiceImpl.PropertyHolder();
        boolean failedAsExpected = false;
        try {
            propertyHolder.loadProperties(null);
        }
        catch (IllegalArgumentException e) {
            failedAsExpected = true;
        }
        Assert.assertTrue((boolean)failedAsExpected);
    }

    @Test
    public void testLoadProperties_invalidPropertySource() {
        ConfigurationServiceImpl.PropertyHolder propertyHolder = new ConfigurationServiceImpl.PropertyHolder();
        ConfigurationServiceImpl.FilePropertySource fps = new ConfigurationServiceImpl.FilePropertySource();
        boolean failedAsExpected = false;
        try {
            propertyHolder.loadProperties((ConfigurationServiceImpl.PropertySource)fps);
        }
        catch (IllegalStateException e) {
            failedAsExpected = true;
        }
        Assert.assertTrue((boolean)failedAsExpected);
    }

    @Test
    public void testLoadProperties_unknownPropertySource() {
        ConfigurationServiceImpl.PropertyHolder propertyHolder = new ConfigurationServiceImpl.PropertyHolder();
        ConfigurationServiceImpl.FilePropertySource fps = new ConfigurationServiceImpl.FilePropertySource();
        fps.setFileName("foo");
        boolean failedAsExpected = false;
        try {
            propertyHolder.loadProperties((ConfigurationServiceImpl.PropertySource)fps);
        }
        catch (PropertiesException e) {
            failedAsExpected = true;
        }
        Assert.assertTrue((boolean)failedAsExpected);
    }

    private final ConfigurationServiceImpl.PropertyHolder buildNonEmpty() {
        ConfigurationServiceImpl.PropertyHolder propertyHolder = new ConfigurationServiceImpl.PropertyHolder();
        propertyHolder.setProperty(KNOWN_KEY1, KNOWN_VALUE1);
        propertyHolder.setProperty(KNOWN_KEY2, KNOWN_VALUE2);
        propertyHolder.setProperty("", "");
        return propertyHolder;
    }
}

