/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kcb.service.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kcb.bo.RecipientDelivererConfig;
import org.kuali.rice.kcb.bo.RecipientPreference;
import org.kuali.rice.kcb.deliverer.MessageDeliverer;
import org.kuali.rice.kcb.exception.ErrorList;
import org.kuali.rice.kcb.service.RecipientPreferenceService;
import org.kuali.rice.kcb.service.impl.BusinessObjectServiceImpl;

public class RecipientPreferenceServiceImpl
extends BusinessObjectServiceImpl
implements RecipientPreferenceService {
    @Override
    public RecipientPreference getRecipientPreference(String recipientId, String key) {
        HashMap<String, String> fields = new HashMap<String, String>(2);
        fields.put("recipientId", recipientId);
        fields.put("property", key);
        Collection prefs = this.dao.findMatching(RecipientPreference.class, fields);
        assert (prefs.size() <= 1);
        if (prefs.size() > 0) {
            return (RecipientPreference)prefs.iterator().next();
        }
        return null;
    }

    @Override
    public void deleteRecipientPreference(RecipientPreference pref) {
        this.dao.delete((Object)pref);
    }

    @Override
    public HashMap<String, String> getRecipientPreferences(String recipientId) {
        HashMap<String, String> fields = new HashMap<String, String>(1);
        fields.put("recipientId", recipientId);
        HashMap<String, String> prefs = new HashMap<String, String>();
        Collection userPrefs = this.dao.findMatching(RecipientPreference.class, fields);
        for (RecipientPreference p : userPrefs) {
            prefs.put(p.getProperty(), p.getValue());
        }
        return prefs;
    }

    @Override
    public void saveRecipientPreference(RecipientPreference pref) {
        this.dao.save((Object)pref);
    }

    @Override
    public void saveRecipientPreferences(String recipientId, HashMap<String, String> prefs, MessageDeliverer deliverer) throws ErrorList {
        deliverer.validatePreferenceValues(prefs);
        for (Map.Entry<String, String> entry : prefs.entrySet()) {
            String prop = entry.getKey();
            String value = entry.getValue();
            RecipientPreference currentPreference = this.getRecipientPreference(recipientId, prop);
            if (currentPreference != null) {
                currentPreference.setRecipientId(recipientId);
                currentPreference.setProperty(prop);
                currentPreference.setValue(value);
                this.dao.save((Object)currentPreference);
                continue;
            }
            RecipientPreference recipientPreference = new RecipientPreference();
            recipientPreference.setRecipientId(recipientId);
            recipientPreference.setProperty(prop);
            recipientPreference.setValue(value);
            this.dao.save((Object)recipientPreference);
        }
    }

    @Override
    public void removeRecipientDelivererConfigs(String recipientId) {
        HashMap<String, String> fields = new HashMap<String, String>(1);
        fields.put("recipientId", recipientId);
        this.dao.deleteMatching(RecipientDelivererConfig.class, fields);
    }

    @Override
    public void saveRecipientDelivererConfig(String recipientId, String delivererName, String[] channels) {
        if (channels == null || channels.length == 0) {
            return;
        }
        for (String channel : channels) {
            RecipientDelivererConfig config = new RecipientDelivererConfig();
            config.setRecipientId(recipientId);
            config.setDelivererName(delivererName);
            config.setChannel(channel);
            Collection<RecipientDelivererConfig> deliverers = this.getDeliverersForRecipientAndChannel(recipientId, channel);
            if (deliverers != null) {
                for (RecipientDelivererConfig deliverer : deliverers) {
                    if (!deliverer.getDelivererName().equals(delivererName)) continue;
                    throw new RiceRuntimeException("Attempting to save a duplicate Recipient Deliverer Config.");
                }
            }
            this.dao.save((Object)config);
        }
    }

    @Override
    public Collection<RecipientDelivererConfig> getDeliverersForRecipient(String recipientId) {
        HashMap<String, String> fields = new HashMap<String, String>(1);
        fields.put("recipientId", recipientId);
        return this.dao.findMatching(RecipientDelivererConfig.class, fields);
    }

    @Override
    public Collection<RecipientDelivererConfig> getDeliverersForRecipientAndChannel(String recipientId, String channel) {
        HashMap<String, String> fields = new HashMap<String, String>(1);
        fields.put("recipientId", recipientId);
        fields.put("channel", channel);
        return this.dao.findMatching(RecipientDelivererConfig.class, fields);
    }
}

