/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.bo;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.joda.time.DateTime;
import org.kuali.rice.ken.api.notification.Notification;
import org.kuali.rice.ken.api.notification.NotificationContract;
import org.kuali.rice.ken.api.notification.NotificationRecipient;
import org.kuali.rice.ken.api.notification.NotificationSender;
import org.kuali.rice.ken.bo.Lockable;
import org.kuali.rice.ken.bo.NotificationChannelBo;
import org.kuali.rice.ken.bo.NotificationContentTypeBo;
import org.kuali.rice.ken.bo.NotificationPriorityBo;
import org.kuali.rice.ken.bo.NotificationProducerBo;
import org.kuali.rice.ken.bo.NotificationRecipientBo;
import org.kuali.rice.ken.bo.NotificationSenderBo;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;

@Entity
@Table(name="KREN_NTFCTN_T")
public class NotificationBo
extends PersistableBusinessObjectBase
implements NotificationContract,
Lockable {
    @Id
    @GeneratedValue(generator="KREN_NTFCTN_S")
    @GenericGenerator(name="KREN_NTFCTN_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KREN_NTFCTN_S"), @Parameter(name="value_column", value="id")})
    @Column(name="NTFCTN_ID")
    private Long id;
    @Column(name="DELIV_TYP", nullable=false)
    private String deliveryType;
    @Column(name="CRTE_DTTM", nullable=false)
    private Timestamp creationDateTimeValue;
    @Column(name="SND_DTTM", nullable=true)
    private Timestamp sendDateTimeValue;
    @Column(name="AUTO_RMV_DTTM", nullable=true)
    private Timestamp autoRemoveDateTimeValue;
    @Column(name="TTL", nullable=true)
    private String title;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Column(name="CNTNT", nullable=false)
    private String content;
    @Column(name="PROCESSING_FLAG", nullable=false)
    private String processingFlag = "UNRESOLVED";
    @Column(name="LOCKD_DTTM", nullable=true)
    private Timestamp lockedDateValue;
    @Column(name="DOC_TYP_NM", nullable=true)
    private String docTypeName;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.REFRESH, CascadeType.DETACH})
    @JoinColumn(name="PRIO_ID")
    private NotificationPriorityBo priority;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.REFRESH, CascadeType.DETACH})
    @JoinColumn(name="CNTNT_TYP_ID")
    private NotificationContentTypeBo contentType;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.REFRESH, CascadeType.DETACH})
    @JoinColumn(name="CHNL_ID")
    private NotificationChannelBo channel;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.REFRESH, CascadeType.DETACH})
    @JoinColumn(name="PRODCR_ID")
    private NotificationProducerBo producer;
    @OneToMany(cascade={CascadeType.ALL}, targetEntity=NotificationRecipientBo.class, mappedBy="notification")
    @OrderBy(value="id ASC")
    private List<NotificationRecipientBo> recipients = new ArrayList<NotificationRecipientBo>();
    @OneToMany(cascade={CascadeType.ALL}, targetEntity=NotificationSenderBo.class, mappedBy="notification")
    @OrderBy(value="id ASC")
    private List<NotificationSenderBo> senders = new ArrayList<NotificationSenderBo>();

    public Timestamp getCreationDateTimeValue() {
        return this.creationDateTimeValue;
    }

    public DateTime getCreationDateTime() {
        return this.creationDateTimeValue == null ? null : new DateTime((Object)this.creationDateTimeValue);
    }

    public void setCreationDateTimeValue(Timestamp created) {
        this.creationDateTimeValue = created;
    }

    public Integer getLockVerNbr() {
        return super.getVersionNumber().intValue();
    }

    public void setLockVerNbr(Integer lockVerNbr) {
        super.setVersionNumber(Long.valueOf(lockVerNbr.longValue()));
    }

    public List<NotificationRecipientBo> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<NotificationRecipientBo> recipients) {
        this.recipients = recipients;
    }

    public NotificationRecipientBo getRecipient(int index) {
        return this.recipients.get(index);
    }

    public void addRecipient(NotificationRecipientBo recipient) {
        this.recipients.add(recipient);
    }

    public List<NotificationSenderBo> getSenders() {
        return this.senders;
    }

    public void setSenders(List<NotificationSenderBo> senders) {
        this.senders = senders;
    }

    public NotificationSenderBo getSender(int index) {
        return this.senders.get(index);
    }

    public void addSender(NotificationSenderBo sender) {
        this.senders.add(sender);
    }

    public Timestamp getAutoRemoveDateTimeValue() {
        return this.autoRemoveDateTimeValue;
    }

    public DateTime getAutoRemoveDateTime() {
        return this.autoRemoveDateTimeValue == null ? null : new DateTime((Object)this.autoRemoveDateTimeValue);
    }

    public void setAutoRemoveDateTimeValue(Timestamp autoRemoveDateTimeValue) {
        this.autoRemoveDateTimeValue = autoRemoveDateTimeValue;
    }

    public NotificationChannelBo getChannel() {
        return this.channel;
    }

    public void setChannel(NotificationChannelBo channel) {
        this.channel = channel;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public NotificationContentTypeBo getContentType() {
        return this.contentType;
    }

    public void setContentType(NotificationContentTypeBo contentType) {
        this.contentType = contentType;
    }

    public String getDeliveryType() {
        return this.deliveryType;
    }

    public void setDeliveryType(String deliveryType) {
        this.deliveryType = deliveryType.toUpperCase();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public NotificationPriorityBo getPriority() {
        return this.priority;
    }

    public void setPriority(NotificationPriorityBo priority) {
        this.priority = priority;
    }

    public NotificationProducerBo getProducer() {
        return this.producer;
    }

    public void setProducer(NotificationProducerBo producer) {
        this.producer = producer;
    }

    public Timestamp getSendDateTimeValue() {
        return this.sendDateTimeValue;
    }

    public DateTime getSendDateTime() {
        return this.sendDateTimeValue == null ? null : new DateTime((Object)this.sendDateTimeValue);
    }

    public void setSendDateTimeValue(Timestamp sendDateTimeValue) {
        this.sendDateTimeValue = sendDateTimeValue;
    }

    public String getProcessingFlag() {
        return this.processingFlag;
    }

    public void setProcessingFlag(String processingFlag) {
        this.processingFlag = processingFlag;
    }

    @Override
    public Timestamp getLockedDateValue() {
        return this.lockedDateValue;
    }

    public DateTime getLockedDate() {
        return this.lockedDateValue == null ? null : new DateTime((Object)this.lockedDateValue);
    }

    @Override
    public void setLockedDateValue(Timestamp lockedDateValue) {
        this.lockedDateValue = lockedDateValue;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContentMessage() {
        return StringUtils.substringBetween((String)this.content, (String)"<message><![CDATA[", (String)"]]></message>");
    }

    public String getDocTypeName() {
        return this.docTypeName;
    }

    public void setDocTypeName(String docTypeName) {
        this.docTypeName = docTypeName;
    }

    public static Notification to(NotificationBo bo) {
        if (bo == null) {
            return null;
        }
        return Notification.Builder.create((NotificationContract)bo).build();
    }

    public static NotificationBo from(Notification im) {
        if (im == null) {
            return null;
        }
        NotificationBo bo = new NotificationBo();
        bo.setId(im.getId());
        bo.setVersionNumber(im.getVersionNumber());
        bo.setObjectId(im.getObjectId());
        bo.setDeliveryType(im.getDeliveryType());
        bo.setCreationDateTimeValue(im.getCreationDateTime() == null ? null : new Timestamp(im.getCreationDateTime().getMillis()));
        bo.setSendDateTimeValue(im.getSendDateTime() == null ? null : new Timestamp(im.getSendDateTime().getMillis()));
        bo.setAutoRemoveDateTimeValue(im.getAutoRemoveDateTime() == null ? null : new Timestamp(im.getAutoRemoveDateTime().getMillis()));
        bo.setTitle(im.getTitle());
        bo.setContent(im.getContent());
        bo.setLockedDateValue(im.getLockedDate() == null ? null : new Timestamp(im.getLockedDate().getMillis()));
        bo.setDocTypeName(im.getDocTypeName());
        bo.setPriority(NotificationPriorityBo.from(im.getPriority()));
        bo.setContentType(NotificationContentTypeBo.from(im.getContentType()));
        bo.setChannel(NotificationChannelBo.from(im.getChannel()));
        bo.setProducer(NotificationProducerBo.from(im.getProducer()));
        ArrayList<NotificationRecipientBo> tempRecipients = new ArrayList<NotificationRecipientBo>();
        if (CollectionUtils.isNotEmpty((Collection)im.getRecipients())) {
            for (NotificationRecipient recipient : im.getRecipients()) {
                tempRecipients.add(NotificationRecipientBo.from(recipient));
            }
            bo.setRecipients(tempRecipients);
        }
        ArrayList<NotificationSenderBo> tempSenders = new ArrayList<NotificationSenderBo>();
        if (CollectionUtils.isNotEmpty((Collection)im.getSenders())) {
            for (NotificationSender sender : im.getSenders()) {
                tempSenders.add(NotificationSenderBo.from(sender));
            }
            bo.setSenders(tempSenders);
        }
        return bo;
    }
}

