/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.service.impl;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.kuali.rice.core.framework.persistence.dao.GenericDao;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.bo.NotificationMessageDelivery;
import org.kuali.rice.ken.dao.NotificationMessegeDeliveryDao;
import org.kuali.rice.ken.service.NotificationMessageDeliveryService;

public class NotificationMessageDeliveryServiceImpl
implements NotificationMessageDeliveryService {
    private static Logger LOG = Logger.getLogger(NotificationMessageDeliveryServiceImpl.class);
    private GenericDao businessObjectDao;
    private NotificationMessegeDeliveryDao ntdDao;

    public NotificationMessageDeliveryServiceImpl(GenericDao businessObjectDao, NotificationMessegeDeliveryDao ntdDao) {
        this.businessObjectDao = businessObjectDao;
        this.ntdDao = ntdDao;
    }

    @Override
    public NotificationMessageDelivery getNotificationMessageDelivery(Long id) {
        HashMap<String, Long> primaryKeys = new HashMap<String, Long>();
        primaryKeys.put("id", id);
        return (NotificationMessageDelivery)this.businessObjectDao.findByPrimaryKey(NotificationMessageDelivery.class, primaryKeys);
    }

    @Override
    public NotificationMessageDelivery getNotificationMessageDeliveryByDelivererId(String id) {
        HashMap<String, String> c = new HashMap<String, String>();
        c.put("deliverySystemId", id);
        Collection results = this.businessObjectDao.findMatching(NotificationMessageDelivery.class, c);
        if (results == null || results.size() == 0) {
            return null;
        }
        if (results.size() > 1) {
            throw new RuntimeException("More than one message delivery found with the following delivery system id: " + id);
        }
        return (NotificationMessageDelivery)results.iterator().next();
    }

    @Override
    public Collection<NotificationMessageDelivery> getNotificationMessageDeliveries() {
        return this.businessObjectDao.findAll(NotificationMessageDelivery.class);
    }

    @Override
    public Collection<NotificationMessageDelivery> getNotificationMessageDeliveries(NotificationBo notification, String userRecipientId) {
        HashMap<String, Object> c = new HashMap<String, Object>();
        c.put("notification", notification.getId());
        c.put("userRecipientId", userRecipientId);
        return this.businessObjectDao.findMatching(NotificationMessageDelivery.class, c);
    }

    @Override
    public Collection<NotificationMessageDelivery> takeMessageDeliveriesForDispatch() {
        Collection messageDeliveries = this.ntdDao.getUndeliveredMessageDelivers(this.businessObjectDao);
        LOG.debug((Object)("Retrieved " + messageDeliveries.size() + " available message deliveries: " + System.currentTimeMillis()));
        for (NotificationMessageDelivery delivery : messageDeliveries) {
            delivery.setLockedDateValue(new Timestamp(System.currentTimeMillis()));
            this.businessObjectDao.save((Object)delivery);
        }
        return messageDeliveries;
    }

    @Override
    public Collection<NotificationMessageDelivery> takeMessageDeliveriesForAutoRemoval() {
        Collection<NotificationMessageDelivery> messageDeliveries = this.ntdDao.getMessageDeliveriesForAutoRemoval(new Timestamp(System.currentTimeMillis()), this.businessObjectDao);
        for (NotificationMessageDelivery d : messageDeliveries) {
            d.setLockedDateValue(new Timestamp(System.currentTimeMillis()));
            this.businessObjectDao.save((Object)d);
        }
        return messageDeliveries;
    }

    @Override
    public void unlockMessageDelivery(NotificationMessageDelivery messageDelivery) {
        HashMap<String, Long> c = new HashMap<String, Long>();
        c.put("deliverySystemId", messageDelivery.getId());
        Collection deliveries = this.businessObjectDao.findMatching(NotificationMessageDelivery.class, c, true, 0L);
        if (deliveries == null || deliveries.size() == 0) {
            throw new RuntimeException("NotificationMessageDelivery #" + messageDelivery.getId() + " not found to unlock");
        }
        NotificationMessageDelivery d = (NotificationMessageDelivery)deliveries.iterator().next();
        d.setLockedDateValue(null);
        this.businessObjectDao.save((Object)d);
    }
}

