/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.service.impl;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.core.framework.persistence.dao.GenericDao;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.bo.NotificationMessageDelivery;
import org.kuali.rice.ken.bo.NotificationRecipientBo;
import org.kuali.rice.ken.bo.NotificationResponseBo;
import org.kuali.rice.ken.dao.NotificationDao;
import org.kuali.rice.ken.deliverer.impl.KEWActionListMessageDeliverer;
import org.kuali.rice.ken.service.NotificationAuthorizationService;
import org.kuali.rice.ken.service.NotificationMessageContentService;
import org.kuali.rice.ken.service.NotificationMessageDeliveryService;
import org.kuali.rice.ken.service.NotificationRecipientService;
import org.kuali.rice.ken.service.NotificationService;
import org.kuali.rice.ken.service.NotificationWorkflowDocumentService;

public class NotificationServiceImpl
implements NotificationService {
    private static Logger LOG = Logger.getLogger(NotificationServiceImpl.class);
    private GenericDao businessObjectDao;
    private NotificationDao notDao;
    private NotificationMessageContentService messageContentService;
    private NotificationAuthorizationService notificationAuthorizationService;
    private NotificationRecipientService notificationRecipientService;
    private NotificationWorkflowDocumentService notificationWorkflowDocumentService;
    private NotificationMessageDeliveryService notificationMessageDeliveryService;

    public NotificationServiceImpl(GenericDao businessObjectDao, NotificationMessageContentService messageContentService, NotificationAuthorizationService notificationAuthorizationService, NotificationRecipientService notificationRecipientService, NotificationWorkflowDocumentService notificationWorkflowDocumentService, NotificationMessageDeliveryService notificationMessageDeliveryService, NotificationDao notDao) {
        this.businessObjectDao = businessObjectDao;
        this.messageContentService = messageContentService;
        this.notificationAuthorizationService = notificationAuthorizationService;
        this.notificationRecipientService = notificationRecipientService;
        this.notificationWorkflowDocumentService = notificationWorkflowDocumentService;
        this.notificationMessageDeliveryService = notificationMessageDeliveryService;
        this.notDao = notDao;
    }

    @Override
    public NotificationBo getNotification(Long id) {
        HashMap<String, Long> primaryKeys = new HashMap<String, Long>();
        primaryKeys.put("id", id);
        return (NotificationBo)this.businessObjectDao.findByPrimaryKey(NotificationBo.class, primaryKeys);
    }

    @Override
    public NotificationResponseBo sendNotification(String notificationMessageAsXml) throws IOException, XmlException {
        NotificationBo notification = this.messageContentService.parseNotificationRequestMessage(notificationMessageAsXml);
        return this.sendNotification(notification);
    }

    @Override
    public NotificationResponseBo sendNotification(NotificationBo notification) {
        NotificationResponseBo response = new NotificationResponseBo();
        boolean producerAuthorizedForChannel = this.notificationAuthorizationService.isProducerAuthorizedToSendNotificationForChannel(notification.getProducer(), notification.getChannel());
        if (!producerAuthorizedForChannel) {
            LOG.error((Object)("Producer " + (Object)((Object)notification.getProducer()) + " is not authorized to send messages to channel " + (Object)((Object)notification.getChannel())));
            response.setStatus("Failure");
            response.setMessage("The notification message was received by the system; however, we cannot process it because the Producer specified cannot send notifications for the Notification Channel specified.");
            return response;
        }
        for (int i = 0; i < notification.getRecipients().size(); ++i) {
            NotificationRecipientBo recipient = notification.getRecipient(i);
            boolean validRecipient = this.notificationRecipientService.isRecipientValid(recipient.getRecipientId(), recipient.getRecipientType());
            if (validRecipient) continue;
            response.setStatus("Failure");
            response.setMessage("The notification message was received by the system; however, we cannot process it because one of the recipients that was specified was invalid and is not registered in the system. - recipientId=" + recipient.getRecipientId() + ", recipientType=" + recipient.getRecipientType());
            return response;
        }
        if (notification.getCreationDateTime() == null) {
            notification.setCreationDateTimeValue(new Timestamp(System.currentTimeMillis()));
        }
        if (notification.getSendDateTime() == null) {
            notification.setSendDateTimeValue(new Timestamp(System.currentTimeMillis()));
        }
        if (notification.getAutoRemoveDateTime() != null && notification.getAutoRemoveDateTimeValue().before(notification.getSendDateTimeValue())) {
            response.setStatus("Failure");
            response.setMessage("The notification message was received by the system; however, we cannot process it because the specified auto-remove date is before the send date.");
            return response;
        }
        if (!notification.getDeliveryType().equalsIgnoreCase("ACK") && !notification.getDeliveryType().equalsIgnoreCase("FYI")) {
            response.setStatus("Failure");
            response.setMessage("The notification message was received by the system; however, we cannot process it because the specified delivery type was invalid. - deliveryType=" + notification.getDeliveryType());
            return response;
        }
        try {
            this.businessObjectDao.save((Object)notification);
        }
        catch (Exception e) {
            response.setStatus("Failure");
            response.setMessage("The notification message was received by the system; however, we cannot process it because there was a problem when trying to save the notification to the database.");
            return response;
        }
        response.setMessage("The notification message has been successfully received by the system and will be processed and delivered.");
        response.setNotificationId(notification.getId());
        return response;
    }

    public Collection getNotificationsForRecipientByType(String contentTypeName, String recipientId) {
        HashMap<String, String> queryCriteria = new HashMap<String, String>();
        queryCriteria.put("contentType.name", contentTypeName);
        queryCriteria.put("recipients.recipientId", recipientId);
        return this.businessObjectDao.findMatching(NotificationBo.class, queryCriteria);
    }

    @Override
    public void dismissNotificationMessageDelivery(Long id, String user, String cause) {
        NotificationMessageDelivery nmd = this.notificationMessageDeliveryService.getNotificationMessageDelivery(id);
        this.dismissNotificationMessageDelivery(nmd, user, cause);
    }

    public void dismissNotificationMessageDelivery(NotificationMessageDelivery nmd, String user, String cause) {
        NotificationBo notification = nmd.getNotification();
        Collection<NotificationMessageDelivery> userDeliveries = this.notificationMessageDeliveryService.getNotificationMessageDeliveries(notification, nmd.getUserRecipientId());
        String targetStatus = "autoremove".equals(cause) ? "AUTO_REMOVED" : "REMOVED";
        KEWActionListMessageDeliverer deliverer = new KEWActionListMessageDeliverer();
        for (NotificationMessageDelivery messageDelivery : userDeliveries) {
            if (!"DELIVERED".equals(messageDelivery.getMessageDeliveryStatus())) {
                LOG.info((Object)("Skipping dismissal of non-delivered message delivery #" + messageDelivery.getId()));
            } else if (targetStatus.equals(messageDelivery.getMessageDeliveryStatus())) {
                LOG.info((Object)("Skipping dismissal of already removed message delivery #" + messageDelivery.getId()));
            } else {
                LOG.debug((Object)("Dismissing message delivery #" + messageDelivery.getId() + " " + messageDelivery.getVersionNumber()));
                deliverer.dismissMessageDelivery(messageDelivery, user, cause);
            }
            messageDelivery.setMessageDeliveryStatus(targetStatus);
            LOG.debug((Object)("Saving message delivery #" + messageDelivery.getId() + " " + messageDelivery.getVersionNumber()));
            this.businessObjectDao.save((Object)messageDelivery);
            LOG.debug((Object)("Message delivery '" + messageDelivery.getId() + "' for notification '" + messageDelivery.getNotification().getId() + "' was successfully dismissed."));
        }
    }

    @Override
    public Collection<NotificationBo> takeNotificationsForResolution() {
        Collection available_notifications = this.notDao.findMatchedNotificationsForResolution(new Timestamp(System.currentTimeMillis()), this.businessObjectDao);
        if (available_notifications != null) {
            for (NotificationBo notification : available_notifications) {
                LOG.info((Object)("notification: " + notification));
                notification.setLockedDateValue(new Timestamp(System.currentTimeMillis()));
                this.businessObjectDao.save((Object)notification);
            }
        }
        return available_notifications;
    }

    @Override
    public void unlockNotification(NotificationBo notification) {
        Collection notifications = this.notDao.findMatchedNotificationsForUnlock(notification, this.businessObjectDao);
        if (notifications == null || notifications.size() == 0) {
            throw new RuntimeException("Notification #" + notification.getId() + " not found to unlock");
        }
        NotificationBo n = (NotificationBo)notifications.iterator().next();
        n.setLockedDateValue(null);
        this.businessObjectDao.save((Object)n);
    }
}

