/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.service.impl;

import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.kuali.rice.core.framework.persistence.dao.GenericDao;
import org.kuali.rice.ken.bo.UserChannelSubscriptionBo;
import org.kuali.rice.ken.service.NotificationChannelService;
import org.kuali.rice.ken.service.UserPreferenceService;

public class UserPreferenceServiceImpl
implements UserPreferenceService {
    private GenericDao businessObjectDao;
    private NotificationChannelService notificationChannelService;
    private static final Logger LOG = Logger.getLogger(UserPreferenceServiceImpl.class);

    public UserPreferenceServiceImpl(GenericDao businessObjectDao, NotificationChannelService notificationChannelService) {
        this.businessObjectDao = businessObjectDao;
        this.notificationChannelService = notificationChannelService;
    }

    @Override
    public Collection<UserChannelSubscriptionBo> getCurrentSubscriptions(String userid) {
        UserChannelSubscriptionBo userChannelSubscription = new UserChannelSubscriptionBo();
        userChannelSubscription.setUserId(userid);
        return this.businessObjectDao.findMatchingByExample((Object)userChannelSubscription);
    }

    @Override
    public UserChannelSubscriptionBo getSubscription(String channelid, String userid) {
        HashMap<String, String> uniqueKeys = new HashMap<String, String>();
        uniqueKeys.put("channel.id", channelid);
        uniqueKeys.put("userId", userid);
        UserChannelSubscriptionBo subscription = (UserChannelSubscriptionBo)((Object)this.businessObjectDao.findByUniqueKey(UserChannelSubscriptionBo.class, uniqueKeys));
        return subscription;
    }

    @Override
    public void subscribeToChannel(UserChannelSubscriptionBo userChannelSubscription) {
        LOG.info((Object)"Saving channel subscription");
        try {
            this.businessObjectDao.save((Object)userChannelSubscription);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception when saving userChannelSubscription");
        }
        LOG.debug((Object)"Channel subscription saved");
    }

    @Override
    public void unsubscribeFromChannel(UserChannelSubscriptionBo userChannelSubscription) {
        LOG.info((Object)"unsubscribing from channel");
        try {
            this.businessObjectDao.delete((Object)userChannelSubscription);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception when deleting userChannelSubscription");
        }
    }
}

