/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.web.spring;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.coreservice.api.CoreServiceApiServiceLocator;
import org.kuali.rice.coreservice.api.namespace.Namespace;
import org.kuali.rice.coreservice.api.namespace.NamespaceService;
import org.kuali.rice.ken.exception.ErrorList;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.springframework.web.servlet.mvc.multiaction.MultiActionController;

public class BaseSendNotificationController
extends MultiActionController {
    private static final Logger LOG = Logger.getLogger(BaseSendNotificationController.class);
    private static final String USER_RECIPS_PARAM = "userRecipients";
    private static final String WORKGROUP_RECIPS_PARAM = "workgroupRecipients";
    private static final String WORKGROUP_NAMESPACE_CODES_PARAM = "workgroupNamespaceCodes";
    private static final String SPLIT_REGEX = "(%2C|,)";
    private static IdentityService identityService;
    private static GroupService groupService;
    private static NamespaceService namespaceService;

    protected static IdentityService getIdentityService() {
        if (identityService == null) {
            identityService = KimApiServiceLocator.getIdentityService();
        }
        return identityService;
    }

    protected static GroupService getGroupService() {
        if (groupService == null) {
            groupService = KimApiServiceLocator.getGroupService();
        }
        return groupService;
    }

    protected static NamespaceService getNamespaceService() {
        if (namespaceService == null) {
            namespaceService = CoreServiceApiServiceLocator.getNamespaceService();
        }
        return namespaceService;
    }

    protected String[] parseUserRecipients(HttpServletRequest request) {
        return this.parseCommaSeparatedValues(request, USER_RECIPS_PARAM);
    }

    protected String[] parseWorkgroupRecipients(HttpServletRequest request) {
        return this.parseCommaSeparatedValues(request, WORKGROUP_RECIPS_PARAM);
    }

    protected String[] parseWorkgroupNamespaceCodes(HttpServletRequest request) {
        return this.parseCommaSeparatedValues(request, WORKGROUP_NAMESPACE_CODES_PARAM);
    }

    protected String[] parseCommaSeparatedValues(HttpServletRequest request, String param) {
        String vals = request.getParameter(param);
        if (vals != null) {
            String[] split = vals.split(SPLIT_REGEX);
            ArrayList<String> strs = new ArrayList<String>();
            for (String component : split) {
                if (!StringUtils.isNotBlank((String)component)) continue;
                strs.add(component.trim());
            }
            return strs.toArray(new String[strs.size()]);
        }
        return new String[0];
    }

    protected boolean isUserRecipientValid(String user, ErrorList errors) {
        boolean valid = true;
        Principal principal = BaseSendNotificationController.getIdentityService().getPrincipalByPrincipalName(user);
        if (principal == null) {
            valid = false;
            errors.addError("'" + user + "' is not a valid principal name");
        }
        return valid;
    }

    protected boolean isWorkgroupRecipientValid(String groupName, String namespaceCode, ErrorList errors) {
        Namespace nSpace = BaseSendNotificationController.getNamespaceService().getNamespace(namespaceCode);
        if (nSpace == null) {
            errors.addError('\'' + namespaceCode + "' is not a valid namespace code");
            return false;
        }
        Group i = BaseSendNotificationController.getGroupService().getGroupByNamespaceCodeAndName(namespaceCode, groupName);
        if (i == null) {
            errors.addError('\'' + groupName + "' is not a valid group name for namespace code '" + namespaceCode + '\'');
            return false;
        }
        return true;
    }

    protected String getPrincipalIdFromIdOrName(String principalIdOrName) {
        Principal principal = KimApiServiceLocator.getIdentityService().getPrincipal(principalIdOrName);
        if (principal == null) {
            principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(principalIdOrName);
        }
        if (principal == null) {
            throw new RiceIllegalArgumentException("Could not locate a principal as initiator with the given remoteUser of " + principalIdOrName);
        }
        return principal.getPrincipalId();
    }
}

