/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionitem;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.kew.api.action.ActionItem;
import org.kuali.rice.kew.api.action.ActionItemContract;
import org.kuali.rice.kew.api.action.RecipientType;
import org.kuali.rice.kew.api.util.CodeTranslator;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="KREW_ACTN_ITM_T")
@NamedQueries(value={@NamedQuery(name="ActionItem.QuickLinks.FindActionListStatsByPrincipalId", query="SELECT docName, COUNT(*) FROM ActionItem WHERE principalId = :principalId AND (delegationType IS null OR delegationType != :delegationType) GROUP BY docName")})
public class ActionItem
implements ActionItemContract,
Serializable {
    private static final long serialVersionUID = -1079562205125660151L;
    @Id
    @GeneratedValue(generator="KREW_ACTN_ITM_S")
    @GenericGenerator(name="KREW_ACTN_ITM_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KREW_ACTN_ITM_S"), @Parameter(name="value_column", value="id")})
    @Column(name="ACTN_ITM_ID")
    private String id;
    @Column(name="PRNCPL_ID")
    private String principalId;
    @Column(name="ASND_DT")
    private Timestamp dateAssigned;
    @Column(name="RQST_CD")
    private String actionRequestCd;
    @Column(name="ACTN_RQST_ID", nullable=false)
    private String actionRequestId;
    @Column(name="DOC_HDR_ID")
    private String documentId;
    @Column(name="GRP_ID")
    private String groupId;
    @Column(name="DOC_HDR_TTL")
    private String docTitle;
    @Column(name="DOC_TYP_LBL")
    private String docLabel;
    @Column(name="DOC_HDLR_URL")
    private String docHandlerURL;
    @Column(name="DOC_TYP_NM")
    private String docName;
    @Column(name="RSP_ID")
    private String responsibilityId = "1";
    @Column(name="ROLE_NM")
    private String roleName;
    @Column(name="DLGN_PRNCPL_ID")
    private String delegatorPrincipalId;
    @Column(name="DLGN_GRP_ID")
    private String delegatorGroupId;
    @Column(name="DLGN_TYP")
    private String delegationType;
    @Column(name="RQST_LBL")
    private String requestLabel;
    @Transient
    private String dateAssignedStringValue;

    public void beforeInsert() {
        OrmUtils.populateAutoIncValue((Object)this, (EntityManager)KEWServiceLocator.getEntityManagerFactory().createEntityManager());
    }

    @Deprecated
    public String getActionToTake() {
        return null;
    }

    @Deprecated
    public String getDateAssignedString() {
        return null;
    }

    public String getDateAssignedStringValue() {
        if (StringUtils.isBlank((String)this.dateAssignedStringValue)) {
            return RiceConstants.getDefaultDateFormat().format(this.getDateAssigned());
        }
        return this.dateAssignedStringValue;
    }

    public void setDateAssignedStringValue(String dateAssignedStringValue) {
        this.dateAssignedStringValue = dateAssignedStringValue;
    }

    public String getId() {
        return this.id;
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public Timestamp getDateAssigned() {
        return this.dateAssigned;
    }

    public DateTime getDateTimeAssigned() {
        return new DateTime((Object)this.dateAssigned);
    }

    public String getActionRequestCd() {
        return this.actionRequestCd;
    }

    public String getActionRequestId() {
        return this.actionRequestId;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getDocTitle() {
        return this.docTitle;
    }

    public String getDocLabel() {
        return this.docLabel;
    }

    public String getDocHandlerURL() {
        return this.docHandlerURL;
    }

    public String getDocName() {
        return this.docName;
    }

    public String getResponsibilityId() {
        return this.responsibilityId;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getDelegatorPrincipalId() {
        return this.delegatorPrincipalId;
    }

    public String getDelegatorGroupId() {
        return this.delegatorGroupId;
    }

    public DelegationType getDelegationType() {
        return DelegationType.fromCode((String)this.delegationType);
    }

    public String getRequestLabel() {
        return this.requestLabel;
    }

    private Group getGroup(String groupId) {
        if (StringUtils.isBlank((String)groupId)) {
            return null;
        }
        return KimApiServiceLocator.getGroupService().getGroup(groupId);
    }

    public Group getGroup() {
        return this.getGroup(this.groupId);
    }

    public String getRecipientTypeCode() {
        String recipientTypeCode = RecipientType.PRINCIPAL.getCode();
        if (this.getRoleName() != null) {
            recipientTypeCode = RecipientType.ROLE.getCode();
        }
        if (this.getGroupId() != null) {
            recipientTypeCode = RecipientType.GROUP.getCode();
        }
        return recipientTypeCode;
    }

    public String getActionRequestLabel() {
        if (StringUtils.isNotBlank((String)this.getRequestLabel())) {
            return this.getRequestLabel();
        }
        return CodeTranslator.getActionRequestLabel((String)this.getActionRequestCd());
    }

    public boolean isWorkgroupItem() {
        return this.getGroupId() != null;
    }

    public Principal getPrincipal() {
        return KimApiServiceLocator.getIdentityService().getPrincipal(this.principalId);
    }

    public void setResponsibilityId(String responsibilityId) {
        this.responsibilityId = responsibilityId;
    }

    public void setDocName(String docName) {
        this.docName = docName;
    }

    public void setActionRequestCd(String actionRequestCd) {
        this.actionRequestCd = actionRequestCd;
    }

    public void setDateAssigned(Timestamp dateAssigned) {
        this.dateAssigned = dateAssigned;
    }

    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setActionRequestId(String actionRequestId) {
        this.actionRequestId = actionRequestId;
    }

    public void setDocHandlerURL(String docHandlerURL) {
        this.docHandlerURL = docHandlerURL;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setDocLabel(String docLabel) {
        this.docLabel = docLabel;
    }

    public void setDocTitle(String docTitle) {
        this.docTitle = docTitle;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public void setDelegatorPrincipalId(String delegatorPrincipalId) {
        this.delegatorPrincipalId = delegatorPrincipalId;
    }

    public void setDelegatorGroupId(String delegatorGroupId) {
        this.delegatorGroupId = delegatorGroupId;
    }

    public void setDelegationType(DelegationType delegationType) {
        this.delegationType = delegationType == null ? null : delegationType.getCode();
    }

    public void setRequestLabel(String requestLabel) {
        this.requestLabel = requestLabel;
    }

    @Deprecated
    public Integer getActionItemIndex() {
        return null;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("principalId", (Object)this.principalId).append("dateAssigned", (Object)this.dateAssigned).append("actionRequestCd", (Object)this.actionRequestCd).append("actionRequestId", (Object)this.actionRequestId).append("documentId", (Object)this.documentId).append("groupId", (Object)this.groupId).append("docTitle", (Object)this.docTitle).append("docLabel", (Object)this.docLabel).append("docHandlerURL", (Object)this.docHandlerURL).append("docName", (Object)this.docName).append("responsibilityId", (Object)this.responsibilityId).append("roleName", (Object)this.roleName).append("delegatorPrincipalId", (Object)this.delegatorPrincipalId).append("delegatorGroupId", (Object)this.delegatorGroupId).append("delegationType", (Object)this.delegationType).toString();
    }

    public static org.kuali.rice.kew.api.action.ActionItem to(ActionItem bo) {
        if (bo == null) {
            return null;
        }
        return ActionItem.Builder.create((ActionItemContract)bo).build();
    }

    public static List<org.kuali.rice.kew.api.action.ActionItem> to(Collection<ActionItem> bos) {
        if (bos == null) {
            return null;
        }
        if (bos.isEmpty()) {
            return new ArrayList<org.kuali.rice.kew.api.action.ActionItem>();
        }
        ArrayList<org.kuali.rice.kew.api.action.ActionItem> dtos = new ArrayList<org.kuali.rice.kew.api.action.ActionItem>(bos.size());
        for (ActionItem bo : bos) {
            dtos.add(ActionItem.to(bo));
        }
        return dtos;
    }
}

