/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionlist.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionitem.ActionItemActionListExtension;
import org.kuali.rice.kew.actionitem.OutboxItemActionListExtension;
import org.kuali.rice.kew.actionitem.dao.ActionItemDAO;
import org.kuali.rice.kew.actionlist.ActionListFilter;
import org.kuali.rice.kew.actionlist.dao.ActionListDAO;
import org.kuali.rice.kew.actionlist.service.ActionListService;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.actionrequest.service.ActionRequestService;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.exception.WorkflowServiceErrorException;
import org.kuali.rice.kew.exception.WorkflowServiceErrorImpl;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.useroptions.UserOptions;
import org.kuali.rice.kew.useroptions.UserOptionsService;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class ActionListServiceImpl
implements ActionListService {
    protected final Logger LOG = Logger.getLogger(this.getClass());
    private ActionListDAO actionListDAO;
    private ActionItemDAO actionItemDAO;

    @Override
    public Collection<Recipient> findUserSecondaryDelegators(String principalId) {
        return this.getActionItemDAO().findSecondaryDelegators(principalId);
    }

    @Override
    public Collection<Recipient> findUserPrimaryDelegations(String principalId) {
        return this.getActionItemDAO().findPrimaryDelegationRecipients(principalId);
    }

    @Override
    public Collection<ActionItemActionListExtension> getActionList(String principalId, ActionListFilter filter) {
        return this.getActionListDAO().getActionList(principalId, filter);
    }

    @Override
    public Collection<ActionItemActionListExtension> getActionListForSingleDocument(String documentId) {
        return this.getActionListDAO().getActionListForSingleDocument(documentId);
    }

    public void setActionListDAO(ActionListDAO actionListDAO) {
        this.actionListDAO = actionListDAO;
    }

    public ActionListDAO getActionListDAO() {
        return this.actionListDAO;
    }

    @Override
    public void deleteActionItem(ActionItem actionItem) {
        this.deleteActionItem(actionItem, false);
    }

    @Override
    public void deleteActionItem(ActionItem actionItem, boolean forceIntoOutbox) {
        this.getActionItemDAO().deleteActionItem(actionItem);
        KEWServiceLocator.getNotificationService().removeNotification(Collections.singletonList(ActionItem.to(actionItem)));
        this.saveOutboxItem(actionItem, forceIntoOutbox);
    }

    @Override
    public void deleteByDocumentId(String documentId) {
        this.getActionItemDAO().deleteByDocumentId(documentId);
    }

    @Override
    public Collection<ActionItem> findByDocumentId(String documentId) {
        return this.getActionItemDAO().findByDocumentId(documentId);
    }

    @Override
    public Collection<ActionItem> findByActionRequestId(String actionRequestId) {
        return this.getActionItemDAO().findByActionRequestId(actionRequestId);
    }

    @Override
    public Collection<ActionItem> findByWorkflowUserDocumentId(String workflowUserId, String documentId) {
        return this.getActionItemDAO().findByWorkflowUserDocumentId(workflowUserId, documentId);
    }

    @Override
    public Collection<ActionItem> findByDocumentTypeName(String documentTypeName) {
        return this.getActionItemDAO().findByDocumentTypeName(documentTypeName);
    }

    @Override
    public ActionItem createActionItemForActionRequest(ActionRequestValue actionRequest) {
        ActionItem actionItem = new ActionItem();
        DocumentRouteHeaderValue routeHeader = actionRequest.getRouteHeader();
        DocumentType docType = routeHeader.getDocumentType();
        actionItem.setActionRequestCd(actionRequest.getActionRequested());
        actionItem.setActionRequestId(actionRequest.getActionRequestId());
        actionItem.setDocName(docType.getName());
        actionItem.setRoleName(actionRequest.getQualifiedRoleName());
        actionItem.setPrincipalId(actionRequest.getPrincipalId());
        actionItem.setDocumentId(actionRequest.getDocumentId());
        actionItem.setDateAssigned(new Timestamp(new Date().getTime()));
        actionItem.setDocHandlerURL(docType.getResolvedDocumentHandlerUrl());
        actionItem.setDocLabel(docType.getLabel());
        actionItem.setDocTitle(routeHeader.getDocTitle());
        actionItem.setGroupId(actionRequest.getGroupId());
        actionItem.setResponsibilityId(actionRequest.getResponsibilityId());
        actionItem.setDelegationType(actionRequest.getDelegationType());
        actionItem.setRequestLabel(actionRequest.getRequestLabel());
        ActionRequestValue delegatorActionRequest = this.getActionRequestService().findDelegatorRequest(actionRequest);
        if (delegatorActionRequest != null) {
            actionItem.setDelegatorPrincipalId(delegatorActionRequest.getPrincipalId());
            actionItem.setDelegatorGroupId(delegatorActionRequest.getGroupId());
        }
        return actionItem;
    }

    @Override
    public void updateActionItemsForTitleChange(String documentId, String newTitle) {
        Collection<ActionItem> items = this.getActionItemDAO().findByDocumentId(documentId);
        for (ActionItem item : items) {
            item.setDocTitle(newTitle);
            this.saveActionItem(item);
        }
    }

    @Override
    public void saveActionItem(ActionItem actionItem) {
        this.getActionItemDAO().saveActionItem(actionItem);
    }

    public ActionItemDAO getActionItemDAO() {
        return this.actionItemDAO;
    }

    public ActionRequestService getActionRequestService() {
        return KEWServiceLocator.getActionRequestService();
    }

    public GroupService getGroupService() {
        return KimApiServiceLocator.getGroupService();
    }

    public void setActionItemDAO(ActionItemDAO actionItemDAO) {
        this.actionItemDAO = actionItemDAO;
    }

    @Override
    public void validateActionItem(ActionItem actionItem) {
        String actionRequestCd;
        ArrayList<WorkflowServiceErrorImpl> errors = new ArrayList<WorkflowServiceErrorImpl>();
        String principalId = actionItem.getPrincipalId();
        if (principalId == null || principalId.trim().equals("")) {
            errors.add(new WorkflowServiceErrorImpl("ActionItem person null.", "actionitem.personid.empty", actionItem.getId().toString()));
        } else {
            Principal principal = KimApiServiceLocator.getIdentityService().getPrincipal(principalId);
            if (principal == null) {
                errors.add(new WorkflowServiceErrorImpl("ActionItem person invalid.", "actionitem.personid.invalid", actionItem.getId().toString()));
            }
        }
        if (actionItem.getDateAssigned() == null) {
            errors.add(new WorkflowServiceErrorImpl("ActionItem date assigned empty.", "actionitem.dateassigned.empty", actionItem.getId().toString()));
        }
        if ((actionRequestCd = actionItem.getActionRequestCd()) == null || actionRequestCd.trim().equals("")) {
            errors.add(new WorkflowServiceErrorImpl("ActionItem action request cd empty.", "actionitem.actionrequestcd.empty", actionItem.getId().toString()));
        } else if (!KewApiConstants.ACTION_REQUEST_CD.containsKey(actionRequestCd)) {
            errors.add(new WorkflowServiceErrorImpl("ActionItem action request cd invalid.", "actionitem.actionrequestcd.invalid", actionItem.getId().toString()));
        }
        if (actionItem.getActionRequestId() == null) {
            errors.add(new WorkflowServiceErrorImpl("ActionItem action request id empty.", "actionitem.actionrequestid.empty", actionItem.getId().toString()));
        }
        if (actionItem.getDocumentId() == null) {
            errors.add(new WorkflowServiceErrorImpl("ActionItem Document id empty.", "actionitem.documentid.empty", actionItem.getId().toString()));
        } else if (KEWServiceLocator.getRouteHeaderService().getRouteHeader(actionItem.getDocumentId()) == null) {
            errors.add(new WorkflowServiceErrorImpl("ActionItem Document id invalid.", "actionitem.documentid.invalid", actionItem.getId().toString()));
        }
        String docTypeName = actionItem.getDocName();
        DocumentType docType = null;
        if (docTypeName == null || docTypeName.trim().equals("")) {
            errors.add(new WorkflowServiceErrorImpl("ActionItem doctypename empty.", "actionitem.doctypename.empty", actionItem.getId().toString()));
        } else {
            docType = KEWServiceLocator.getDocumentTypeService().findByName(actionItem.getDocName());
            if (docType == null) {
                errors.add(new WorkflowServiceErrorImpl("ActionItem doctypename invalid.", "actionitem.doctypename.invalid", actionItem.getId().toString()));
            }
        }
        if (actionItem.getDocLabel() == null || actionItem.getDocLabel().trim().equals("")) {
            errors.add(new WorkflowServiceErrorImpl("ActionItem doctypelabel empty.", "actionitem.doctypelabel.empty", actionItem.getId().toString()));
        } else if (docType != null && !docType.getLabel().equals(actionItem.getDocLabel())) {
            errors.add(new WorkflowServiceErrorImpl("ActionItem doctypelabel no match.", "actionitem.doctypelabel.nomatch", actionItem.getId().toString()));
        }
        if (StringUtils.isNotBlank((String)docType.getResolvedDocumentHandlerUrl())) {
            if (actionItem.getDocHandlerURL() == null || actionItem.getDocHandlerURL().trim().equals("")) {
                errors.add(new WorkflowServiceErrorImpl("ActionItem doc handler url empty.", "actionitem.dochdrurl.empty", actionItem.getId().toString()));
            } else if (docType != null && !docType.getResolvedDocumentHandlerUrl().equals(actionItem.getDocHandlerURL())) {
                errors.add(new WorkflowServiceErrorImpl("ActionItem doc handler url no match.", "actionitem.dochdrurl.nomatch", actionItem.getId().toString()));
            }
        } else if (StringUtils.isNotBlank((String)actionItem.getDocHandlerURL())) {
            errors.add(new WorkflowServiceErrorImpl("ActionItem doc handler url not empty.", "actionitem.dochdrurl.not.empty", actionItem.getId().toString()));
        }
        if (!errors.isEmpty()) {
            throw new WorkflowServiceErrorException("ActionItem Validation Error", errors);
        }
    }

    @Override
    public ActionItem findByActionItemId(String actionItemId) {
        return this.getActionItemDAO().findByActionItemId(actionItemId);
    }

    @Override
    public int getCount(String principalId) {
        return this.getActionListDAO().getCount(principalId);
    }

    @Override
    public List<Object> getMaxActionItemDateAssignedAndCountForUser(String principalId) {
        return this.getActionListDAO().getMaxActionItemDateAssignedAndCountForUser(principalId);
    }

    @Override
    public Collection<OutboxItemActionListExtension> getOutbox(String principalId, ActionListFilter filter) {
        return this.getActionListDAO().getOutbox(principalId, filter);
    }

    @Override
    public Collection<OutboxItemActionListExtension> getOutboxItemsByDocumentType(String documentTypeName) {
        return this.getActionItemDAO().getOutboxItemsByDocumentType(documentTypeName);
    }

    @Override
    public void removeOutboxItems(String principalId, List<String> outboxItems) {
        this.getActionListDAO().removeOutboxItems(principalId, outboxItems);
    }

    @Override
    public void saveOutboxItem(ActionItem actionItem) {
        this.saveOutboxItem(actionItem, false);
    }

    @Override
    public void saveOutboxItem(ActionItem actionItem, boolean forceIntoOutbox) {
        UserOptionsService userOptionsService = KEWServiceLocator.getUserOptionsService();
        Boolean isUsingOutBox = true;
        List<UserOptions> options = userOptionsService.findByUserQualified(actionItem.getPrincipalId(), "USE_OUT_BOX%");
        if (options == null || options.isEmpty()) {
            isUsingOutBox = true;
        } else {
            for (UserOptions u : options) {
                if (u.getOptionVal() != null && u.getOptionVal().equals("yes")) continue;
                isUsingOutBox = false;
            }
        }
        if (isUsingOutBox.booleanValue() && ConfigContext.getCurrentContextConfig().getOutBoxOn().booleanValue() && this.getActionListDAO().getOutboxByDocumentIdUserId(actionItem.getDocumentId(), actionItem.getPrincipalId()) == null && !KEWServiceLocator.getRouteHeaderService().getRouteHeader(actionItem.getDocumentId()).getDocRouteStatus().equals("S")) {
            ActionRequestValue actionRequest = KEWServiceLocator.getActionRequestService().findByActionRequestId(actionItem.getActionRequestId());
            ActionTakenValue actionTaken = actionRequest.getActionTaken();
            if (forceIntoOutbox || actionTaken != null && actionTaken.getPrincipalId().equals(actionItem.getPrincipalId())) {
                this.getActionListDAO().saveOutboxItem(new OutboxItemActionListExtension(actionItem));
            }
        }
    }

    @Override
    public Collection<ActionItem> findByPrincipalId(String principalId) {
        return this.getActionItemDAO().findByPrincipalId(principalId);
    }
}

