/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionrequest.dao.impl;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.dao.ActionRequestDAO;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.api.action.RecipientType;
import org.kuali.rice.kim.api.group.Group;

public class ActionRequestDAOJpaImpl
implements ActionRequestDAO {
    @PersistenceContext(name="kew-unit")
    private EntityManager entityManager;

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void delete(String actionRequestId) {
        ActionRequestValue actionRequestValue = (ActionRequestValue)this.entityManager.find(ActionRequestValue.class, (Object)actionRequestId);
        this.entityManager.remove((Object)actionRequestValue);
    }

    @Override
    public void deleteByDocumentId(String documentId) {
        Query query = this.entityManager.createNamedQuery("ActionRequestValue.FindByDocumentId");
        query.setParameter("documentId", (Object)documentId);
        List actionRequestValues = (List)query.getSingleResult();
        for (ActionRequestValue arv : actionRequestValues) {
            this.entityManager.remove((Object)arv);
        }
    }

    @Override
    public boolean doesDocumentHaveUserRequest(String principalId, String documentId) {
        Query query = this.entityManager.createNamedQuery("ActionRequestValue.GetUserRequestCount");
        query.setParameter("principalId", (Object)principalId);
        query.setParameter("documentId", (Object)documentId);
        query.setParameter("recipientTypeCd", (Object)RecipientType.PRINCIPAL.getCode());
        query.setParameter("currentIndicator", (Object)Boolean.TRUE);
        return (Long)query.getSingleResult() > 0L;
    }

    public List<?> findActivatedByGroup(Group group) {
        Query query = this.entityManager.createNamedQuery("ActionRequestValue.FindActivatedByGroup");
        query.setParameter("groupId", (Object)group.getId());
        query.setParameter("currentIndicator", (Object)Boolean.TRUE);
        query.setParameter("status", (Object)ActionRequestStatus.ACTIVATED.getCode());
        return query.getResultList();
    }

    @Override
    public List<ActionRequestValue> findAllByDocId(String documentId) {
        Query query = this.entityManager.createNamedQuery("ActionRequestValue.FindAllByDocId");
        query.setParameter("documentId", (Object)documentId);
        query.setParameter("currentIndicator", (Object)Boolean.TRUE);
        return query.getResultList();
    }

    @Override
    public List<ActionRequestValue> findAllPendingByDocId(String documentId) {
        Query query = this.entityManager.createNamedQuery("ActionRequestValue.FindAllPendingByDocId");
        query.setParameter("documentId", (Object)documentId);
        query.setParameter("currentIndicator", (Object)Boolean.TRUE);
        query.setParameter("actionRequestStatus1", (Object)ActionRequestStatus.INITIALIZED.getCode());
        query.setParameter("actionRequestStatus2", (Object)ActionRequestStatus.ACTIVATED.getCode());
        return query.getResultList();
    }

    @Override
    public List<ActionRequestValue> findAllRootByDocId(String documentId) {
        Query query = this.entityManager.createNamedQuery("ActionRequestValue.FindAllRootByDocId");
        query.setParameter("documentId", (Object)documentId);
        query.setParameter("currentIndicator", (Object)Boolean.TRUE);
        return query.getResultList();
    }

    @Override
    public List<ActionRequestValue> findByDocumentIdIgnoreCurrentInd(String documentId) {
        Query query = this.entityManager.createNamedQuery("ActionRequestValue.FindByDocumentId");
        query.setParameter("documentId", (Object)documentId);
        return query.getResultList();
    }

    @Override
    public List<ActionRequestValue> findByStatusAndDocId(String statusCd, String documentId) {
        Query query = this.entityManager.createNamedQuery("ActionRequestValue.FindByStatusAndDocId");
        query.setParameter("documentId", (Object)documentId);
        query.setParameter("status", (Object)statusCd);
        query.setParameter("currentIndicator", (Object)Boolean.TRUE);
        return query.getResultList();
    }

    @Override
    public List<ActionRequestValue> findPendingByActionRequestedAndDocId(String actionRequestedCd, String documentId) {
        Query query = this.entityManager.createNamedQuery("ActionRequestValue.FindPendingByActionRequestedAndDocId");
        query.setParameter("documentId", (Object)documentId);
        query.setParameter("currentIndicator", (Object)Boolean.TRUE);
        query.setParameter("actionRequested", (Object)actionRequestedCd);
        query.setParameter("actionRequestStatus1", (Object)ActionRequestStatus.INITIALIZED.getCode());
        query.setParameter("actionRequestStatus2", (Object)ActionRequestStatus.ACTIVATED.getCode());
        return query.getResultList();
    }

    @Override
    public List<ActionRequestValue> findPendingByDocIdAtOrBelowRouteLevel(String documentId, Integer routeLevel) {
        Query query = this.entityManager.createNamedQuery("ActionRequestValue.FindPendingByDocIdAtOrBelowRouteLevel");
        query.setParameter("documentId", (Object)documentId);
        query.setParameter("currentIndicator", (Object)Boolean.TRUE);
        query.setParameter("routeLevel", (Object)routeLevel);
        query.setParameter("status", (Object)ActionRequestStatus.DONE.getCode());
        return query.getResultList();
    }

    @Override
    public List<ActionRequestValue> findPendingByResponsibilityIds(Collection responsibilityIds) {
        if (responsibilityIds == null || responsibilityIds.size() == 0) {
            return Collections.emptyList();
        }
        Query query = this.entityManager.createNamedQuery("ActionRequestValue.FindPendingByDocIdAtOrBelowRouteLevel");
        query.setParameter("responsibilityIds", (Object)responsibilityIds);
        return query.getResultList();
    }

    @Override
    public List<ActionRequestValue> findPendingRootRequestsByDocIdAtOrBelowRouteLevel(String documentId, Integer routeLevel) {
        Query query = this.entityManager.createNamedQuery("ActionRequestValue.FindPendingRootRequestsByDocIdAtOrBelowRouteLevel");
        query.setParameter("documentId", (Object)documentId);
        query.setParameter("currentIndicator", (Object)Boolean.TRUE);
        query.setParameter("status", (Object)ActionRequestStatus.DONE.getCode());
        query.setParameter("routeLevel", (Object)routeLevel);
        return query.getResultList();
    }

    @Override
    public List<ActionRequestValue> findPendingRootRequestsByDocIdAtRouteLevel(String documentId, Integer routeLevel) {
        Query query = this.entityManager.createNamedQuery("ActionRequestValue.FindPendingRootRequestsByDocIdAtRouteLevel");
        query.setParameter("documentId", (Object)documentId);
        query.setParameter("currentIndicator", (Object)Boolean.TRUE);
        query.setParameter("status", (Object)ActionRequestStatus.DONE.getCode());
        query.setParameter("routeLevel", (Object)routeLevel);
        return query.getResultList();
    }

    @Override
    public List<ActionRequestValue> findPendingRootRequestsByDocIdAtRouteNode(String documentId, String nodeInstanceId) {
        Query query = this.entityManager.createNamedQuery("ActionRequestValue.FindPendingRootRequestsByDocIdAtRouteNode");
        query.setParameter("documentId", (Object)documentId);
        query.setParameter("currentIndicator", (Object)Boolean.TRUE);
        query.setParameter("routeNodeInstanceId", (Object)nodeInstanceId);
        query.setParameter("actionRequestStatus1", (Object)ActionRequestStatus.INITIALIZED.getCode());
        query.setParameter("actionRequestStatus2", (Object)ActionRequestStatus.ACTIVATED.getCode());
        return query.getResultList();
    }

    @Override
    public List<ActionRequestValue> findPendingRootRequestsByDocumentType(String documentTypeId) {
        Query query = this.entityManager.createNamedQuery("ActionRequestValue.FindPendingRootRequestsByDocumentType");
        query.setParameter("documentTypeId", (Object)documentTypeId);
        query.setParameter("currentIndicator", (Object)Boolean.TRUE);
        query.setParameter("actionRequestStatus1", (Object)ActionRequestStatus.INITIALIZED.getCode());
        query.setParameter("actionRequestStatus2", (Object)ActionRequestStatus.ACTIVATED.getCode());
        return query.getResultList();
    }

    @Override
    public List<ActionRequestValue> findRootRequestsByDocIdAtRouteNode(String documentId, String nodeInstanceId) {
        Query query = this.entityManager.createNamedQuery("ActionRequestValue.FindRootRequestsByDocIdAtRouteNode");
        query.setParameter("documentId", (Object)documentId);
        query.setParameter("currentIndicator", (Object)Boolean.TRUE);
        query.setParameter("routeNodeInstanceId", (Object)nodeInstanceId);
        return query.getResultList();
    }

    @Override
    public ActionRequestValue getActionRequestByActionRequestId(String actionRequestId) {
        return (ActionRequestValue)this.entityManager.find(ActionRequestValue.class, (Object)actionRequestId);
    }

    @Override
    public List<String> getRequestGroupIds(String documentId) {
        Query query = this.entityManager.createNamedQuery("ActionRequestValue.GetRequestGroupIds");
        query.setParameter("documentId", (Object)documentId);
        query.setParameter("currentIndicator", (Object)Boolean.TRUE);
        query.setParameter("recipientTypeCd", (Object)RecipientType.GROUP.getCode());
        return query.getResultList();
    }

    @Override
    public void saveActionRequest(ActionRequestValue actionRequest) {
        if (actionRequest.getAnnotation() != null && actionRequest.getAnnotation().length() > 2000) {
            actionRequest.setAnnotation(StringUtils.abbreviate((String)actionRequest.getAnnotation(), (int)2000));
        }
        if (actionRequest.getActionRequestId() == null) {
            this.loadDefaultValues(actionRequest);
            this.entityManager.persist((Object)actionRequest);
        } else {
            OrmUtils.merge((EntityManager)this.entityManager, (Object)actionRequest);
        }
    }

    private void loadDefaultValues(ActionRequestValue actionRequest) {
        this.checkNull((Serializable)((Object)actionRequest.getActionRequested()), "action requested");
        this.checkNull((Serializable)((Object)actionRequest.getResponsibilityId()), "responsibility ID");
        this.checkNull(actionRequest.getRouteLevel(), "route level");
        this.checkNull(actionRequest.getDocVersion(), "doc version");
        if (actionRequest.getForceAction() == null) {
            actionRequest.setForceAction(Boolean.FALSE);
        }
        if (actionRequest.getStatus() == null) {
            actionRequest.setStatus(ActionRequestStatus.INITIALIZED.getCode());
        }
        if (actionRequest.getPriority() == null) {
            actionRequest.setPriority(1);
        }
        if (actionRequest.getCurrentIndicator() == null) {
            actionRequest.setCurrentIndicator(true);
        }
        actionRequest.setCreateDate(new Timestamp(System.currentTimeMillis()));
    }

    private void checkNull(Serializable value, String valueName) throws RuntimeException {
        if (value == null) {
            throw new RuntimeException("Null value for " + valueName);
        }
    }

    @Override
    public List<ActionRequestValue> findActivatedByGroup(String groupId) {
        Query query = this.entityManager.createNamedQuery("ActionRequestValue.FindByStatusAndGroupId");
        query.setParameter("status", (Object)ActionRequestStatus.ACTIVATED.getCode());
        query.setParameter("currentIndicator", (Object)Boolean.TRUE);
        query.setParameter("groupId", (Object)groupId);
        return query.getResultList();
    }

    @Override
    public ActionRequestValue getRoleActionRequestByActionTakenId(String actionTakenId) {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

