/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionrequest.dao.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.dao.ActionRequestDAO;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.api.action.RecipientType;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.springmodules.orm.ojb.support.PersistenceBrokerDaoSupport;

public class ActionRequestDAOOjbImpl
extends PersistenceBrokerDaoSupport
implements ActionRequestDAO {
    @Override
    public ActionRequestValue getActionRequestByActionRequestId(String actionRequestId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("actionRequestId", (Object)actionRequestId);
        return (ActionRequestValue)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(ActionRequestValue.class, crit));
    }

    @Override
    public void saveActionRequest(ActionRequestValue actionRequest) {
        if (actionRequest.getActionRequestId() == null) {
            this.loadDefaultValues(actionRequest);
        }
        if (actionRequest.getAnnotation() != null && actionRequest.getAnnotation().length() > 2000) {
            actionRequest.setAnnotation(StringUtils.abbreviate((String)actionRequest.getAnnotation(), (int)2000));
        }
        this.getPersistenceBrokerTemplate().store((Object)actionRequest);
    }

    @Override
    public List<ActionRequestValue> findPendingByResponsibilityIds(Collection responsibilityIds) {
        if (responsibilityIds == null || responsibilityIds.size() == 0) {
            return Collections.emptyList();
        }
        Criteria crit = new Criteria();
        Criteria statusCriteria = new Criteria();
        Criteria activatedCriteria = new Criteria();
        activatedCriteria.addEqualTo("status", (Object)ActionRequestStatus.ACTIVATED.getCode());
        Criteria initializedCriteria = new Criteria();
        initializedCriteria.addEqualTo("status", (Object)ActionRequestStatus.INITIALIZED.getCode());
        statusCriteria.addOrCriteria(activatedCriteria);
        statusCriteria.addOrCriteria(initializedCriteria);
        crit.addAndCriteria(statusCriteria);
        crit.addIn("responsibilityId", responsibilityIds);
        return new ArrayList<ActionRequestValue>(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(ActionRequestValue.class, crit)));
    }

    @Override
    public List<ActionRequestValue> findPendingByActionRequestedAndDocId(String actionRequestedCd, String documentId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("actionRequested", (Object)actionRequestedCd);
        crit.addEqualTo("documentId", (Object)documentId);
        crit.addEqualTo("currentIndicator", (Object)Boolean.TRUE);
        crit.addAndCriteria(this.getPendingCriteria());
        return new ArrayList<ActionRequestValue>(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(ActionRequestValue.class, crit)));
    }

    @Override
    public List<ActionRequestValue> findByStatusAndDocId(String statusCd, String documentId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("status", (Object)statusCd);
        crit.addEqualTo("documentId", (Object)documentId);
        crit.addEqualTo("currentIndicator", (Object)true);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(ActionRequestValue.class, crit));
    }

    private void loadDefaultValues(ActionRequestValue actionRequest) {
        this.checkNull(actionRequest.getActionRequested(), "action requested");
        this.checkNull(actionRequest.getResponsibilityId(), "responsibility ID");
        this.checkNull(actionRequest.getRouteLevel(), "route level");
        this.checkNull(actionRequest.getDocVersion(), "doc version");
        if (actionRequest.getForceAction() == null) {
            actionRequest.setForceAction(Boolean.FALSE);
        }
        if (actionRequest.getStatus() == null) {
            actionRequest.setStatus(ActionRequestStatus.INITIALIZED.getCode());
        }
        if (actionRequest.getPriority() == null) {
            actionRequest.setPriority(1);
        }
        if (actionRequest.getCurrentIndicator() == null) {
            actionRequest.setCurrentIndicator(true);
        }
        actionRequest.setCreateDate(new Timestamp(System.currentTimeMillis()));
    }

    private void checkNull(Object value, String valueName) throws RuntimeException {
        if (value == null) {
            throw new RuntimeException("Null value for " + valueName);
        }
    }

    @Override
    public List<ActionRequestValue> findPendingRootRequestsByDocIdAtRouteLevel(String documentId, Integer routeLevel) {
        Criteria crit = new Criteria();
        crit.addEqualTo("routeLevel", (Object)routeLevel);
        crit.addNotEqualTo((Object)"status", (Object)ActionRequestStatus.DONE.getCode());
        crit.addEqualTo("documentId", (Object)documentId);
        crit.addEqualTo("currentIndicator", (Object)Boolean.TRUE);
        crit.addIsNull("parentActionRequest");
        return new ArrayList<ActionRequestValue>(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(ActionRequestValue.class, crit)));
    }

    @Override
    public List<ActionRequestValue> findPendingByDocIdAtOrBelowRouteLevel(String documentId, Integer routeLevel) {
        Criteria crit = new Criteria();
        crit.addLessOrEqualThan((Object)"routeLevel", (Object)routeLevel);
        crit.addNotEqualTo((Object)"status", (Object)ActionRequestStatus.DONE.getCode());
        crit.addEqualTo("documentId", (Object)documentId);
        crit.addEqualTo("currentIndicator", (Object)true);
        return new ArrayList<ActionRequestValue>(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(ActionRequestValue.class, crit)));
    }

    @Override
    public List<ActionRequestValue> findPendingRootRequestsByDocIdAtOrBelowRouteLevel(String documentId, Integer routeLevel) {
        Criteria crit = new Criteria();
        crit.addLessOrEqualThan((Object)"routeLevel", (Object)routeLevel);
        crit.addNotEqualTo((Object)"status", (Object)ActionRequestStatus.DONE.getCode());
        crit.addEqualTo("documentId", (Object)documentId);
        crit.addEqualTo("currentIndicator", (Object)true);
        crit.addIsNull("parentActionRequest");
        return new ArrayList<ActionRequestValue>(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(ActionRequestValue.class, crit)));
    }

    @Override
    public void delete(String actionRequestId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("actionRequestId", (Object)actionRequestId);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)new QueryByCriteria(ActionRequestValue.class, crit));
    }

    @Override
    public List<ActionRequestValue> findAllPendingByDocId(String documentId) {
        Criteria initializedStatCriteria = new Criteria();
        initializedStatCriteria.addEqualTo("status", (Object)ActionRequestStatus.INITIALIZED.getCode());
        Criteria activatedStatCriteria = new Criteria();
        activatedStatCriteria.addEqualTo("status", (Object)ActionRequestStatus.ACTIVATED.getCode());
        Criteria statusCriteria = new Criteria();
        statusCriteria.addOrCriteria(initializedStatCriteria);
        statusCriteria.addOrCriteria(activatedStatCriteria);
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        crit.addEqualTo("currentIndicator", (Object)true);
        crit.addAndCriteria(statusCriteria);
        return new ArrayList<ActionRequestValue>(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(ActionRequestValue.class, crit)));
    }

    @Override
    public List<ActionRequestValue> findAllByDocId(String documentId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        crit.addEqualTo("currentIndicator", (Object)true);
        return new ArrayList<ActionRequestValue>(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(ActionRequestValue.class, crit)));
    }

    @Override
    public List<ActionRequestValue> findAllRootByDocId(String documentId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        crit.addEqualTo("currentIndicator", (Object)true);
        crit.addIsNull("parentActionRequest");
        return new ArrayList<ActionRequestValue>(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(ActionRequestValue.class, crit)));
    }

    @Override
    public List<ActionRequestValue> findByDocumentIdIgnoreCurrentInd(String documentId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        return new ArrayList<ActionRequestValue>(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(ActionRequestValue.class, crit)));
    }

    private Criteria getPendingCriteria() {
        Criteria pendingCriteria = new Criteria();
        Criteria activatedCriteria = new Criteria();
        activatedCriteria.addEqualTo("status", (Object)ActionRequestStatus.ACTIVATED.getCode());
        Criteria initializedCriteria = new Criteria();
        initializedCriteria.addEqualTo("status", (Object)ActionRequestStatus.INITIALIZED.getCode());
        pendingCriteria.addOrCriteria(activatedCriteria);
        pendingCriteria.addOrCriteria(initializedCriteria);
        return pendingCriteria;
    }

    @Override
    public void deleteByDocumentId(String documentId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)new QueryByCriteria(ActionRequestValue.class, crit));
    }

    @Override
    public List<ActionRequestValue> findPendingRootRequestsByDocumentType(String documentTypeId) {
        Criteria routeHeaderCrit = new Criteria();
        routeHeaderCrit.addEqualTo("documentTypeId", (Object)documentTypeId);
        Criteria crit = new Criteria();
        crit.addIn((Object)"documentId", (Query)new ReportQueryByCriteria(DocumentRouteHeaderValue.class, new String[]{"documentId"}, routeHeaderCrit));
        crit.addAndCriteria(this.getPendingCriteria());
        crit.addEqualTo("currentIndicator", (Object)Boolean.TRUE);
        crit.addIsNull("parentActionRequest");
        return new ArrayList<ActionRequestValue>(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(ActionRequestValue.class, crit)));
    }

    @Override
    public List<ActionRequestValue> findPendingRootRequestsByDocIdAtRouteNode(String documentId, String nodeInstanceId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        crit.addAndCriteria(this.getPendingCriteria());
        crit.addEqualTo("currentIndicator", (Object)Boolean.TRUE);
        crit.addIsNull("parentActionRequest");
        crit.addEqualTo("nodeInstance.routeNodeInstanceId", (Object)nodeInstanceId);
        return new ArrayList<ActionRequestValue>(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(ActionRequestValue.class, crit)));
    }

    @Override
    public List<ActionRequestValue> findRootRequestsByDocIdAtRouteNode(String documentId, String nodeInstanceId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        crit.addEqualTo("currentIndicator", (Object)Boolean.TRUE);
        crit.addIsNull("parentActionRequest");
        crit.addEqualTo("nodeInstance.routeNodeInstanceId", (Object)nodeInstanceId);
        return new ArrayList<ActionRequestValue>(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(ActionRequestValue.class, crit)));
    }

    @Override
    public boolean doesDocumentHaveUserRequest(String principalId, String documentId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        crit.addEqualTo("recipientTypeCd", (Object)RecipientType.PRINCIPAL.getCode());
        crit.addEqualTo("principalId", (Object)principalId);
        crit.addEqualTo("currentIndicator", (Object)Boolean.TRUE);
        int count = this.getPersistenceBrokerTemplate().getCount((Query)new QueryByCriteria(ActionRequestValue.class, crit));
        return count > 0;
    }

    @Override
    public List<String> getRequestGroupIds(String documentId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        crit.addEqualTo("recipientTypeCd", (Object)RecipientType.GROUP.getCode());
        crit.addEqualTo("currentIndicator", (Object)Boolean.TRUE);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(ActionRequestValue.class, (Criteria)crit);
        query.setAttributes(new String[]{"groupId"});
        ArrayList<String> groupIds = new ArrayList<String>();
        Iterator iter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        while (iter.hasNext()) {
            Object[] row = (Object[])iter.next();
            String id = (String)row[0];
            groupIds.add(id);
        }
        return groupIds;
    }

    @Override
    public List<ActionRequestValue> findActivatedByGroup(String groupId) {
        Criteria statusCriteria = new Criteria();
        statusCriteria.addEqualTo("status", (Object)ActionRequestStatus.ACTIVATED.getCode());
        Criteria crit = new Criteria();
        crit.addEqualTo("groupId", (Object)groupId);
        crit.addEqualTo("currentIndicator", (Object)true);
        crit.addAndCriteria(statusCriteria);
        return new ArrayList<ActionRequestValue>(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(ActionRequestValue.class, crit)));
    }

    @Override
    public ActionRequestValue getRoleActionRequestByActionTakenId(String actionTakenId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("actionTakenId", (Object)actionTakenId);
        crit.addEqualTo("currentIndicator", (Object)true);
        crit.addEqualTo("recipientTypeCd", (Object)RecipientType.ROLE.getCode());
        crit.addIsNull("parentActionRequest");
        return (ActionRequestValue)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(ActionRequestValue.class, crit));
    }
}

