/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionrequest.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionlist.service.ActionListService;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.actionrequest.dao.ActionRequestDAO;
import org.kuali.rice.kew.actionrequest.service.ActionRequestService;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.actiontaken.service.ActionTakenService;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.action.ActionRequestPolicy;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.api.action.RecipientType;
import org.kuali.rice.kew.api.document.DocumentRefreshQueue;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.ActivationContext;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.exception.WorkflowServiceErrorException;
import org.kuali.rice.kew.exception.WorkflowServiceErrorImpl;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kew.routemodule.RouteModule;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.util.FutureRequestDocumentStateManager;
import org.kuali.rice.kew.util.PerformanceLogger;
import org.kuali.rice.kew.util.ResponsibleParty;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class ActionRequestServiceImpl
implements ActionRequestService {
    private static final Logger LOG = Logger.getLogger(ActionRequestServiceImpl.class);
    private ActionRequestDAO actionRequestDAO;

    @Override
    public ActionRequestValue findByActionRequestId(String actionRequestId) {
        return this.getActionRequestDAO().getActionRequestByActionRequestId(actionRequestId);
    }

    @Override
    public Map<String, String> getActionsRequested(DocumentRouteHeaderValue routeHeader, String principalId, boolean completeAndApproveTheSame) {
        return this.getActionsRequested(principalId, routeHeader.getActionRequests(), completeAndApproveTheSame);
    }

    protected Map<String, String> getActionsRequested(String principalId, List<ActionRequestValue> actionRequests, boolean completeAndApproveTheSame) {
        HashMap<String, String> actionsRequested = new HashMap<String, String>();
        actionsRequested.put("F", "false");
        actionsRequested.put("K", "false");
        actionsRequested.put("A", "false");
        actionsRequested.put("C", "false");
        String topActionRequested = "F";
        for (ActionRequestValue actionRequest : actionRequests) {
            if (RecipientType.ROLE.getCode().equals(actionRequest.getRecipientTypeCd()) || !actionRequest.isRecipientRoutedRequest(principalId) || !actionRequest.isActive()) continue;
            int actionRequestComparison = ActionRequestValue.compareActionCode(actionRequest.getActionRequested(), topActionRequested, completeAndApproveTheSame);
            if (actionRequest.isFYIRequest() && actionRequestComparison >= 0) {
                actionsRequested.put("F", "true");
                continue;
            }
            if (actionRequest.isAcknowledgeRequest() && actionRequestComparison >= 0) {
                actionsRequested.put("K", "true");
                actionsRequested.put("F", "false");
                topActionRequested = actionRequest.getActionRequested();
                continue;
            }
            if (actionRequest.isApproveRequest() && actionRequestComparison >= 0) {
                actionsRequested.put("A", "true");
                actionsRequested.put("K", "false");
                actionsRequested.put("F", "false");
                topActionRequested = actionRequest.getActionRequested();
                continue;
            }
            if (!actionRequest.isCompleteRequst() || actionRequestComparison < 0) continue;
            actionsRequested.put("C", "true");
            actionsRequested.put("A", "false");
            actionsRequested.put("K", "false");
            actionsRequested.put("F", "false");
            if (completeAndApproveTheSame) {
                actionsRequested.put("A", "true");
            }
            topActionRequested = actionRequest.getActionRequested();
        }
        return actionsRequested;
    }

    @Override
    public ActionRequestValue initializeActionRequestGraph(ActionRequestValue actionRequest, DocumentRouteHeaderValue document, RouteNodeInstance nodeInstance) {
        if (actionRequest.getParentActionRequest() != null) {
            LOG.warn((Object)("-->A non parent action request from doc " + document.getDocumentId()));
            actionRequest = KEWServiceLocator.getActionRequestService().getRoot(actionRequest);
        }
        this.propagatePropertiesToRequestGraph(actionRequest, document, nodeInstance);
        return actionRequest;
    }

    private void propagatePropertiesToRequestGraph(ActionRequestValue actionRequest, DocumentRouteHeaderValue document, RouteNodeInstance nodeInstance) {
        this.setPropertiesToRequest(actionRequest, document, nodeInstance);
        for (ActionRequestValue actionRequestValue : actionRequest.getChildrenRequests()) {
            this.propagatePropertiesToRequestGraph(actionRequestValue, document, nodeInstance);
        }
    }

    private void setPropertiesToRequest(ActionRequestValue actionRequest, DocumentRouteHeaderValue document, RouteNodeInstance nodeInstance) {
        actionRequest.setDocumentId(document.getDocumentId());
        actionRequest.setDocVersion(document.getDocVersion());
        actionRequest.setRouteLevel(document.getDocRouteLevel());
        actionRequest.setNodeInstance(nodeInstance);
        actionRequest.setStatus(ActionRequestStatus.INITIALIZED.getCode());
    }

    @Override
    public void activateRequests(Collection actionRequests) {
        this.activateRequests(actionRequests, new ActivationContext(false));
    }

    @Override
    public void activateRequests(Collection actionRequests, boolean simulate) {
        this.activateRequests(actionRequests, new ActivationContext(simulate));
    }

    @Override
    public void activateRequests(Collection actionRequests, ActivationContext activationContext) {
        if (actionRequests == null) {
            return;
        }
        PerformanceLogger performanceLogger = null;
        if (LOG.isInfoEnabled()) {
            performanceLogger = new PerformanceLogger();
        }
        activationContext.setGeneratedActionItems(new ArrayList<ActionItem>());
        this.activateRequestsInternal(actionRequests, activationContext);
        if (!activationContext.isSimulation()) {
            KEWServiceLocator.getNotificationService().notify(ActionItem.to(activationContext.getGeneratedActionItems()));
        }
        if (LOG.isInfoEnabled()) {
            performanceLogger.log("Time to " + (activationContext.isSimulation() ? "simulate activation of " : "activate ") + actionRequests.size() + " action requests.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Generated " + activationContext.getGeneratedActionItems().size() + " action items."));
        }
    }

    @Override
    public void activateRequest(ActionRequestValue actionRequest) {
        this.activateRequests(Collections.singletonList(actionRequest), new ActivationContext(false));
    }

    @Override
    public void activateRequest(ActionRequestValue actionRequest, boolean simulate) {
        this.activateRequests(Collections.singletonList(actionRequest), new ActivationContext(simulate));
    }

    @Override
    public void activateRequest(ActionRequestValue actionRequest, ActivationContext activationContext) {
        this.activateRequests(Collections.singletonList(actionRequest), activationContext);
    }

    @Override
    public List activateRequestNoNotification(ActionRequestValue actionRequest, boolean simulate) {
        return this.activateRequestNoNotification(actionRequest, new ActivationContext(simulate));
    }

    @Override
    public List activateRequestNoNotification(ActionRequestValue actionRequest, ActivationContext activationContext) {
        activationContext.setGeneratedActionItems(new ArrayList<ActionItem>());
        this.activateRequestInternal(actionRequest, activationContext);
        return activationContext.getGeneratedActionItems();
    }

    private void activateRequestsInternal(Collection actionRequests, ActivationContext activationContext) {
        if (actionRequests == null) {
            return;
        }
        ArrayList actionRequestList = new ArrayList(actionRequests);
        for (int i = 0; i < actionRequestList.size(); ++i) {
            this.activateRequestInternal((ActionRequestValue)actionRequestList.get(i), activationContext);
        }
    }

    private void activateRequestInternal(ActionRequestValue actionRequest, ActivationContext activationContext) {
        PerformanceLogger performanceLogger = null;
        if (LOG.isInfoEnabled()) {
            performanceLogger = new PerformanceLogger();
        }
        if (actionRequest == null || actionRequest.isActive() || actionRequest.isDeactivated()) {
            return;
        }
        this.processResponsibilityId(actionRequest);
        if (this.deactivateOnActionAlreadyTaken(actionRequest, activationContext)) {
            return;
        }
        if (this.deactivateOnInactiveGroup(actionRequest, activationContext)) {
            return;
        }
        if (this.deactivateOnEmptyGroup(actionRequest, activationContext)) {
            return;
        }
        actionRequest.setStatus(ActionRequestStatus.ACTIVATED.getCode());
        if (!activationContext.isSimulation()) {
            this.saveActionRequest(actionRequest);
            activationContext.getGeneratedActionItems().addAll(this.generateActionItems(actionRequest, activationContext));
        }
        this.activateRequestsInternal(actionRequest.getChildrenRequests(), activationContext);
        this.activateRequestInternal(actionRequest.getParentActionRequest(), activationContext);
        if (LOG.isInfoEnabled()) {
            if (activationContext.isSimulation()) {
                performanceLogger.log("Time to simulate activation of request.");
            } else {
                performanceLogger.log("Time to activate action request with id " + actionRequest.getActionRequestId());
            }
        }
    }

    private List<ActionItem> generateActionItems(ActionRequestValue actionRequest, ActivationContext activationContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("generating the action items for request " + actionRequest.getActionRequestId()));
        }
        ArrayList<ActionItem> actionItems = new ArrayList<ActionItem>();
        if (!actionRequest.isPrimaryDelegator()) {
            if (actionRequest.isGroupRequest()) {
                List principalIds = KimApiServiceLocator.getGroupService().getMemberPrincipalIds(actionRequest.getGroupId());
                actionItems.addAll(this.createActionItemsForPrincipals(actionRequest, principalIds));
            } else if (actionRequest.isUserRequest()) {
                ActionItem actionItem = this.getActionListService().createActionItemForActionRequest(actionRequest);
                actionItems.add(actionItem);
            }
        }
        if (!activationContext.isSimulation()) {
            for (ActionItem actionItem : actionItems) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Saving action item: " + actionItems));
                }
                this.getActionListService().saveActionItem(actionItem);
            }
        } else {
            actionRequest.getSimulatedActionItems().addAll(actionItems);
        }
        return actionItems;
    }

    private List<ActionItem> createActionItemsForPrincipals(ActionRequestValue actionRequest, List<String> principalIds) {
        ArrayList<ActionItem> actionItems = new ArrayList<ActionItem>();
        for (String principalId : principalIds) {
            ActionItem actionItem = this.getActionListService().createActionItemForActionRequest(actionRequest);
            actionItem.setPrincipalId(principalId);
            actionItem.setRoleName(actionRequest.getQualifiedRoleName());
            String ignoreUnknownPrincipalIdsValue = ConfigContext.getCurrentContextConfig().getProperty("ignoreUnknownPrincipalIds");
            boolean ignoreUnknownPrincipalIds = Boolean.parseBoolean(ignoreUnknownPrincipalIdsValue);
            if (principalId == null && ignoreUnknownPrincipalIds) {
                LOG.warn((Object)("Ignoring action item with actionRequestID of " + actionRequest.getActionRequestId() + " due to null principalId."));
                continue;
            }
            if (principalId == null) {
                IllegalArgumentException e = new IllegalArgumentException("Exception thrown when trying to add action item with null principalId");
                LOG.error((Object)e);
                throw e;
            }
            actionItems.add(actionItem);
        }
        return actionItems;
    }

    private void processResponsibilityId(ActionRequestValue actionRequest) {
        if (actionRequest.getResolveResponsibility()) {
            String responsibilityId = actionRequest.getResponsibilityId();
            try {
                RouteModule routeModule = KEWServiceLocator.getRouteModuleService().findRouteModule(actionRequest);
                if (responsibilityId != null && actionRequest.isRouteModuleRequest()) {
                    ResponsibleParty responsibleParty;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Resolving responsibility id for action request id=" + actionRequest.getActionRequestId() + " and responsibility id=" + actionRequest.getResponsibilityId()));
                    }
                    if ((responsibleParty = routeModule.resolveResponsibilityId(actionRequest.getResponsibilityId())) == null) {
                        return;
                    }
                    if (responsibleParty.getPrincipalId() != null) {
                        Principal user = KimApiServiceLocator.getIdentityService().getPrincipal(responsibleParty.getPrincipalId());
                        actionRequest.setPrincipalId(user.getPrincipalId());
                    } else if (responsibleParty.getGroupId() != null) {
                        actionRequest.setGroupId(responsibleParty.getGroupId());
                    } else if (responsibleParty.getRoleName() != null) {
                        actionRequest.setRoleName(responsibleParty.getRoleName());
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Exception thrown when trying to resolve responsibility id " + responsibilityId), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    protected boolean deactivateOnActionAlreadyTaken(ActionRequestValue actionRequestToActivate, ActivationContext activationContext) {
        FutureRequestDocumentStateManager futureRequestStateMngr = null;
        if (actionRequestToActivate.isGroupRequest()) {
            futureRequestStateMngr = new FutureRequestDocumentStateManager(actionRequestToActivate.getRouteHeader(), actionRequestToActivate.getGroup());
        } else if (actionRequestToActivate.isUserRequest()) {
            futureRequestStateMngr = new FutureRequestDocumentStateManager(actionRequestToActivate.getRouteHeader(), actionRequestToActivate.getPrincipalId());
        } else {
            return false;
        }
        if (futureRequestStateMngr.isReceiveFutureRequests()) {
            return false;
        }
        if (!actionRequestToActivate.getForceAction().booleanValue() || futureRequestStateMngr.isDoNotReceiveFutureRequests()) {
            ActionTakenValue previousActionTaken = null;
            previousActionTaken = !activationContext.isSimulation() ? this.getActionTakenService().getPreviousAction(actionRequestToActivate) : this.getActionTakenService().getPreviousAction(actionRequestToActivate, activationContext.getSimulatedActionsTaken());
            if (previousActionTaken != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("found a satisfying action taken so setting this request done.  Action Request Id " + actionRequestToActivate.getActionRequestId()));
                }
                if (!previousActionTaken.isForDelegator() && actionRequestToActivate.getParentActionRequest() != null) {
                    previousActionTaken.setDelegator(actionRequestToActivate.getParentActionRequest().getRecipient());
                    if (!activationContext.isSimulation()) {
                        this.getActionTakenService().saveActionTaken(previousActionTaken);
                    }
                }
                this.deactivateRequest(previousActionTaken, actionRequestToActivate, null, activationContext);
                return true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Forcing action for action request " + actionRequestToActivate.getActionRequestId()));
        }
        return false;
    }

    protected boolean deactivateOnEmptyGroup(ActionRequestValue actionRequestToActivate, ActivationContext activationContext) {
        if (actionRequestToActivate.isGroupRequest() && KimApiServiceLocator.getGroupService().getMemberPrincipalIds(actionRequestToActivate.getGroup().getId()).isEmpty()) {
            this.deactivateRequest(null, actionRequestToActivate, null, activationContext);
            return true;
        }
        return false;
    }

    protected boolean deactivateOnInactiveGroup(ActionRequestValue actionRequestToActivate, ActivationContext activationContext) {
        if (actionRequestToActivate.isGroupRequest() && !actionRequestToActivate.getGroup().isActive() && !actionRequestToActivate.getRouteHeader().getDocumentType().getFailOnInactiveGroup().getPolicyValue().booleanValue()) {
            this.deactivateRequest(null, actionRequestToActivate, null, activationContext);
            return true;
        }
        return false;
    }

    @Override
    public void deactivateRequest(ActionTakenValue actionTaken, ActionRequestValue actionRequest) {
        this.deactivateRequest(actionTaken, actionRequest, null, new ActivationContext(false));
    }

    @Override
    public void deactivateRequest(ActionTakenValue actionTaken, ActionRequestValue actionRequest, boolean simulate) {
        this.deactivateRequest(actionTaken, actionRequest, null, new ActivationContext(simulate));
    }

    @Override
    public void deactivateRequest(ActionTakenValue actionTaken, ActionRequestValue actionRequest, ActivationContext activationContext) {
        this.deactivateRequest(actionTaken, actionRequest, null, activationContext);
    }

    @Override
    public void deactivateRequests(ActionTakenValue actionTaken, List actionRequests) {
        this.deactivateRequests(actionTaken, actionRequests, null, new ActivationContext(false));
    }

    @Override
    public void deactivateRequests(ActionTakenValue actionTaken, List actionRequests, boolean simulate) {
        this.deactivateRequests(actionTaken, actionRequests, null, new ActivationContext(simulate));
    }

    @Override
    public void deactivateRequests(ActionTakenValue actionTaken, List actionRequests, ActivationContext activationContext) {
        this.deactivateRequests(actionTaken, actionRequests, null, activationContext);
    }

    private void deactivateRequests(ActionTakenValue actionTaken, Collection actionRequests, ActionRequestValue deactivationRequester, ActivationContext activationContext) {
        if (actionRequests == null) {
            return;
        }
        for (ActionRequestValue actionRequest : actionRequests) {
            this.deactivateRequest(actionTaken, actionRequest, deactivationRequester, activationContext);
        }
    }

    private void deactivateRequest(ActionTakenValue actionTaken, ActionRequestValue actionRequest, ActionRequestValue deactivationRequester, ActivationContext activationContext) {
        if (actionRequest == null || actionRequest.isDeactivated() || this.haltForAllApprove(actionRequest, deactivationRequester)) {
            return;
        }
        actionRequest.setStatus(ActionRequestStatus.DONE.getCode());
        actionRequest.setActionTaken(actionTaken);
        if (actionTaken != null) {
            actionTaken.getActionRequests().add(actionRequest);
        }
        if (!activationContext.isSimulation()) {
            this.getActionRequestDAO().saveActionRequest(actionRequest);
            this.deleteActionItems(actionRequest);
        }
        this.deactivateRequests(actionTaken, actionRequest.getChildrenRequests(), actionRequest, activationContext);
        this.deactivateRequest(actionTaken, actionRequest.getParentActionRequest(), actionRequest, activationContext);
    }

    private boolean haltForAllApprove(ActionRequestValue actionRequest, ActionRequestValue deactivationRequester) {
        if (ActionRequestPolicy.ALL.getCode().equals(actionRequest.getApprovePolicy()) && actionRequest.hasChild(deactivationRequester)) {
            boolean allDeactivated = true;
            for (ActionRequestValue childRequest : actionRequest.getChildrenRequests()) {
                allDeactivated = childRequest.isDeactivated();
                if (allDeactivated) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<ActionRequestValue> getRootRequests(Collection<ActionRequestValue> actionRequests) {
        HashSet<ActionRequestValue> unsavedRequests = new HashSet<ActionRequestValue>();
        HashMap<String, ActionRequestValue> requestMap = new HashMap<String, ActionRequestValue>();
        for (ActionRequestValue actionRequest1 : actionRequests) {
            ActionRequestValue actionRequest = actionRequest1;
            ActionRequestValue rootRequest = this.getRoot(actionRequest);
            if (rootRequest.getActionRequestId() != null) {
                requestMap.put(rootRequest.getActionRequestId(), rootRequest);
                continue;
            }
            unsavedRequests.add(rootRequest);
        }
        ArrayList<ActionRequestValue> requests = new ArrayList<ActionRequestValue>();
        requests.addAll(requestMap.values());
        requests.addAll(unsavedRequests);
        return requests;
    }

    @Override
    public ActionRequestValue getRoot(ActionRequestValue actionRequest) {
        if (actionRequest == null) {
            return null;
        }
        if (actionRequest.getParentActionRequest() != null) {
            return this.getRoot(actionRequest.getParentActionRequest());
        }
        return actionRequest;
    }

    @Override
    public List<ActionRequestValue> findAllPendingRequests(String documentId) {
        ActionRequestDAO arDAO = this.getActionRequestDAO();
        List<ActionRequestValue> pendingArs = arDAO.findByStatusAndDocId(ActionRequestStatus.ACTIVATED.getCode(), documentId);
        return pendingArs;
    }

    @Override
    public List findAllValidRequests(String principalId, String documentId, String requestCode) {
        ActionRequestDAO arDAO = this.getActionRequestDAO();
        List<ActionRequestValue> pendingArs = arDAO.findByStatusAndDocId(ActionRequestStatus.ACTIVATED.getCode(), documentId);
        return this.findAllValidRequests(principalId, pendingArs, requestCode);
    }

    @Override
    public List findAllValidRequests(String principalId, Collection actionRequests, String requestCode) {
        ArrayList matchedArs = new ArrayList();
        List arGroups = KimApiServiceLocator.getGroupService().getGroupIdsByPrincipalId(principalId);
        return this.filterActionRequestsByCode((List)actionRequests, principalId, arGroups, requestCode);
    }

    @Override
    public List<ActionRequestValue> filterActionRequestsByCode(List<ActionRequestValue> actionRequests, String principalId, List<String> principalGroupIds, String requestCode) {
        ArrayList<ActionRequestValue> filteredActionRequests = new ArrayList<ActionRequestValue>();
        Object arGroups = null;
        for (ActionRequestValue ar : actionRequests) {
            if (ActionRequestValue.compareActionCode(ar.getActionRequested(), requestCode, true) > 0) continue;
            if (ar.isUserRequest() && principalId.equals(ar.getPrincipalId())) {
                filteredActionRequests.add(ar);
                continue;
            }
            if (!ar.isGroupRequest() || principalGroupIds == null || principalGroupIds.isEmpty()) continue;
            for (String groupId : principalGroupIds) {
                if (!groupId.equals(ar.getGroupId())) continue;
                filteredActionRequests.add(ar);
            }
        }
        return filteredActionRequests;
    }

    @Override
    public void updateActionRequestsForResponsibilityChange(Set<String> responsibilityIds) {
        PerformanceLogger performanceLogger = null;
        if (LOG.isInfoEnabled()) {
            performanceLogger = new PerformanceLogger();
        }
        Collection documentsAffected = this.getRouteHeaderService().findPendingByResponsibilityIds(responsibilityIds);
        String cacheWaitValue = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-WKFLW", "Rule", "RULE_CACHE_REQUEUE_DELAY");
        Long cacheWait = 5000L;
        if (!StringUtils.isEmpty((String)cacheWaitValue)) {
            try {
                cacheWait = Long.valueOf(cacheWaitValue);
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Cache wait time is not a valid number: " + cacheWaitValue));
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Scheduling requeue of " + documentsAffected.size() + " documents, affected by " + responsibilityIds.size() + " responsibility changes.  Installing a processing wait time of " + cacheWait + " milliseconds to avoid stale rule cache."));
        }
        for (Object aDocumentsAffected : documentsAffected) {
            String documentId = (String)aDocumentsAffected;
            String applicationId = null;
            DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByDocumentId(documentId);
            if (documentType != null) {
                applicationId = documentType.getApplicationId();
            }
            if (applicationId == null) {
                applicationId = CoreConfigHelper.getApplicationId();
            }
            if (!documentType.getRegenerateActionRequestsOnChange().getPolicyValue().booleanValue()) continue;
            DocumentRefreshQueue documentRequeuer = KewApiServiceLocator.getDocumentRequeuerService((String)applicationId, (String)documentId, (long)cacheWait);
            documentRequeuer.refreshDocument(documentId);
        }
        if (LOG.isInfoEnabled()) {
            performanceLogger.log("Time to updateActionRequestsForResponsibilityChange");
        }
    }

    @Override
    public void deleteActionRequestGraph(ActionRequestValue actionRequest) {
        ActionTakenValue actionTaken;
        this.deleteActionItems(actionRequest);
        if (actionRequest.getActionTakenId() != null && (actionTaken = this.getActionTakenService().findByActionTakenId(actionRequest.getActionTakenId())) != null) {
            this.getActionTakenService().delete(actionTaken);
        }
        this.getActionRequestDAO().delete(actionRequest.getActionRequestId());
        for (ActionRequestValue child : actionRequest.getChildrenRequests()) {
            this.deleteActionRequestGraph(child);
        }
    }

    private void deleteActionItems(ActionRequestValue actionRequest) {
        List<ActionItem> actionItems = actionRequest.getActionItems();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("deleting " + actionItems.size() + " action items for action request: " + actionRequest));
        }
        for (ActionItem actionItem : actionItems) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("deleting action item: " + actionItem));
            }
            this.getActionListService().deleteActionItem(actionItem);
        }
    }

    @Override
    public List<ActionRequestValue> findByDocumentIdIgnoreCurrentInd(String documentId) {
        return this.getActionRequestDAO().findByDocumentIdIgnoreCurrentInd(documentId);
    }

    @Override
    public List<ActionRequestValue> findAllActionRequestsByDocumentId(String documentId) {
        return this.getActionRequestDAO().findAllByDocId(documentId);
    }

    @Override
    public List<ActionRequestValue> findAllRootActionRequestsByDocumentId(String documentId) {
        return this.getActionRequestDAO().findAllRootByDocId(documentId);
    }

    @Override
    public List<ActionRequestValue> findPendingByActionRequestedAndDocId(String actionRequestedCd, String documentId) {
        return this.getActionRequestDAO().findPendingByActionRequestedAndDocId(actionRequestedCd, documentId);
    }

    @Override
    public List<String> getPrincipalIdsWithPendingActionRequestByActionRequestedAndDocId(String actionRequestedCd, String documentId) {
        ArrayList<String> principalIds = new ArrayList<String>();
        List<ActionRequestValue> actionRequests = this.findPendingByActionRequestedAndDocId(actionRequestedCd, documentId);
        for (ActionRequestValue actionRequest : actionRequests) {
            if (actionRequest.isUserRequest()) {
                principalIds.add(actionRequest.getPrincipalId());
                continue;
            }
            if (!actionRequest.isGroupRequest()) continue;
            principalIds.addAll(KimApiServiceLocator.getGroupService().getMemberPrincipalIds(actionRequest.getGroupId()));
        }
        return principalIds;
    }

    @Override
    public List<ActionRequestValue> findPendingByDocIdAtOrBelowRouteLevel(String documentId, Integer routeLevel) {
        return this.getActionRequestDAO().findPendingByDocIdAtOrBelowRouteLevel(documentId, routeLevel);
    }

    @Override
    public List<ActionRequestValue> findPendingRootRequestsByDocId(String documentId) {
        return this.getRootRequests(this.findPendingByDoc(documentId));
    }

    @Override
    public List<ActionRequestValue> findPendingRootRequestsByDocIdAtRouteNode(String documentId, String nodeInstanceId) {
        return this.getActionRequestDAO().findPendingRootRequestsByDocIdAtRouteNode(documentId, nodeInstanceId);
    }

    @Override
    public List<ActionRequestValue> findRootRequestsByDocIdAtRouteNode(String documentId, String nodeInstanceId) {
        return this.getActionRequestDAO().findRootRequestsByDocIdAtRouteNode(documentId, nodeInstanceId);
    }

    @Override
    public List<ActionRequestValue> findPendingRootRequestsByDocIdAtOrBelowRouteLevel(String documentId, Integer routeLevel) {
        return this.getActionRequestDAO().findPendingRootRequestsByDocIdAtOrBelowRouteLevel(documentId, routeLevel);
    }

    @Override
    public List<ActionRequestValue> findPendingRootRequestsByDocIdAtRouteLevel(String documentId, Integer routeLevel) {
        return this.getActionRequestDAO().findPendingRootRequestsByDocIdAtRouteLevel(documentId, routeLevel);
    }

    @Override
    public List<ActionRequestValue> findPendingRootRequestsByDocumentType(String documentTypeId) {
        return this.getActionRequestDAO().findPendingRootRequestsByDocumentType(documentTypeId);
    }

    @Override
    public void saveActionRequest(ActionRequestValue actionRequest) {
        if (actionRequest.isGroupRequest()) {
            Group group = actionRequest.getGroup();
            if (group == null) {
                throw new RiceRuntimeException("Attempted to save an action request with a non-existent group.");
            }
            if (!group.isActive() && actionRequest.getRouteHeader().getDocumentType().getFailOnInactiveGroup().getPolicyValue().booleanValue()) {
                throw new RiceRuntimeException("Attempted to save an action request with an inactive group.");
            }
        }
        this.getActionRequestDAO().saveActionRequest(actionRequest);
    }

    @Override
    public List<ActionRequestValue> findPendingByDoc(String documentId) {
        return this.getActionRequestDAO().findAllPendingByDocId(documentId);
    }

    @Override
    public List<ActionRequestValue> findPendingByDocRequestCdRouteLevel(String documentId, String requestCode, Integer routeLevel) {
        ArrayList<ActionRequestValue> requests = new ArrayList<ActionRequestValue>();
        for (ActionRequestValue object : this.getActionRequestDAO().findAllPendingByDocId(documentId)) {
            ActionRequestValue actionRequest = object;
            if (ActionRequestValue.compareActionCode(actionRequest.getActionRequested(), requestCode, true) > 0 || actionRequest.getRouteLevel().intValue() != routeLevel.intValue()) continue;
            requests.add(actionRequest);
        }
        return requests;
    }

    @Override
    public List<ActionRequestValue> findPendingByDocRequestCdNodeName(String documentId, String requestCode, String nodeName) {
        ArrayList<ActionRequestValue> requests = new ArrayList<ActionRequestValue>();
        for (ActionRequestValue object : this.getActionRequestDAO().findAllPendingByDocId(documentId)) {
            ActionRequestValue actionRequest = object;
            if (ActionRequestValue.compareActionCode(actionRequest.getActionRequested(), requestCode, true) > 0 || actionRequest.getNodeInstance() == null || !actionRequest.getNodeInstance().getName().equals(nodeName)) continue;
            requests.add(actionRequest);
        }
        return requests;
    }

    @Override
    public List findActivatedByGroup(String groupId) {
        return this.getActionRequestDAO().findActivatedByGroup(groupId);
    }

    private ActionListService getActionListService() {
        return KEWServiceLocator.getActionListService();
    }

    private ActionTakenService getActionTakenService() {
        return KEWServiceLocator.getActionTakenService();
    }

    public ActionRequestDAO getActionRequestDAO() {
        return this.actionRequestDAO;
    }

    public void setActionRequestDAO(ActionRequestDAO actionRequestDAO) {
        this.actionRequestDAO = actionRequestDAO;
    }

    private RouteHeaderService getRouteHeaderService() {
        return (RouteHeaderService)KEWServiceLocator.getService("enDocumentRouteHeaderService");
    }

    @Override
    public List<ActionRequestValue> findByStatusAndDocId(String statusCd, String documentId) {
        return this.getActionRequestDAO().findByStatusAndDocId(statusCd, documentId);
    }

    @Override
    public void alterActionRequested(List actionRequests, String actionRequestCd) {
        for (Object actionRequest1 : actionRequests) {
            ActionRequestValue actionRequest = (ActionRequestValue)actionRequest1;
            actionRequest.setActionRequested(actionRequestCd);
            for (ActionItem item : actionRequest.getActionItems()) {
                item.setActionRequestCd(actionRequestCd);
            }
            this.saveActionRequest(actionRequest);
        }
    }

    @Override
    public boolean isDuplicateRequest(ActionRequestValue actionRequest) {
        List<ActionRequestValue> requests = this.findAllRootActionRequestsByDocumentId(actionRequest.getDocumentId());
        for (ActionRequestValue existingRequest : requests) {
            if (!existingRequest.getStatus().equals(ActionRequestStatus.DONE.getCode()) || !existingRequest.getRouteLevel().equals(actionRequest.getRouteLevel()) || !ObjectUtils.equals((Object)existingRequest.getPrincipalId(), (Object)actionRequest.getPrincipalId()) || !ObjectUtils.equals((Object)existingRequest.getGroupId(), (Object)actionRequest.getGroupId()) || !ObjectUtils.equals((Object)existingRequest.getRoleName(), (Object)actionRequest.getRoleName()) || !ObjectUtils.equals((Object)existingRequest.getQualifiedRoleName(), (Object)actionRequest.getQualifiedRoleName()) || !existingRequest.getActionRequested().equals(actionRequest.getActionRequested())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Recipient findDelegator(List actionRequests) {
        Recipient delegator = null;
        String requestCode = "F";
        for (Object actionRequest1 : actionRequests) {
            ActionRequestValue actionRequest = (ActionRequestValue)actionRequest1;
            ActionRequestValue delegatorRequest = this.findDelegatorRequest(actionRequest);
            if (delegatorRequest == null || ActionRequestValue.compareActionCode(delegatorRequest.getActionRequested(), requestCode, true) < 0) continue;
            delegator = delegatorRequest.getRecipient();
            requestCode = delegatorRequest.getActionRequested();
        }
        return delegator;
    }

    @Override
    public Recipient findDelegator(ActionRequestValue actionRequest) {
        ActionRequestValue delegatorRequest = this.findDelegatorRequest(actionRequest);
        Recipient delegator = null;
        if (delegatorRequest != null) {
            delegator = delegatorRequest.getRecipient();
        }
        return delegator;
    }

    @Override
    public ActionRequestValue findDelegatorRequest(ActionRequestValue actionRequest) {
        ActionRequestValue parentRequest = actionRequest.getParentActionRequest();
        if (parentRequest != null && !parentRequest.isUserRequest() && !parentRequest.isGroupRequest()) {
            parentRequest = this.findDelegatorRequest(parentRequest);
        }
        return parentRequest;
    }

    @Override
    public void deleteByDocumentId(String documentId) {
        this.actionRequestDAO.deleteByDocumentId(documentId);
    }

    @Override
    public void deleteByActionRequestId(String actionRequestId) {
        this.actionRequestDAO.delete(actionRequestId);
    }

    @Override
    public void validateActionRequest(ActionRequestValue actionRequest) {
        String recipientType;
        Integer routeLevel;
        Integer priority;
        LOG.debug((Object)"Enter validateActionRequest(..)");
        ArrayList<WorkflowServiceErrorImpl> errors = new ArrayList<WorkflowServiceErrorImpl>();
        String actionRequestCd = actionRequest.getActionRequested();
        if (actionRequestCd == null || actionRequestCd.trim().equals("")) {
            errors.add(new WorkflowServiceErrorImpl("ActionRequest cd null.", "actionrequest.actionrequestcd.empty", actionRequest.getActionRequestId().toString()));
        } else if (!KewApiConstants.ACTION_REQUEST_CD.containsKey(actionRequestCd)) {
            errors.add(new WorkflowServiceErrorImpl("ActionRequest cd invalid.", "actionrequest.actionrequestcd.invalid", actionRequest.getActionRequestId().toString()));
        }
        String documentId = actionRequest.getDocumentId();
        if (documentId == null || StringUtils.isEmpty((String)documentId)) {
            errors.add(new WorkflowServiceErrorImpl("ActionRequest Document id empty.", "actionrequest.documentid.empty", actionRequest.getActionRequestId().toString()));
        } else if (this.getRouteHeaderService().getRouteHeader(documentId) == null) {
            errors.add(new WorkflowServiceErrorImpl("ActionRequest Document id invalid.", "actionrequest.documentid.invalid", actionRequest.getActionRequestId().toString()));
        }
        String actionRequestStatus = actionRequest.getStatus();
        if (actionRequestStatus == null || actionRequestStatus.trim().equals("")) {
            errors.add(new WorkflowServiceErrorImpl("ActionRequest status null.", "actionrequest.actionrequeststatus.empty", actionRequest.getActionRequestId().toString()));
        } else if (ActionRequestStatus.fromCode((String)actionRequestStatus) == null) {
            errors.add(new WorkflowServiceErrorImpl("ActionRequest status invalid.", "actionrequest.actionrequeststatus.invalid", actionRequest.getActionRequestId().toString()));
        }
        if (actionRequest.getResponsibilityId() == null) {
            errors.add(new WorkflowServiceErrorImpl("ActionRequest responsibility id null.", "actionrequest.responsibilityid.empty", actionRequest.getActionRequestId().toString()));
        }
        if ((priority = actionRequest.getPriority()) == null) {
            errors.add(new WorkflowServiceErrorImpl("ActionRequest priority null.", "actionrequest.priority.empty", actionRequest.getActionRequestId().toString()));
        }
        if ((routeLevel = actionRequest.getRouteLevel()) == null) {
            errors.add(new WorkflowServiceErrorImpl("ActionRequest route level null.", "actionrequest.routelevel.empty", actionRequest.getActionRequestId().toString()));
        } else if (routeLevel < -1) {
            errors.add(new WorkflowServiceErrorImpl("ActionRequest route level invalid.", "actionrequest.routelevel.invalid", actionRequest.getActionRequestId().toString()));
        }
        Integer version = actionRequest.getDocVersion();
        if (version == null) {
            errors.add(new WorkflowServiceErrorImpl("ActionRequest doc version null.", "actionrequest.docversion.empty", actionRequest.getActionRequestId().toString()));
        }
        if (actionRequest.getCreateDate() == null) {
            errors.add(new WorkflowServiceErrorImpl("ActionRequest create date null.", "actionrequest.createdate.empty", actionRequest.getActionRequestId().toString()));
        }
        if ((recipientType = actionRequest.getRecipientTypeCd()) != null && !recipientType.trim().equals("")) {
            if (recipientType.equals("workgroup")) {
                String workgroupId = actionRequest.getGroupId();
                if (workgroupId == null) {
                    errors.add(new WorkflowServiceErrorImpl("ActionRequest workgroup null.", "actionrequest.workgroup.empty", actionRequest.getActionRequestId().toString()));
                } else if (KimApiServiceLocator.getGroupService().getGroup(workgroupId) == null) {
                    errors.add(new WorkflowServiceErrorImpl("ActionRequest workgroup invalid.", "actionrequest.workgroup.invalid", actionRequest.getActionRequestId().toString()));
                }
            }
            if (recipientType.equals("person")) {
                String principalId = actionRequest.getPrincipalId();
                if (principalId == null || principalId.trim().equals("")) {
                    errors.add(new WorkflowServiceErrorImpl("ActionRequest person id null.", "actionrequest.persosn.empty", actionRequest.getActionRequestId().toString()));
                } else {
                    Principal principal = KimApiServiceLocator.getIdentityService().getPrincipal(principalId);
                    if (principal == null) {
                        errors.add(new WorkflowServiceErrorImpl("ActionRequest person id invalid.", "actionrequest.personid.invalid", actionRequest.getActionRequestId().toString()));
                    }
                }
                if (recipientType.equals("role") && (actionRequest.getRoleName() == null || actionRequest.getRoleName().trim().equals(""))) {
                    errors.add(new WorkflowServiceErrorImpl("ActionRequest role name null.", "actionrequest.rolename.null", actionRequest.getActionRequestId().toString()));
                }
            }
            LOG.debug((Object)"Exit validateActionRequest(..) ");
            if (!errors.isEmpty()) {
                throw new WorkflowServiceErrorException("ActionRequest Validation Error", errors);
            }
        }
    }

    @Override
    public List getDelegateRequests(ActionRequestValue actionRequest) {
        ArrayList<ActionRequestValue> delegateRequests = new ArrayList<ActionRequestValue>();
        List requests = this.getTopLevelRequests(actionRequest);
        for (Object request : requests) {
            ActionRequestValue parentActionRequest = (ActionRequestValue)request;
            delegateRequests.addAll(parentActionRequest.getChildrenRequests());
        }
        return delegateRequests;
    }

    @Override
    public List getTopLevelRequests(ActionRequestValue actionRequest) {
        ArrayList<ActionRequestValue> topLevelRequests = new ArrayList<ActionRequestValue>();
        if (actionRequest.isRoleRequest()) {
            topLevelRequests.addAll(actionRequest.getChildrenRequests());
        } else {
            topLevelRequests.add(actionRequest);
        }
        return topLevelRequests;
    }

    @Override
    public boolean isValidActionRequestCode(String actionRequestCode) {
        return actionRequestCode != null && KewApiConstants.ACTION_REQUEST_CODES.containsKey(actionRequestCode);
    }

    @Override
    public boolean doesPrincipalHaveRequest(String principalId, String documentId) {
        if (this.getActionRequestDAO().doesDocumentHaveUserRequest(principalId, documentId)) {
            return true;
        }
        List<String> groupIds = this.getActionRequestDAO().getRequestGroupIds(documentId);
        for (String groupId : groupIds) {
            if (!KimApiServiceLocator.getGroupService().isMemberOfGroup(principalId, groupId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ActionRequestValue getActionRequestForRole(String actionTakenId) {
        return this.getActionRequestDAO().getRoleActionRequestByActionTakenId(actionTakenId);
    }
}

