/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actions.ActionTakenEvent;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.exception.WorkflowServiceErrorException;
import org.kuali.rice.kew.exception.WorkflowServiceErrorImpl;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;

abstract class SuperUserActionTakenEvent
extends ActionTakenEvent {
    private static final Logger LOG = Logger.getLogger(SuperUserActionTakenEvent.class);
    protected final String superUserAction;
    private ActionRequestValue actionRequest;
    public static String AUTHORIZATION = "general.routing.superuser.notAuthorized";

    protected SuperUserActionTakenEvent(String actionTakenCode, String superUserAction, DocumentRouteHeaderValue routeHeader, PrincipalContract principal) {
        super(actionTakenCode, routeHeader, principal);
        this.superUserAction = superUserAction;
    }

    protected SuperUserActionTakenEvent(String actionTakenCode, String superUserAction, DocumentRouteHeaderValue routeHeader, PrincipalContract principal, String annotation, boolean runPostProcessor) {
        super(actionTakenCode, routeHeader, principal, annotation, runPostProcessor);
        this.superUserAction = superUserAction;
    }

    @Override
    public String validateActionRules() {
        DocumentType docType = this.getRouteHeader().getDocumentType();
        String principalId = this.getPrincipal().getPrincipalId();
        String docId = this.getRouteHeader().getDocumentId();
        List<RouteNodeInstance> currentNodeInstances = KEWServiceLocator.getRouteNodeService().getCurrentNodeInstances(docId);
        String documentStatus = KewApiServiceLocator.getWorkflowDocumentService().getDocumentStatus(docId).getCode();
        boolean canAdministerRouting = KEWServiceLocator.getDocumentTypePermissionService().canAdministerRouting(principalId, docType);
        boolean canSuperUserApproveSingleActionRequest = KEWServiceLocator.getDocumentTypePermissionService().canSuperUserApproveSingleActionRequest(principalId, docType, currentNodeInstances, documentStatus) && "SU_ACTION_REQUEST_APPROVE".equals(this.getSuperUserAction());
        boolean canSuperUserApproveDocument = KEWServiceLocator.getDocumentTypePermissionService().canSuperUserApproveDocument(principalId, docType, currentNodeInstances, documentStatus) && "SU_APPROVE".equals(this.getSuperUserAction());
        boolean canSuperUserDisapproveDocument = KEWServiceLocator.getDocumentTypePermissionService().canSuperUserDisapproveDocument(principalId, docType, currentNodeInstances, documentStatus) && "SU_DISAPPROVE".equals(this.getSuperUserAction());
        String s = this.superUserAction;
        if (!(canAdministerRouting || canSuperUserApproveSingleActionRequest || canSuperUserApproveDocument || canSuperUserDisapproveDocument)) {
            return "User not authorized to take super user action " + this.getSuperUserAction() + " on document " + docId;
        }
        return "";
    }

    @Override
    public String validateActionRules(List<ActionRequestValue> actionRequests) {
        return this.validateActionRules();
    }

    @Override
    public void recordAction() throws InvalidActionTakenException {
        String errorMessage = this.validateActionRules();
        if (!StringUtils.isEmpty((String)errorMessage)) {
            LOG.info((Object)"User not authorized");
            ArrayList<WorkflowServiceErrorImpl> errors = new ArrayList<WorkflowServiceErrorImpl>();
            errors.add(new WorkflowServiceErrorImpl(errorMessage, AUTHORIZATION));
            throw new WorkflowServiceErrorException(errorMessage, errors);
        }
        ActionTakenValue actionTaken = this.processActionRequests();
        try {
            String oldStatus = this.getRouteHeader().getDocRouteStatus();
            if (this.getRouteHeader().isStateInitiated()) {
                this.getRouteHeader().markDocumentEnroute();
                this.notifyStatusChange(this.getRouteHeader().getDocRouteStatus(), oldStatus);
            }
            this.markDocument();
            String newStatus = this.getRouteHeader().getDocRouteStatus();
            this.notifyStatusChange(newStatus, oldStatus);
        }
        catch (Exception ex) {
            LOG.error((Object)"Caught Exception talking to post processor", (Throwable)ex);
            throw new RuntimeException(ex.getMessage());
        }
        this.processActionTaken(actionTaken);
    }

    protected abstract void markDocument() throws WorkflowException;

    protected ActionTakenValue processActionRequests() throws InvalidActionTakenException {
        LOG.debug((Object)"Processing pending action requests");
        ActionTakenValue actionTaken = this.saveActionTaken();
        List<ActionRequestValue> actionRequests = this.getActionRequestService().findPendingByDoc(this.getDocumentId());
        for (ActionRequestValue actionRequest : actionRequests) {
            this.getActionRequestService().deactivateRequest(actionTaken, actionRequest);
        }
        this.notifyActionTaken(actionTaken);
        return actionTaken;
    }

    protected void processActionTaken(ActionTakenValue actionTaken) {
    }

    public ActionRequestValue getActionRequest() {
        return this.actionRequest;
    }

    public void setActionRequest(ActionRequestValue actionRequest) {
        this.actionRequest = actionRequest;
    }

    public String getSuperUserAction() {
        return this.superUserAction;
    }
}

