/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.kew.actionrequest.ActionRequestFactory;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actions.SuperUserActionTakenEvent;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.doctype.DocumentTypePolicy;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.BlanketApproveEngine;
import org.kuali.rice.kew.engine.OrchestrationConfig;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.RequestsNode;
import org.kuali.rice.kew.exception.WorkflowServiceErrorException;
import org.kuali.rice.kew.exception.WorkflowServiceErrorImpl;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;

public class SuperUserApproveEvent
extends SuperUserActionTakenEvent {
    private static final Logger LOG = Logger.getLogger(SuperUserApproveEvent.class);
    private final boolean allowFinalApproval;

    public SuperUserApproveEvent(DocumentRouteHeaderValue routeHeader, PrincipalContract principal) {
        this(routeHeader, principal, DEFAULT_ANNOTATION, true);
    }

    public SuperUserApproveEvent(DocumentRouteHeaderValue routeHeader, PrincipalContract principal, String annotation, boolean runPostProcessor) {
        super("a", "SU_APPROVE", routeHeader, principal, annotation, runPostProcessor);
        this.allowFinalApproval = SuperUserApproveEvent.isPolicySet(routeHeader.getDocumentType(), DocumentTypePolicy.ALLOW_SU_FINAL_APPROVAL, true);
    }

    @Override
    public String validateActionRules() {
        String error = super.validateActionRules();
        if (StringUtils.isBlank((String)error) && !this.allowFinalApproval && KEWServiceLocator.getRouteNodeService().findFutureNodeNames(this.getRouteHeader().getDocumentId()).isEmpty()) {
            error = "Super User Approval disallowed on final node by " + DocumentTypePolicy.ALLOW_SU_FINAL_APPROVAL.getCode() + " policy";
        }
        return error;
    }

    @Override
    public void recordAction() throws InvalidActionTakenException {
        DocumentType docType = this.getRouteHeader().getDocumentType();
        String errorMessage = this.validateActionRules();
        if (!StringUtils.isEmpty((String)errorMessage)) {
            LOG.info((Object)"User not authorized");
            ArrayList<WorkflowServiceErrorImpl> errors = new ArrayList<WorkflowServiceErrorImpl>();
            errors.add(new WorkflowServiceErrorImpl(errorMessage, AUTHORIZATION));
            throw new WorkflowServiceErrorException(errorMessage, errors);
        }
        ActionTakenValue actionTaken = this.saveActionTaken();
        this.notifyActionTaken(actionTaken);
        if (this.getRouteHeader().isInException() || this.getRouteHeader().isStateInitiated()) {
            LOG.debug((Object)"Moving document back to Enroute");
            String oldStatus = this.getRouteHeader().getDocRouteStatus();
            this.getRouteHeader().markDocumentEnroute();
            String newStatus = this.getRouteHeader().getDocRouteStatus();
            this.notifyStatusChange(newStatus, oldStatus);
            KEWServiceLocator.getRouteHeaderService().saveRouteHeader(this.getRouteHeader());
        }
        OrchestrationConfig config = new OrchestrationConfig(OrchestrationConfig.EngineCapability.BLANKET_APPROVAL, new HashSet<String>(), actionTaken, docType.getSuperUserApproveNotificationPolicy().getPolicyValue(), this.isRunPostProcessorLogic());
        RequestsNode.setSuppressPolicyErrors(RouteContext.getCurrentRouteContext());
        try {
            this.completeAnyOutstandingCompleteApproveRequests(actionTaken, docType.getSuperUserApproveNotificationPolicy().getPolicyValue());
            BlanketApproveEngine blanketApproveEngine = (BlanketApproveEngine)KEWServiceLocator.getWorkflowEngineFactory().newEngine(config);
            blanketApproveEngine.process(this.getRouteHeader().getDocumentId(), null);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to orchestrate the document to SuperUserApproved.", (Throwable)e);
            throw new InvalidActionTakenException("Failed to orchestrate the document to SuperUserApproved.", (Throwable)e);
        }
    }

    protected void completeAnyOutstandingCompleteApproveRequests(ActionTakenValue actionTaken, boolean sendNotifications) throws Exception {
        List<ActionRequestValue> actionRequests = KEWServiceLocator.getActionRequestService().findPendingByActionRequestedAndDocId("A", this.getDocumentId());
        actionRequests.addAll(KEWServiceLocator.getActionRequestService().findPendingByActionRequestedAndDocId("C", this.getDocumentId()));
        for (ActionRequestValue actionRequest : actionRequests) {
            KEWServiceLocator.getActionRequestService().deactivateRequest(actionTaken, actionRequest);
        }
        if (sendNotifications) {
            new ActionRequestFactory(this.getRouteHeader()).generateNotifications(actionRequests, this.getPrincipal(), this.findDelegatorForActionRequests(actionRequests), "K", "a");
        }
    }

    @Override
    protected void markDocument() throws WorkflowException {
    }
}

