/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actiontaken;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.KimGroupRecipient;
import org.kuali.rice.kew.actionrequest.KimPrincipalRecipient;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.actionrequest.service.ActionRequestService;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.util.CodeTranslator;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

@Entity
@Table(name="KREW_ACTN_TKN_T")
public class ActionTakenValue
implements Serializable {
    private static final long serialVersionUID = -81505450567067594L;
    @Id
    @GeneratedValue(generator="KREW_ACTN_TKN_S")
    @GenericGenerator(name="KREW_ACTN_TKN_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KREW_ACTN_TKN_S"), @Parameter(name="value_column", value="id")})
    @Column(name="ACTN_TKN_ID")
    private String actionTakenId;
    @Column(name="DOC_HDR_ID")
    private String documentId;
    @Column(name="ACTN_CD")
    private String actionTaken;
    @Column(name="ACTN_DT")
    private Timestamp actionDate;
    @Column(name="ANNOTN")
    private String annotation = "";
    @Column(name="DOC_VER_NBR")
    private Integer docVersion;
    @Version
    @Column(name="VER_NBR")
    private Integer lockVerNbr;
    @Column(name="PRNCPL_ID")
    private String principalId;
    @Column(name="DLGTR_PRNCPL_ID")
    private String delegatorPrincipalId;
    @Column(name="DLGTR_GRP_ID")
    private String delegatorGroupId;
    @OneToMany(fetch=FetchType.EAGER, mappedBy="actionTaken")
    @Fetch(value=FetchMode.SELECT)
    private Collection<ActionRequestValue> actionRequests;
    @Column(name="CUR_IND")
    private Boolean currentIndicator = Boolean.TRUE;
    @Transient
    private String actionDateString;

    public Principal getPrincipal() {
        return this.getPrincipalForId(this.principalId);
    }

    public void beforeInsert() {
        OrmUtils.populateAutoIncValue((Object)this, (EntityManager)KEWServiceLocator.getEntityManagerFactory().createEntityManager());
    }

    public String getPrincipalDisplayName() {
        return KEWServiceLocator.getIdentityHelperService().getPerson(this.getPrincipalId()).getName();
    }

    public Principal getDelegatorPrincipal() {
        return this.getPrincipalForId(this.delegatorPrincipalId);
    }

    public Group getDelegatorGroup() {
        return KimApiServiceLocator.getGroupService().getGroup(String.valueOf(this.delegatorGroupId));
    }

    public void setDelegator(Recipient recipient) {
        if (recipient instanceof KimPrincipalRecipient) {
            this.setDelegatorPrincipalId(((KimPrincipalRecipient)recipient).getPrincipalId());
        } else if (recipient instanceof KimGroupRecipient) {
            this.setDelegatorGroupId(((KimGroupRecipient)recipient).getGroup().getId());
        } else {
            this.setDelegatorPrincipalId(null);
            this.setDelegatorGroupId(null);
        }
    }

    public boolean isForDelegator() {
        return this.getDelegatorPrincipalId() != null || this.getDelegatorGroupId() != null || this.getDelegatorRoleId() != null;
    }

    public String getDelegatorDisplayName() {
        if (this.getDelegatorPrincipalId() != null) {
            return KEWServiceLocator.getIdentityHelperService().getPerson(this.getDelegatorPrincipalId()).getName();
        }
        if (this.getDelegatorGroupId() != null) {
            return this.getDelegatorGroup().getName();
        }
        String delegatorRoleId = this.getDelegatorRoleId();
        if (delegatorRoleId != null) {
            Role role = KimApiServiceLocator.getRoleService().getRole(delegatorRoleId);
            if (role != null) {
                return role.getName();
            }
            return "";
        }
        return "";
    }

    private Principal getPrincipalForId(String principalId) {
        Principal principal = null;
        if (!StringUtils.isBlank((String)principalId)) {
            principal = KEWServiceLocator.getIdentityHelperService().getPrincipal(principalId);
        }
        return principal;
    }

    public String getActionTakenLabel() {
        return CodeTranslator.getActionTakenLabel((String)this.actionTaken);
    }

    public Collection<ActionRequestValue> getActionRequests() {
        if (this.actionRequests == null) {
            this.setActionRequests(new ArrayList<ActionRequestValue>());
        }
        return this.actionRequests;
    }

    public void setActionRequests(Collection<ActionRequestValue> actionRequests) {
        this.actionRequests = actionRequests;
    }

    public Timestamp getActionDate() {
        return this.actionDate;
    }

    public void setActionDate(Timestamp actionDate) {
        this.actionDate = actionDate;
    }

    public String getActionTaken() {
        return this.actionTaken;
    }

    public void setActionTaken(String actionTaken) {
        this.actionTaken = actionTaken;
    }

    public String getActionTakenId() {
        return this.actionTakenId;
    }

    public void setActionTakenId(String actionTakenId) {
        this.actionTakenId = actionTakenId;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public String getDelegatorPrincipalId() {
        return this.delegatorPrincipalId;
    }

    public void setDelegatorPrincipalId(String delegatorPrincipalId) {
        this.delegatorPrincipalId = delegatorPrincipalId;
    }

    public String getDelegatorGroupId() {
        return this.delegatorGroupId;
    }

    public void setDelegatorGroupId(String delegatorGroupId) {
        this.delegatorGroupId = delegatorGroupId;
    }

    public String getDelegatorRoleId() {
        ActionRequestValue actionRequest = KEWServiceLocator.getActionRequestService().getActionRequestForRole(this.actionTakenId);
        if (actionRequest != null) {
            return actionRequest.getRoleName();
        }
        return null;
    }

    public Integer getDocVersion() {
        return this.docVersion;
    }

    public void setDocVersion(Integer docVersion) {
        this.docVersion = docVersion;
    }

    public Integer getLockVerNbr() {
        return this.lockVerNbr;
    }

    public void setLockVerNbr(Integer lockVerNbr) {
        this.lockVerNbr = lockVerNbr;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    public Boolean getCurrentIndicator() {
        return this.currentIndicator;
    }

    public void setCurrentIndicator(Boolean currentIndicator) {
        this.currentIndicator = currentIndicator;
    }

    public Collection getRootActionRequests() {
        return this.getActionRequestService().getRootRequests(this.getActionRequests());
    }

    private ActionRequestService getActionRequestService() {
        return (ActionRequestService)KEWServiceLocator.getService("enActionRequestService");
    }

    public String getActionDateString() {
        if (this.actionDateString == null || this.actionDateString.trim().equals("")) {
            return RiceConstants.getDefaultDateFormat().format(this.getActionDate());
        }
        return this.actionDateString;
    }

    public void setActionDateString(String actionDateString) {
        this.actionDateString = actionDateString;
    }

    public boolean isApproval() {
        return "A".equals(this.getActionTaken());
    }

    public boolean isCompletion() {
        return "C".equals(this.getActionTaken());
    }

    public static ActionTaken to(ActionTakenValue actionTakenBo) {
        if (actionTakenBo == null) {
            return null;
        }
        ActionTaken.Builder builder = ActionTaken.Builder.create((String)actionTakenBo.getActionTakenId(), (String)actionTakenBo.getDocumentId(), (String)actionTakenBo.getPrincipalId(), (ActionType)ActionType.fromCode((String)actionTakenBo.getActionTaken()));
        if (actionTakenBo.getActionDate() != null) {
            builder.setActionDate(new DateTime(actionTakenBo.getActionDate().getTime()));
        }
        builder.setAnnotation(actionTakenBo.getAnnotation());
        builder.setCurrent(actionTakenBo.getCurrentIndicator().booleanValue());
        builder.setDelegatorGroupId(actionTakenBo.getDelegatorGroupId());
        builder.setDelegatorPrincipalId(actionTakenBo.getDelegatorPrincipalId());
        return builder.build();
    }

    public boolean isSuperUserAction() {
        return "k".equals(this.actionTaken) || "f".equals(this.actionTaken) || "m".equals(this.actionTaken) || "v".equals(this.actionTaken) || "r".equals(this.actionTaken) || "z".equals(this.actionTaken) || "d".equals(this.actionTaken) || "c".equals(this.actionTaken) || "a".equals(this.actionTaken);
    }
}

