/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actiontaken.dao.impl;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.core.framework.persistence.jpa.criteria.Criteria;
import org.kuali.rice.core.framework.persistence.jpa.criteria.QueryByCriteria;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.actiontaken.dao.ActionTakenDAO;
import org.kuali.rice.kew.api.action.ActionType;

public class ActionTakenDAOJpaImpl
implements ActionTakenDAO {
    @PersistenceContext(unitName="kew-unit")
    private EntityManager entityManager;
    private static final Logger LOG = Logger.getLogger(ActionTakenDAOJpaImpl.class);

    @Override
    public ActionTakenValue load(String id) {
        LOG.debug((Object)("Loading Action Taken for the given id " + id));
        return (ActionTakenValue)this.entityManager.find(ActionTakenValue.class, (Object)id);
    }

    @Override
    public void deleteActionTaken(ActionTakenValue actionTaken) {
        LOG.debug((Object)("deleting ActionTaken " + actionTaken.getActionTakenId()));
        this.entityManager.remove(this.entityManager.find(ActionTakenValue.class, (Object)actionTaken.getActionTakenId()));
    }

    @Override
    public ActionTakenValue findByActionTakenId(String actionTakenId) {
        LOG.debug((Object)("finding Action Taken by actionTakenId " + actionTakenId));
        Criteria crit = new Criteria(ActionTakenValue.class.getName());
        crit.eq("actionTakenId", (Object)actionTakenId);
        crit.eq("currentIndicator", (Object)Boolean.TRUE);
        return (ActionTakenValue)new QueryByCriteria(this.entityManager, crit).toQuery().getSingleResult();
    }

    @Override
    public Collection<ActionTakenValue> findByDocIdAndAction(String documentId, String action) {
        LOG.debug((Object)("finding Action Taken by documentId " + documentId + " and action " + action));
        Criteria crit = new Criteria(ActionTakenValue.class.getName());
        crit.eq("documentId", (Object)documentId);
        crit.eq("actionTaken", (Object)action);
        crit.eq("currentIndicator", (Object)Boolean.TRUE);
        return new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
    }

    @Override
    public Collection<ActionTakenValue> findByDocumentId(String documentId) {
        LOG.debug((Object)("finding Action Takens by documentId " + documentId));
        Criteria crit = new Criteria(ActionTakenValue.class.getName());
        crit.eq("documentId", (Object)documentId);
        crit.eq("currentIndicator", (Object)Boolean.TRUE);
        crit.orderBy("actionDate", true);
        return new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
    }

    @Override
    public List<ActionTakenValue> findByDocumentIdWorkflowId(String documentId, String workflowId) {
        LOG.debug((Object)("finding Action Takens by documentId " + documentId + " and workflowId" + workflowId));
        Criteria crit = new Criteria(ActionTakenValue.class.getName());
        crit.eq("documentId", (Object)documentId);
        crit.eq("principalId", (Object)workflowId);
        crit.eq("currentIndicator", (Object)Boolean.TRUE);
        return new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
    }

    @Override
    public List findByDocumentIdIgnoreCurrentInd(String documentId) {
        LOG.debug((Object)("finding ActionsTaken ignoring currentInd by documentId:" + documentId));
        Criteria crit = new Criteria(ActionTakenValue.class.getName());
        crit.eq("documentId", (Object)documentId);
        return (List)new QueryByCriteria(this.entityManager, crit);
    }

    @Override
    public void saveActionTaken(ActionTakenValue actionTaken) {
        LOG.debug((Object)"saving ActionTaken");
        this.checkNull((Serializable)((Object)actionTaken.getDocumentId()), "Document ID");
        this.checkNull((Serializable)((Object)actionTaken.getActionTaken()), "action taken code");
        this.checkNull(actionTaken.getDocVersion(), "doc version");
        this.checkNull((Serializable)((Object)actionTaken.getPrincipalId()), "principal ID");
        if (actionTaken.getActionDate() == null) {
            actionTaken.setActionDate(new Timestamp(System.currentTimeMillis()));
        }
        if (actionTaken.getCurrentIndicator() == null) {
            actionTaken.setCurrentIndicator(Boolean.TRUE);
        }
        LOG.debug((Object)("saving ActionTaken: routeHeader " + actionTaken.getDocumentId() + ", actionTaken " + actionTaken.getActionTaken() + ", principalId " + actionTaken.getPrincipalId()));
        if (actionTaken.getActionTakenId() == null) {
            this.entityManager.persist((Object)actionTaken);
        } else {
            OrmUtils.merge((EntityManager)this.entityManager, (Object)actionTaken);
        }
    }

    private void checkNull(Serializable value, String valueName) throws RuntimeException {
        if (value == null) {
            throw new RuntimeException("Null value for " + valueName);
        }
    }

    @Override
    public void deleteByDocumentId(String documentId) {
        Criteria crit = new Criteria(ActionRequestValue.class.getName());
        crit.eq("documentId", (Object)documentId);
        ActionRequestValue actionRequestValue = (ActionRequestValue)new QueryByCriteria(this.entityManager, crit).toQuery().getSingleResult();
        this.entityManager.remove((Object)actionRequestValue);
    }

    @Override
    public boolean hasUserTakenAction(String workflowId, String documentId) {
        Criteria crit = new Criteria(ActionTakenValue.class.getName());
        crit.eq("documentId", (Object)documentId);
        crit.eq("principalId", (Object)workflowId);
        crit.eq("currentIndicator", (Object)Boolean.TRUE);
        long count = (Long)new QueryByCriteria(this.entityManager, crit).toCountQuery().getSingleResult();
        return count > 0L;
    }

    @Override
    public Timestamp getLastActionTakenDate(String documentId, ActionType actionType) {
        throw new UnsupportedOperationException("The JPA version of this method still needs to be implemented!");
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

