/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actiontaken.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.actiontaken.dao.ActionTakenDAO;
import org.kuali.rice.kew.actiontaken.service.ActionTakenService;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.exception.WorkflowServiceErrorException;
import org.kuali.rice.kew.exception.WorkflowServiceErrorImpl;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class ActionTakenServiceImpl
implements ActionTakenService {
    private static final Logger LOG = Logger.getLogger(ActionTakenServiceImpl.class);
    private ActionTakenDAO actionTakenDAO;

    @Override
    public ActionTakenValue load(String id) {
        return this.getActionTakenDAO().load(id);
    }

    @Override
    public ActionTakenValue findByActionTakenId(String actionTakenId) {
        return this.getActionTakenDAO().findByActionTakenId(actionTakenId);
    }

    @Override
    public ActionTakenValue getPreviousAction(ActionRequestValue actionRequest) {
        return this.getPreviousAction(actionRequest, null);
    }

    @Override
    public ActionTakenValue getPreviousAction(ActionRequestValue actionRequest, List<ActionTakenValue> simulatedActionsTaken) {
        GroupService ims = KimApiServiceLocator.getGroupService();
        ActionTakenValue foundActionTaken = null;
        ArrayList<String> principalIds = new ArrayList<String>();
        if (actionRequest.isGroupRequest()) {
            principalIds.addAll(ims.getMemberPrincipalIds(actionRequest.getGroup().getId()));
        } else if (actionRequest.isUserRequest()) {
            principalIds.add(actionRequest.getPrincipalId());
        }
        for (String id : principalIds) {
            List<ActionTakenValue> actionsTakenByUser = this.getActionTakenDAO().findByDocumentIdWorkflowId(actionRequest.getDocumentId(), id);
            if (simulatedActionsTaken != null) {
                for (ActionTakenValue simulatedAction : simulatedActionsTaken) {
                    if (!id.equals(simulatedAction.getPrincipalId())) continue;
                    actionsTakenByUser.add(simulatedAction);
                }
            }
            for (ActionTakenValue actionTaken : actionsTakenByUser) {
                if (ActionRequestValue.compareActionCode(actionTaken.getActionTaken(), actionRequest.getActionRequested(), true) < 0) continue;
                foundActionTaken = actionTaken;
            }
        }
        return foundActionTaken;
    }

    @Override
    public Collection findByDocIdAndAction(String docId, String action) {
        return this.getActionTakenDAO().findByDocIdAndAction(docId, action);
    }

    @Override
    public Collection<ActionTakenValue> findByDocumentId(String documentId) {
        return this.getActionTakenDAO().findByDocumentId(documentId);
    }

    @Override
    public List<ActionTakenValue> findByDocumentIdWorkflowId(String documentId, String workflowId) {
        return this.getActionTakenDAO().findByDocumentIdWorkflowId(documentId, workflowId);
    }

    @Override
    public Collection getActionsTaken(String documentId) {
        return this.getActionTakenDAO().findByDocumentId(documentId);
    }

    @Override
    public List findByDocumentIdIgnoreCurrentInd(String documentId) {
        return this.getActionTakenDAO().findByDocumentIdIgnoreCurrentInd(documentId);
    }

    @Override
    public void saveActionTaken(ActionTakenValue actionTaken) {
        this.getActionTakenDAO().saveActionTaken(actionTaken);
    }

    @Override
    public void delete(ActionTakenValue actionTaken) {
        this.getActionTakenDAO().deleteActionTaken(actionTaken);
    }

    public ActionTakenDAO getActionTakenDAO() {
        return this.actionTakenDAO;
    }

    public void setActionTakenDAO(ActionTakenDAO actionTakenDAO) {
        this.actionTakenDAO = actionTakenDAO;
    }

    @Override
    public void deleteByDocumentId(String documentId) {
        this.actionTakenDAO.deleteByDocumentId(documentId);
    }

    @Override
    public void validateActionTaken(ActionTakenValue actionTaken) {
        LOG.debug((Object)"Enter validateActionTaken(..)");
        ArrayList<WorkflowServiceErrorImpl> errors = new ArrayList<WorkflowServiceErrorImpl>();
        String documentId = actionTaken.getDocumentId();
        if (documentId == null) {
            errors.add(new WorkflowServiceErrorImpl("ActionTaken documentid null.", "actiontaken.documentid.empty", actionTaken.getActionTakenId().toString()));
        } else if (this.getRouteHeaderService().getRouteHeader(documentId) == null) {
            errors.add(new WorkflowServiceErrorImpl("ActionTaken documentid invalid.", "actiontaken.documentid.invalid", actionTaken.getActionTakenId().toString()));
        }
        String principalId = actionTaken.getPrincipalId();
        if (StringUtils.isBlank((String)principalId)) {
            errors.add(new WorkflowServiceErrorImpl("ActionTaken personid null.", "actiontaken.personid.empty", actionTaken.getActionTakenId().toString()));
        } else {
            Principal principal = KimApiServiceLocator.getIdentityService().getPrincipal(principalId);
            if (principal == null) {
                errors.add(new WorkflowServiceErrorImpl("ActionTaken personid invalid.", "actiontaken.personid.invalid", actionTaken.getActionTakenId().toString()));
            }
        }
        String actionTakenCd = actionTaken.getActionTaken();
        if (actionTakenCd == null || actionTakenCd.trim().equals("")) {
            errors.add(new WorkflowServiceErrorImpl("ActionTaken cd null.", "actiontaken.actiontaken.empty", actionTaken.getActionTakenId().toString()));
        } else if (!KewApiConstants.ACTION_TAKEN_CD.containsKey(actionTakenCd)) {
            errors.add(new WorkflowServiceErrorImpl("ActionTaken invalid.", "actiontaken.actiontaken.invalid", actionTaken.getActionTakenId().toString()));
        }
        if (actionTaken.getActionDate() == null) {
            errors.add(new WorkflowServiceErrorImpl("ActionTaken actiondate null.", "actiontaken.actiondate.empty", actionTaken.getActionTakenId().toString()));
        }
        if (actionTaken.getDocVersion() == null) {
            errors.add(new WorkflowServiceErrorImpl("ActionTaken docversion null.", "actiontaken.docverion.empty", actionTaken.getActionTakenId().toString()));
        }
        LOG.debug((Object)"Exit validateActionRequest(..) ");
        if (!errors.isEmpty()) {
            throw new WorkflowServiceErrorException("ActionRequest Validation Error", errors);
        }
    }

    @Override
    public boolean hasUserTakenAction(String principalId, String documentId) {
        return this.getActionTakenDAO().hasUserTakenAction(principalId, documentId);
    }

    private RouteHeaderService getRouteHeaderService() {
        return (RouteHeaderService)KEWServiceLocator.getService("enDocumentRouteHeaderService");
    }

    @Override
    public Timestamp getLastApprovedDate(String documentId) {
        return this.getActionTakenDAO().getLastActionTakenDate(documentId, ActionType.APPROVE);
    }
}

