/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.docsearch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchResults;
import org.kuali.rice.kew.docsearch.DocumentSearchCustomizationMediator;
import org.kuali.rice.kew.doctype.DocumentTypeAttributeBo;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.framework.KewFrameworkServiceLocator;
import org.kuali.rice.kew.framework.document.search.AttributeFields;
import org.kuali.rice.kew.framework.document.search.DocumentSearchCriteriaConfiguration;
import org.kuali.rice.kew.framework.document.search.DocumentSearchCustomization;
import org.kuali.rice.kew.framework.document.search.DocumentSearchCustomizationHandlerService;
import org.kuali.rice.kew.framework.document.search.DocumentSearchResultSetConfiguration;
import org.kuali.rice.kew.framework.document.search.DocumentSearchResultValues;
import org.kuali.rice.kew.rule.bo.RuleAttribute;

public class DocumentSearchCustomizationMediatorImpl
implements DocumentSearchCustomizationMediator {
    @Override
    public DocumentSearchCriteriaConfiguration getDocumentSearchCriteriaConfiguration(DocumentType documentType) {
        List<DocumentTypeAttributeBo> searchableAttributes = documentType.getSearchableAttributes();
        LinkedHashMap applicationIdToAttributeNameMap = new LinkedHashMap();
        LinkedHashMap<String, AttributeFields> orderedSearchFieldMap = new LinkedHashMap<String, AttributeFields>();
        LinkedHashMap orderedResultSetFieldMap = new LinkedHashMap();
        for (DocumentTypeAttributeBo searchableAttribute : searchableAttributes) {
            RuleAttribute ruleAttribute = searchableAttribute.getRuleAttribute();
            String attributeName = ruleAttribute.getName();
            String applicationId = ruleAttribute.getApplicationId();
            if (!applicationIdToAttributeNameMap.containsKey(applicationId)) {
                applicationIdToAttributeNameMap.put(applicationId, new ArrayList());
            }
            ((List)applicationIdToAttributeNameMap.get(applicationId)).add(attributeName);
            orderedSearchFieldMap.put(attributeName, null);
        }
        for (String applicationId : applicationIdToAttributeNameMap.keySet()) {
            DocumentSearchCustomizationHandlerService documentSearchCustomizationService = this.loadCustomizationService(applicationId);
            List searchableAttributeNames = (List)applicationIdToAttributeNameMap.get(applicationId);
            DocumentSearchCriteriaConfiguration documentSearchConfiguration = documentSearchCustomizationService.getDocumentSearchConfiguration(documentType.getName(), searchableAttributeNames);
            this.mergeAttributeFields(documentSearchConfiguration.getSearchAttributeFields(), orderedSearchFieldMap);
        }
        DocumentSearchCriteriaConfiguration.Builder configBuilder = DocumentSearchCriteriaConfiguration.Builder.create();
        configBuilder.setSearchAttributeFields(this.flattenOrderedFieldMap(orderedSearchFieldMap));
        return configBuilder.build();
    }

    @Override
    public List<RemotableAttributeError> validateLookupFieldParameters(DocumentType documentType, DocumentSearchCriteria documentSearchCriteria) {
        List<DocumentTypeAttributeBo> searchableAttributes = documentType.getSearchableAttributes();
        LinkedHashMap applicationIdToAttributeNameMap = new LinkedHashMap();
        for (DocumentTypeAttributeBo searchableAttribute : searchableAttributes) {
            RuleAttribute ruleAttribute = searchableAttribute.getRuleAttribute();
            String attributeName = ruleAttribute.getName();
            String applicationId = ruleAttribute.getApplicationId();
            if (!applicationIdToAttributeNameMap.containsKey(applicationId)) {
                applicationIdToAttributeNameMap.put(applicationId, new ArrayList());
            }
            ((List)applicationIdToAttributeNameMap.get(applicationId)).add(attributeName);
        }
        ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>();
        for (String applicationId : applicationIdToAttributeNameMap.keySet()) {
            List searchableAttributeNames;
            DocumentSearchCustomizationHandlerService documentSearchCustomizationService = this.loadCustomizationService(applicationId);
            List searchErrors = documentSearchCustomizationService.validateCriteria(documentSearchCriteria, searchableAttributeNames = (List)applicationIdToAttributeNameMap.get(applicationId));
            if (CollectionUtils.isEmpty((Collection)searchErrors)) continue;
            errors.addAll(searchErrors);
        }
        return errors;
    }

    @Override
    public DocumentSearchCriteria customizeCriteria(DocumentType documentType, DocumentSearchCriteria documentSearchCriteria) {
        DocumentSearchCriteria customizedCriteria;
        DocumentSearchCustomizationHandlerService service;
        DocumentTypeAttributeBo customizerAttribute = documentType.getCustomizerAttribute();
        if (customizerAttribute != null && (service = this.loadCustomizationService(customizerAttribute.getRuleAttribute().getApplicationId())).getEnabledCustomizations(documentType.getName(), customizerAttribute.getRuleAttribute().getName()).contains(DocumentSearchCustomization.CRITERIA) && (customizedCriteria = service.customizeCriteria(documentSearchCriteria, customizerAttribute.getRuleAttribute().getName())) != null) {
            return customizedCriteria;
        }
        return null;
    }

    @Override
    public DocumentSearchCriteria customizeClearCriteria(DocumentType documentType, DocumentSearchCriteria documentSearchCriteria) {
        DocumentSearchCriteria customizedCriteria;
        DocumentSearchCustomizationHandlerService service;
        DocumentTypeAttributeBo customizerAttribute = documentType.getCustomizerAttribute();
        if (customizerAttribute != null && (service = this.loadCustomizationService(customizerAttribute.getRuleAttribute().getApplicationId())).getEnabledCustomizations(documentType.getName(), customizerAttribute.getRuleAttribute().getName()).contains(DocumentSearchCustomization.CLEAR_CRITERIA) && (customizedCriteria = service.customizeClearCriteria(documentSearchCriteria, customizerAttribute.getRuleAttribute().getName())) != null) {
            return customizedCriteria;
        }
        return null;
    }

    @Override
    public DocumentSearchResultValues customizeResults(DocumentType documentType, DocumentSearchCriteria documentSearchCriteria, DocumentSearchResults results) {
        DocumentSearchResultValues customizedResults;
        DocumentSearchCustomizationHandlerService service;
        DocumentTypeAttributeBo customizerAttribute = documentType.getCustomizerAttribute();
        if (customizerAttribute != null && (service = this.loadCustomizationService(customizerAttribute.getRuleAttribute().getApplicationId())).getEnabledCustomizations(documentType.getName(), customizerAttribute.getRuleAttribute().getName()).contains(DocumentSearchCustomization.RESULTS) && (customizedResults = service.customizeResults(documentSearchCriteria, results.getSearchResults(), customizerAttribute.getRuleAttribute().getName())) != null) {
            return customizedResults;
        }
        return null;
    }

    @Override
    public DocumentSearchResultSetConfiguration customizeResultSetConfiguration(DocumentType documentType, DocumentSearchCriteria documentSearchCriteria) {
        DocumentSearchResultSetConfiguration resultSetConfiguration;
        DocumentSearchCustomizationHandlerService service;
        DocumentTypeAttributeBo customizerAttribute = documentType.getCustomizerAttribute();
        if (customizerAttribute != null && (service = this.loadCustomizationService(customizerAttribute.getRuleAttribute().getApplicationId())).getEnabledCustomizations(documentType.getName(), customizerAttribute.getRuleAttribute().getName()).contains(DocumentSearchCustomization.RESULT_SET_FIELDS) && (resultSetConfiguration = service.customizeResultSetConfiguration(documentSearchCriteria, customizerAttribute.getRuleAttribute().getName())) != null) {
            return resultSetConfiguration;
        }
        return null;
    }

    protected DocumentSearchCustomizationHandlerService loadCustomizationService(String applicationId) {
        DocumentSearchCustomizationHandlerService service = KewFrameworkServiceLocator.getDocumentSearchCustomizationHandlerService((String)applicationId);
        if (service == null) {
            throw new WorkflowRuntimeException("Failed to locate DocumentSearchCustomizationService for applicationId: " + applicationId);
        }
        return service;
    }

    protected void mergeAttributeFields(List<AttributeFields> attributeFieldsList, LinkedHashMap<String, AttributeFields> orderedFieldMap) {
        if (attributeFieldsList == null) {
            return;
        }
        for (AttributeFields attributeFields : attributeFieldsList) {
            orderedFieldMap.put(attributeFields.getAttributeName(), attributeFields);
        }
    }

    protected List<AttributeFields> flattenOrderedFieldMap(LinkedHashMap<String, AttributeFields> orderedFieldMap) {
        return new ArrayList<AttributeFields>(orderedFieldMap.values());
    }
}

