/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.doctype;

import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.kuali.rice.kew.doctype.DocumentTypePolicyId;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;

@Entity
@Table(name="KREW_DOC_TYP_PLCY_RELN_T")
public class DocumentTypePolicy
extends PersistableBusinessObjectBase {
    private static final long serialVersionUID = -4612246888683336474L;
    @EmbeddedId
    private DocumentTypePolicyId documentTypePolicyId;
    @Column(name="PLCY_NM")
    private Boolean policyValue;
    @Column(name="PLCY_VAL")
    private String policyStringValue;
    @Transient
    private Boolean inheritedFlag;
    @MapsId(value="documentTypeId")
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="DOC_TYP_ID")
    private DocumentType documentType;
    @Transient
    private String documentTypeId;
    @Transient
    private String policyName;

    public DocumentTypePolicy() {
    }

    public DocumentTypePolicy(String policyName, Boolean policyValue) {
        this.policyName = policyName;
        this.getDocumentTypePolicyId().setPolicyName(policyName);
        this.policyValue = policyValue;
    }

    public DocumentTypePolicyId getDocumentTypePolicyId() {
        if (this.documentTypePolicyId == null) {
            this.documentTypePolicyId = new DocumentTypePolicyId();
        }
        return this.documentTypePolicyId;
    }

    public void setDocumentTypePolicyId(DocumentTypePolicyId documentTypePolicyId) {
        this.documentTypePolicyId = documentTypePolicyId;
    }

    public String getPolicyDisplayValue() {
        if (this.policyValue != null) {
            if (this.policyValue.booleanValue()) {
                return "Active";
            }
            return "Inactive";
        }
        return "Inherited";
    }

    public Boolean getInheritedFlag() {
        return this.inheritedFlag;
    }

    public void setInheritedFlag(Boolean inheritedFlag) {
        this.inheritedFlag = inheritedFlag;
    }

    public boolean isAllowUnrequestedAction() {
        return org.kuali.rice.kew.api.doctype.DocumentTypePolicy.ALLOW_UNREQUESTED_ACTION.equals((Object)this.getPolicyName());
    }

    public boolean isDefaultApprove() {
        return org.kuali.rice.kew.api.doctype.DocumentTypePolicy.DEFAULT_APPROVE.equals((Object)this.getPolicyName());
    }

    public boolean isDisApprove() {
        return org.kuali.rice.kew.api.doctype.DocumentTypePolicy.DISAPPROVE.getCode().equals(this.getPolicyName());
    }

    public String getDocumentTypeId() {
        return this.getDocumentTypePolicyId().getDocumentTypeId() != null ? this.getDocumentTypePolicyId().getDocumentTypeId() : this.documentTypeId;
    }

    public void setDocumentTypeId(String documentTypeId) {
        this.documentTypeId = documentTypeId;
        this.getDocumentTypePolicyId().setDocumentTypeId(documentTypeId);
    }

    public String getPolicyName() {
        return this.getDocumentTypePolicyId().getPolicyName() != null ? this.getDocumentTypePolicyId().getPolicyName() : this.policyName;
    }

    public void setPolicyName(String policyName) {
        org.kuali.rice.kew.api.doctype.DocumentTypePolicy policy = org.kuali.rice.kew.api.doctype.DocumentTypePolicy.fromCode((String)policyName);
        this.policyName = policy.getCode();
        this.getDocumentTypePolicyId().setPolicyName(policy.getCode());
    }

    public Boolean getPolicyValue() {
        return this.policyValue;
    }

    public void setPolicyValue(Boolean policyValue) {
        this.policyValue = policyValue;
    }

    public String getPolicyStringValue() {
        return this.policyStringValue;
    }

    public void setPolicyStringValue(String policyStringValue) {
        this.policyStringValue = policyStringValue;
    }

    public Object copy(boolean preserveKeys) {
        DocumentTypePolicy clone = new DocumentTypePolicy();
        if (preserveKeys && this.getDocumentTypeId() != null) {
            clone.setDocumentTypeId(this.getDocumentTypeId());
        }
        if (this.getPolicyName() != null) {
            clone.setPolicyName(new String(this.getPolicyName()));
        }
        if (this.policyValue != null) {
            clone.setPolicyValue(new Boolean(this.policyValue));
        }
        if (this.policyStringValue != null) {
            clone.setPolicyStringValue(new String(this.policyStringValue));
        }
        return clone;
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(DocumentType documentType) {
        this.documentType = documentType;
    }
}

