/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.documentlink.dao.impl;

import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.core.framework.persistence.jpa.criteria.Criteria;
import org.kuali.rice.core.framework.persistence.jpa.criteria.QueryByCriteria;
import org.kuali.rice.kew.documentlink.DocumentLink;
import org.kuali.rice.kew.documentlink.dao.DocumentLinkDAO;
import org.kuali.rice.kew.documentlink.dao.impl.DocumentLinkDaoUtil;
import org.kuali.rice.krad.util.ObjectUtils;

public class DocumentLinkDAOJpaImpl
implements DocumentLinkDAO {
    @PersistenceContext(unitName="kew-unit")
    private EntityManager entityManager;

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void deleteDocmentLinksByDocId(String docId) {
        List<DocumentLink> links = this.getLinkedDocumentsByDocId(docId);
        for (DocumentLink link : links) {
            this.deleteDocumentLink(link);
        }
    }

    @Override
    public void deleteDocumentLink(DocumentLink link) {
        this.deleteSingleLinkFromOrgnDoc(link);
        this.deleteSingleLinkFromOrgnDoc(DocumentLinkDaoUtil.reverseLink((DocumentLink)ObjectUtils.deepCopy((Serializable)link)));
    }

    @Override
    public DocumentLink getLinkedDocument(DocumentLink link) {
        Criteria crit = new Criteria(DocumentLink.class.getName());
        crit.eq("orgnDocId", (Object)link.getOrgnDocId());
        crit.eq("destDocId", (Object)link.getDestDocId());
        try {
            return (DocumentLink)new QueryByCriteria(this.entityManager, crit).toQuery().getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public List<DocumentLink> getLinkedDocumentsByDocId(String docId) {
        Criteria crit = new Criteria(DocumentLink.class.getName());
        crit.eq("orgnDocId", (Object)docId);
        return new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
    }

    @Override
    public List<DocumentLink> getOutgoingLinkedDocumentsByDocId(String docId) {
        Criteria crit = new Criteria(DocumentLink.class.getName());
        crit.eq("destDocId", (Object)docId);
        return new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
    }

    @Override
    public void saveDocumentLink(DocumentLink link) {
        DocumentLink linkedDocument = this.getLinkedDocument(link);
        if (linkedDocument == null) {
            if (link.getDocLinkId() == null) {
                this.entityManager.persist((Object)link);
            } else {
                OrmUtils.merge((EntityManager)this.entityManager, (Object)link);
            }
        } else {
            link.setDocLinkId(linkedDocument.getDocLinkId());
        }
        DocumentLink rLink = DocumentLinkDaoUtil.reverseLink((DocumentLink)ObjectUtils.deepCopy((Serializable)link));
        if (this.getLinkedDocument(rLink) == null) {
            if (link.getDocLinkId() == null) {
                this.entityManager.persist((Object)rLink);
            } else {
                OrmUtils.merge((EntityManager)this.entityManager, (Object)rLink);
            }
        }
    }

    private void deleteSingleLinkFromOrgnDoc(DocumentLink link) {
        DocumentLink cur = this.getLinkedDocument(link);
        this.entityManager.remove((Object)cur);
    }

    @Override
    public DocumentLink getDocumentLink(Long documentLinkId) {
        Criteria crit = new Criteria(DocumentLink.class.getName());
        crit.eq("docLinkId", (Object)documentLinkId);
        return (DocumentLink)new QueryByCriteria(this.entityManager, crit).toQuery().getSingleResult();
    }
}

