/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.documentlink.dao.impl;

import java.util.List;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.kuali.rice.kew.documentlink.DocumentLink;
import org.kuali.rice.kew.documentlink.dao.DocumentLinkDAO;
import org.kuali.rice.kew.documentlink.dao.impl.DocumentLinkDaoUtil;
import org.springmodules.orm.ojb.support.PersistenceBrokerDaoSupport;

public class DocumentLinkDAOOjbImpl
extends PersistenceBrokerDaoSupport
implements DocumentLinkDAO {
    @Override
    public void saveDocumentLink(DocumentLink link) {
        DocumentLink linkedDocument = this.getLinkedDocument(link);
        if (linkedDocument == null) {
            this.getPersistenceBrokerTemplate().store((Object)link);
        } else {
            link.setDocLinkId(linkedDocument.getDocLinkId());
        }
        DocumentLink rLink = DocumentLinkDaoUtil.reverseLink(link);
        if (this.getLinkedDocument(rLink) == null) {
            this.getPersistenceBrokerTemplate().store((Object)rLink);
        }
    }

    @Override
    public void deleteDocumentLink(DocumentLink link) {
        this.deleteSingleLinkFromOrgnDoc(link);
        this.deleteSingleLinkFromOrgnDoc(DocumentLinkDaoUtil.reverseLink(link));
    }

    @Override
    public void deleteDocmentLinksByDocId(String docId) {
        List<DocumentLink> links = this.getLinkedDocumentsByDocId(docId);
        for (DocumentLink link : links) {
            this.deleteDocumentLink(link);
        }
    }

    @Override
    public List<DocumentLink> getLinkedDocumentsByDocId(String docId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("orgnDocId", (Object)docId);
        QueryByCriteria query = new QueryByCriteria(DocumentLink.class, crit);
        query.addOrderByAscending("orgnDocId");
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    @Override
    public List<DocumentLink> getOutgoingLinkedDocumentsByDocId(String docId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("destDocId", (Object)docId);
        QueryByCriteria query = new QueryByCriteria(DocumentLink.class, crit);
        query.addOrderByAscending("destDocId");
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    @Override
    public DocumentLink getLinkedDocument(DocumentLink link) {
        Criteria crit = new Criteria();
        crit.addEqualTo("orgnDocId", (Object)link.getOrgnDocId());
        crit.addEqualTo("destDocId", (Object)link.getDestDocId());
        QueryByCriteria query = new QueryByCriteria(DocumentLink.class, crit);
        query.addOrderByAscending("orgnDocId");
        return (DocumentLink)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
    }

    private void deleteSingleLinkFromOrgnDoc(DocumentLink link) {
        Criteria crit = new Criteria();
        crit.addEqualTo("orgnDocId", (Object)link.getOrgnDocId());
        crit.addEqualTo("destDocId", (Object)link.getDestDocId());
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)new QueryByCriteria(DocumentLink.class, crit));
    }

    public void deleteSingleLinksByOrgnDocId(String docId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("orgnDocId", (Object)docId);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)new QueryByCriteria(DocumentLink.class, crit));
    }

    @Override
    public DocumentLink getDocumentLink(Long documentLinkId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("docLinkId", (Object)documentLinkId);
        return (DocumentLink)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(DocumentLink.class, crit));
    }
}

