/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.kuali.rice.core.framework.util.ApplicationThreadLocal;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.engine.ActivationContext;
import org.kuali.rice.kew.engine.EngineState;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.routeheader.DocumentContent;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.StandardDocumentContent;

public class RouteContext
implements Serializable {
    private static final long serialVersionUID = -7125137491367944594L;
    private DocumentRouteHeaderValue routeHeader;
    private DocumentContent documentContent;
    private RouteNodeInstance nodeInstance;
    private EngineState engineState;
    private ActionRequestValue actionRequest;
    private ActivationContext activationContext = new ActivationContext(false);
    private boolean doNotSendApproveNotificationEmails = false;
    private Map parameters = new HashMap();
    private boolean searchIndexingRequestedForContext = false;
    private static ThreadLocal<List<RouteContext>> ROUTE_CONTEXT_STACK = new ApplicationThreadLocal<List<RouteContext>>(){

        protected List<RouteContext> initialValue() {
            LinkedList<RouteContext> contextStack = new LinkedList<RouteContext>();
            contextStack.add(0, new RouteContext());
            return contextStack;
        }
    };

    public static RouteContext getCurrentRouteContext() {
        return ROUTE_CONTEXT_STACK.get().get(0);
    }

    public static void clearCurrentRouteContext() {
        ROUTE_CONTEXT_STACK.get().remove(0);
        ROUTE_CONTEXT_STACK.get().add(0, new RouteContext());
    }

    public static RouteContext createNewRouteContext() {
        ROUTE_CONTEXT_STACK.get().add(0, new RouteContext());
        return RouteContext.getCurrentRouteContext();
    }

    public static RouteContext releaseCurrentRouteContext() {
        return ROUTE_CONTEXT_STACK.get().remove(0);
    }

    public DocumentRouteHeaderValue getRouteHeader() {
        return this.routeHeader;
    }

    public void setRouteHeader(DocumentRouteHeaderValue routeHeader) {
        this.routeHeader = routeHeader;
    }

    public DocumentRouteHeaderValue getDocument() {
        return this.routeHeader;
    }

    public void setDocument(DocumentRouteHeaderValue routeHeader) {
        this.routeHeader = routeHeader;
        try {
            this.setDocumentContent(new StandardDocumentContent(routeHeader.getDocContent(), this));
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
    }

    public DocumentContent getDocumentContent() {
        return this.documentContent;
    }

    public void setDocumentContent(DocumentContent documentContent) {
        this.documentContent = documentContent;
    }

    public RouteNodeInstance getNodeInstance() {
        return this.nodeInstance;
    }

    public void setNodeInstance(RouteNodeInstance nodeInstance) {
        this.nodeInstance = nodeInstance;
    }

    public EngineState getEngineState() {
        return this.engineState;
    }

    public void setEngineState(EngineState engineState) {
        this.engineState = engineState;
    }

    public ActionRequestValue getActionRequest() {
        return this.actionRequest;
    }

    public void setActionRequest(ActionRequestValue actionRequest) {
        this.actionRequest = actionRequest;
    }

    public boolean isSimulation() {
        if (this.activationContext == null) {
            return false;
        }
        return this.activationContext.isSimulation();
    }

    public ActivationContext getActivationContext() {
        return this.activationContext;
    }

    public void setActivationContext(ActivationContext activationContext) {
        this.activationContext = activationContext;
    }

    public boolean isDoNotSendApproveNotificationEmails() {
        return this.doNotSendApproveNotificationEmails;
    }

    public void setDoNotSendApproveNotificationEmails(boolean sendNotificationEmails) {
        this.doNotSendApproveNotificationEmails = sendNotificationEmails;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }

    public boolean isSearchIndexingRequestedForContext() {
        return this.searchIndexingRequestedForContext;
    }

    public void requestSearchIndexingForContext() {
        this.searchIndexingRequestedForContext = true;
    }
}

