/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.Branch;
import org.kuali.rice.kew.engine.node.JoinEngine;
import org.kuali.rice.kew.engine.node.NodeState;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.service.KEWServiceLocator;

public class BasicJoinEngine
implements JoinEngine {
    public static final String EXPECTED_JOINERS = "ExpectedJoiners";
    public static final String ACTUAL_JOINERS = "ActualJoiners";

    @Override
    public void createExpectedJoinState(RouteContext context, RouteNodeInstance joinInstance, RouteNodeInstance previousNodeInstance) {
        RouteNodeInstance splitNode = previousNodeInstance.getBranch().getSplitNode();
        if (splitNode == null) {
            throw new WorkflowRuntimeException("The split node retrieved from node with name '" + previousNodeInstance.getName() + "' and branch with name '" + previousNodeInstance.getBranch().getName() + "' was null");
        }
        for (RouteNodeInstance splitNodeNextNode : splitNode.getNextNodeInstances()) {
            this.saveNode(context, joinInstance);
            splitNodeNextNode.getBranch().setJoinNode(joinInstance);
            if (!OrmUtils.isJpaEnabled((String)"rice.kew")) {
                this.saveBranch(context, splitNodeNextNode.getBranch());
            }
            this.addExpectedJoiner(joinInstance, splitNodeNextNode.getBranch());
        }
        joinInstance.setBranch(splitNode.getBranch());
        joinInstance.setProcess(splitNode.getProcess());
    }

    @Override
    public void addExpectedJoiner(RouteNodeInstance nodeInstance, Branch branch) {
        this.addJoinState(nodeInstance, branch, EXPECTED_JOINERS);
    }

    @Override
    public void addActualJoiner(RouteNodeInstance nodeInstance, Branch branch) {
        this.addJoinState(nodeInstance, branch, ACTUAL_JOINERS);
    }

    private void addJoinState(RouteNodeInstance nodeInstance, Branch branch, String key) {
        NodeState state = nodeInstance.getNodeState(key);
        if (state == null) {
            state = new NodeState();
            state.setKey(key);
            state.setValue("");
            state.setNodeInstance(nodeInstance);
            nodeInstance.addNodeState(state);
        }
        state.setValue(state.getValue() + branch.getBranchId() + ",");
    }

    @Override
    public boolean isJoined(RouteNodeInstance nodeInstance) {
        NodeState expectedState = nodeInstance.getNodeState(EXPECTED_JOINERS);
        if (expectedState == null || StringUtils.isEmpty((String)expectedState.getValue())) {
            return true;
        }
        NodeState actualState = nodeInstance.getNodeState(ACTUAL_JOINERS);
        Set expectedSet = this.loadIntoSet(expectedState);
        Set actualSet = this.loadIntoSet(actualState);
        Iterator iterator = expectedSet.iterator();
        while (iterator.hasNext()) {
            String value = (String)iterator.next();
            if (!actualSet.contains(value)) continue;
            iterator.remove();
        }
        return expectedSet.size() == 0;
    }

    private Set loadIntoSet(NodeState state) {
        HashSet<String> set = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(state.getValue(), ",");
        while (tokenizer.hasMoreTokens()) {
            set.add(tokenizer.nextToken());
        }
        return set;
    }

    private void saveBranch(RouteContext context, Branch branch) {
        if (!context.isSimulation()) {
            KEWServiceLocator.getRouteNodeService().save(branch);
        }
    }

    private void saveNode(RouteContext context, RouteNodeInstance nodeInstance) {
        if (!context.isSimulation()) {
            KEWServiceLocator.getRouteNodeService().save(nodeInstance);
        } else {
            for (RouteNodeInstance routeNodeInstance : nodeInstance.getNextNodeInstances()) {
                if (routeNodeInstance.getRouteNodeInstanceId() != null) continue;
                routeNodeInstance.setRouteNodeInstanceId(context.getEngineState().getNextSimulationId());
            }
            if (nodeInstance.getProcess() != null && nodeInstance.getProcess().getRouteNodeInstanceId() == null) {
                nodeInstance.getProcess().setRouteNodeInstanceId(context.getEngineState().getNextSimulationId());
            }
            if (nodeInstance.getBranch() != null && nodeInstance.getBranch().getBranchId() == null) {
                nodeInstance.getBranch().setBranchId(context.getEngineState().getNextSimulationId());
            }
        }
    }
}

