/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.RequestActivationNode;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.node.SimpleResult;
import org.kuali.rice.kew.exception.RouteManagerException;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routemodule.RouteModule;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.util.ClassDumper;

public class RequestsNode
extends RequestActivationNode {
    private static final Logger LOG = Logger.getLogger(RequestsNode.class);
    protected static final String SUPPRESS_POLICY_ERRORS_KEY = "_suppressPolicyErrorsRequestActivationNode";

    @Override
    public final SimpleResult process(RouteContext routeContext, RouteHelper routeHelper) throws Exception {
        try {
            SimpleResult simpleResult;
            if (this.processCustom(routeContext, routeHelper)) {
                return super.process(routeContext, routeHelper);
            }
            RouteNodeInstance nodeInstance = routeContext.getNodeInstance();
            boolean isInitial = nodeInstance.isInitial();
            int currentIteration = 0;
            List<Object> requestsGenerated = new ArrayList();
            while (true) {
                this.detectRunawayProcess(routeContext, currentIteration++);
                if (isInitial) {
                    requestsGenerated = this.generateRequests(routeContext);
                    isInitial = false;
                }
                if (!(simpleResult = super.process(routeContext, routeHelper)).isComplete()) break;
                RouteModule routeModule = this.getRouteModule(routeContext);
                boolean moreRequestsAvailable = routeModule.isMoreRequestsAvailable(routeContext);
                if (!moreRequestsAvailable) {
                    this.applyPoliciesOnExit(requestsGenerated, routeContext);
                    return simpleResult;
                }
                requestsGenerated = this.generateRequests(routeContext);
            }
            return simpleResult;
        }
        catch (RouteManagerException ex) {
            throw ex;
        }
        catch (Exception e) {
            LOG.error((Object)"Caught exception routing", (Throwable)e);
            throw new RouteManagerException(e.getMessage(), e, routeContext);
        }
    }

    protected List<ActionRequestValue> generateRequests(RouteContext routeContext) throws Exception {
        DocumentRouteHeaderValue document = routeContext.getDocument();
        RouteNodeInstance nodeInstance = routeContext.getNodeInstance();
        RouteNode node = nodeInstance.getRouteNode();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RouteHeader info inside routing loop\n" + ClassDumper.dumpFields(document)));
            LOG.debug((Object)("Looking for new actionRequests - routeLevel: " + node.getRouteNodeName()));
        }
        boolean suppressPolicyErrors = RequestsNode.isSuppressingPolicyErrors(routeContext);
        List<ActionRequestValue> requests = this.getNewActionRequests(routeContext);
        if (!suppressPolicyErrors) {
            this.verifyFinalApprovalRequest(document, requests, nodeInstance, routeContext);
        }
        return requests;
    }

    protected void applyPoliciesOnExit(List<ActionRequestValue> requestsGenerated, RouteContext routeContext) {
        List<ActionRequestValue> actionRequests;
        DocumentRouteHeaderValue document = routeContext.getDocument();
        RouteNodeInstance nodeInstance = routeContext.getNodeInstance();
        RouteNode node = nodeInstance.getRouteNode();
        if (node.isMandatory() && !RequestsNode.isSuppressingPolicyErrors(routeContext) && CollectionUtils.isEmpty(requestsGenerated) && (actionRequests = KEWServiceLocator.getActionRequestService().findRootRequestsByDocIdAtRouteNode(document.getDocumentId(), nodeInstance.getRouteNodeInstanceId())).isEmpty()) {
            LOG.warn((Object)("no requests generated for mandatory route - " + node.getRouteNodeName()));
            throw new RouteManagerException("No requests generated for mandatory route " + node.getRouteNodeName() + ":" + node.getRouteMethodName(), routeContext);
        }
    }

    protected boolean processCustom(RouteContext routeContext, RouteHelper routeHelper) throws Exception {
        return false;
    }

    protected void verifyFinalApprovalRequest(DocumentRouteHeaderValue document, List<ActionRequestValue> requests, RouteNodeInstance nodeInstance, RouteContext routeContext) throws RouteManagerException {
        boolean pastFinalApprover = this.isPastFinalApprover(document, nodeInstance);
        boolean hasApproveRequest = false;
        for (ActionRequestValue actionRequest : requests) {
            if (!actionRequest.isApproveOrCompleteRequest()) continue;
            hasApproveRequest = true;
            break;
        }
        if (nodeInstance.getRouteNode().getFinalApprovalInd().booleanValue()) {
            if (!hasApproveRequest) {
                throw new RouteManagerException("No Approve Request generated after final approver", routeContext);
            }
        } else if (pastFinalApprover && hasApproveRequest) {
            throw new RouteManagerException("Approve Request generated after final approver", routeContext);
        }
    }

    public List<ActionRequestValue> getNewActionRequests(RouteContext context) throws Exception {
        RouteNodeInstance nodeInstance = context.getNodeInstance();
        String routeMethodName = nodeInstance.getRouteNode().getRouteMethodName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Looking for action requests in " + routeMethodName + " : " + nodeInstance.getRouteNode().getRouteNodeName()));
        }
        ArrayList<ActionRequestValue> newRequests = new ArrayList<ActionRequestValue>();
        try {
            RouteModule routeModule = this.getRouteModule(context);
            List<ActionRequestValue> requests = routeModule.findActionRequests(context);
            for (ActionRequestValue actionRequest : requests) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Request generated by RouteModule '" + routeModule + "' for node " + nodeInstance + ":" + actionRequest));
                }
                actionRequest = KEWServiceLocator.getActionRequestService().initializeActionRequestGraph(actionRequest, context.getDocument(), nodeInstance);
                this.saveActionRequest(context, actionRequest);
                newRequests.add(actionRequest);
            }
        }
        catch (WorkflowException ex) {
            LOG.warn((Object)"Caught WorkflowException during routing", (Throwable)ex);
            throw new RouteManagerException(ex, context);
        }
        return newRequests;
    }

    protected RouteModule getRouteModule(RouteContext context) throws Exception {
        return KEWServiceLocator.getRouteModuleService().findRouteModule(context.getNodeInstance().getRouteNode());
    }

    protected boolean isPastFinalApprover(DocumentRouteHeaderValue document, RouteNodeInstance nodeInstance) {
        FinalApproverContext context = new FinalApproverContext();
        List revokedNodeInstances = KEWServiceLocator.getRouteNodeService().getRevokedNodeInstances(document);
        HashSet<String> revokedNodeInstanceIds = new HashSet<String>();
        for (RouteNodeInstance revokedNodeInstance : revokedNodeInstances) {
            revokedNodeInstanceIds.add(revokedNodeInstance.getRouteNodeInstanceId());
        }
        this.isPastFinalApprover(nodeInstance.getPreviousNodeInstances(), context, revokedNodeInstanceIds);
        return context.isPast;
    }

    protected void isPastFinalApprover(List previousNodeInstances, FinalApproverContext context, Set revokedNodeInstanceIds) {
        if (previousNodeInstances != null && !previousNodeInstances.isEmpty()) {
            Iterator iterator = previousNodeInstances.iterator();
            while (iterator.hasNext()) {
                if (context.isPast) {
                    return;
                }
                RouteNodeInstance nodeInstance = (RouteNodeInstance)iterator.next();
                if (context.inspected.contains(this.getKey(nodeInstance))) continue;
                context.inspected.add(this.getKey(nodeInstance));
                if (Boolean.TRUE.equals(nodeInstance.getRouteNode().getFinalApprovalInd())) {
                    if (!revokedNodeInstanceIds.contains(nodeInstance.getRouteNodeInstanceId())) {
                        context.isPast = true;
                    }
                    return;
                }
                this.isPastFinalApprover(nodeInstance.getPreviousNodeInstances(), context, revokedNodeInstanceIds);
            }
        }
    }

    protected Object getKey(RouteNodeInstance nodeInstance) {
        String id = nodeInstance.getRouteNodeInstanceId();
        return id != null ? id : nodeInstance;
    }

    protected void detectRunawayProcess(RouteContext routeContext, int currentIteration) throws NumberFormatException {
        int maxNodes;
        String maxNodesConstant = this.getParameterService().getParameterValueAsString("KR-WKFLW", "All", "MAXIMUM_NODES_BEFORE_RUNAWAY");
        int n = maxNodes = StringUtils.isEmpty((String)maxNodesConstant) ? 50 : Integer.valueOf(maxNodesConstant);
        if (currentIteration > maxNodes) {
            throw new RouteManagerException("Detected a runaway process within RequestsNode for document with id '" + routeContext.getDocument().getDocumentId() + "' after " + currentIteration + " iterations.");
        }
    }

    public static boolean isSuppressingPolicyErrors(RouteContext routeContext) {
        Boolean suppressPolicyErrors = (Boolean)routeContext.getParameters().get(SUPPRESS_POLICY_ERRORS_KEY);
        return suppressPolicyErrors != null && suppressPolicyErrors != false;
    }

    public static void setSuppressPolicyErrors(RouteContext routeContext) {
        routeContext.getParameters().put(SUPPRESS_POLICY_ERRORS_KEY, Boolean.TRUE);
    }

    protected ParameterService getParameterService() {
        return CoreFrameworkServiceLocator.getParameterService();
    }

    protected class FinalApproverContext {
        public Set inspected = new HashSet();
        public boolean isPast = false;

        protected FinalApproverContext() {
        }
    }
}

