/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Version;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.kew.api.document.node.RouteNodeInstance;
import org.kuali.rice.kew.api.document.node.RouteNodeInstanceContract;
import org.kuali.rice.kew.api.document.node.RouteNodeInstanceState;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.node.Branch;
import org.kuali.rice.kew.engine.node.NodeState;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;

@Entity
@Table(name="KREW_RTE_NODE_INSTN_T")
@NamedQueries(value={@NamedQuery(name="RouteNodeInstance.FindByRouteNodeInstanceId", query="select r from RouteNodeInstance r where r.routeNodeInstanceId = :routeNodeInstanceId"), @NamedQuery(name="RouteNodeInstance.FindActiveNodeInstances", query="select r from RouteNodeInstance r where r.documentId = :documentId and r.active = true"), @NamedQuery(name="RouteNodeInstance.FindTerminalNodeInstances", query="select r from RouteNodeInstance r where r.documentId = :documentId and r.active = false and r.complete = true"), @NamedQuery(name="RouteNodeInstance.FindInitialNodeInstances", query="select d.initialRouteNodeInstances from DocumentRouteHeaderValue d where d.documentId = :documentId"), @NamedQuery(name="RouteNodeInstance.FindProcessNodeInstances", query="select r from RouteNodeInstance r where r.process.routeNodeInstanceId = :processId"), @NamedQuery(name="RouteNodeInstance.FindRouteNodeInstances", query="select r from RouteNodeInstance r where r.documentId = :documentId")})
public class RouteNodeInstance
implements Serializable {
    private static final long serialVersionUID = 7183670062805580420L;
    @Id
    @GeneratedValue(generator="KREW_RTE_NODE_S")
    @GenericGenerator(name="KREW_RTE_NODE_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KREW_RTE_NODE_S"), @Parameter(name="value_column", value="id")})
    @Column(name="RTE_NODE_INSTN_ID")
    private String routeNodeInstanceId;
    @Column(name="DOC_HDR_ID")
    private String documentId;
    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="BRCH_ID")
    private Branch branch;
    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="RTE_NODE_ID")
    private RouteNode routeNode;
    @Column(name="ACTV_IND")
    private boolean active = false;
    @Column(name="CMPLT_IND")
    private boolean complete = false;
    @Column(name="INIT_IND")
    private boolean initial = true;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="PROC_RTE_NODE_INSTN_ID")
    private RouteNodeInstance process;
    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE})
    @JoinTable(name="KREW_RTE_NODE_INSTN_LNK_T", joinColumns={@JoinColumn(name="FROM_RTE_NODE_INSTN_ID")}, inverseJoinColumns={@JoinColumn(name="TO_RTE_NODE_INSTN_ID")})
    @Fetch(value=FetchMode.SELECT)
    private List<RouteNodeInstance> nextNodeInstances = new ArrayList<RouteNodeInstance>();
    @ManyToMany(fetch=FetchType.EAGER, mappedBy="nextNodeInstances")
    @Fetch(value=FetchMode.SELECT)
    private List<RouteNodeInstance> previousNodeInstances = new ArrayList<RouteNodeInstance>();
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.REMOVE, CascadeType.MERGE}, mappedBy="nodeInstance", orphanRemoval=true)
    @Fetch(value=FetchMode.SELECT)
    private List<NodeState> state = new ArrayList<NodeState>();
    @Version
    @Column(name="VER_NBR")
    private Integer lockVerNbr;
    private List<DocumentRouteHeaderValue> initialDocumentRouteHeaderValues = new ArrayList<DocumentRouteHeaderValue>();

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public Branch getBranch() {
        return this.branch;
    }

    public void setBranch(Branch branch) {
        this.branch = branch;
    }

    public RouteNode getRouteNode() {
        return this.routeNode;
    }

    public void setRouteNode(RouteNode node) {
        this.routeNode = node;
    }

    public String getRouteNodeInstanceId() {
        return this.routeNodeInstanceId;
    }

    public void setRouteNodeInstanceId(String routeNodeInstanceId) {
        this.routeNodeInstanceId = routeNodeInstanceId;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public List<RouteNodeInstance> getNextNodeInstances() {
        return this.nextNodeInstances;
    }

    public RouteNodeInstance getNextNodeInstance(int index) {
        while (this.getNextNodeInstances().size() <= index) {
            this.nextNodeInstances.add(new RouteNodeInstance());
        }
        return this.getNextNodeInstances().get(index);
    }

    public void setNextNodeInstances(List<RouteNodeInstance> nextNodeInstances) {
        this.nextNodeInstances = nextNodeInstances;
    }

    public List<RouteNodeInstance> getPreviousNodeInstances() {
        return this.previousNodeInstances;
    }

    public RouteNodeInstance getPreviousNodeInstance(int index) {
        while (this.previousNodeInstances.size() <= index) {
            this.previousNodeInstances.add(new RouteNodeInstance());
        }
        return this.getPreviousNodeInstances().get(index);
    }

    public void setPreviousNodeInstances(List<RouteNodeInstance> previousNodeInstances) {
        this.previousNodeInstances = previousNodeInstances;
    }

    public boolean isInitial() {
        return this.initial;
    }

    public void setInitial(boolean initial) {
        this.initial = initial;
    }

    public List<NodeState> getState() {
        return this.state;
    }

    public void setState(List<NodeState> state) {
        this.state.clear();
        this.state.addAll(state);
    }

    public RouteNodeInstance getProcess() {
        return this.process;
    }

    public void setProcess(RouteNodeInstance process) {
        this.process = process;
    }

    public Integer getLockVerNbr() {
        return this.lockVerNbr;
    }

    public void setLockVerNbr(Integer lockVerNbr) {
        this.lockVerNbr = lockVerNbr;
    }

    public NodeState getNodeState(String key) {
        for (NodeState nodeState : this.getState()) {
            if (!nodeState.getKey().equals(key)) continue;
            return nodeState;
        }
        return null;
    }

    public void addNodeState(NodeState state) {
        this.state.add(state);
        state.setNodeInstance(this);
    }

    public void removeNodeState(String key) {
        Iterator<NodeState> iter = this.getState().iterator();
        while (iter.hasNext()) {
            NodeState nodeState = iter.next();
            if (!nodeState.getKey().equals(key)) continue;
            iter.remove();
            break;
        }
    }

    public void addNextNodeInstance(RouteNodeInstance nextNodeInstance) {
        this.nextNodeInstances.add(nextNodeInstance);
        nextNodeInstance.getPreviousNodeInstances().add(this);
    }

    public void removeNextNodeInstance(RouteNodeInstance nextNodeInstance) {
        this.nextNodeInstances.remove(nextNodeInstance);
        nextNodeInstance.getPreviousNodeInstances().remove(this);
    }

    public void clearNextNodeInstances() {
        Iterator<RouteNodeInstance> iterator = this.nextNodeInstances.iterator();
        while (iterator.hasNext()) {
            RouteNodeInstance nextNodeInstance = iterator.next();
            iterator.remove();
            nextNodeInstance.getPreviousNodeInstances().remove(this);
        }
    }

    public String getName() {
        return this.getRouteNode() == null ? null : this.getRouteNode().getRouteNodeName();
    }

    public boolean isInProcess() {
        return this.getProcess() != null;
    }

    public DocumentType getDocumentType() {
        return KEWServiceLocator.getDocumentTypeService().findByDocumentId(this.getDocumentId());
    }

    public NodeState getNodeStateByIndex(int index) {
        while (this.state.size() <= index) {
            this.state.add(new NodeState());
        }
        return this.getState().get(index);
    }

    public void populateState(List<NodeState> state) {
        this.state.addAll(state);
    }

    public List<DocumentRouteHeaderValue> getInitialDocumentRouteHeaderValues() {
        return this.initialDocumentRouteHeaderValues;
    }

    public void setInitialDocumentRouteHeaderValues(List<DocumentRouteHeaderValue> initialDocumentRouteHeaderValues) {
        this.initialDocumentRouteHeaderValues = initialDocumentRouteHeaderValues;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("routeNodeInstanceId", (Object)this.routeNodeInstanceId).append("documentId", (Object)this.documentId).append("branch", this.branch == null ? null : this.branch.getBranchId()).append("routeNode", this.routeNode == null ? null : this.routeNode.getRouteNodeName()).append("active", this.active).append("complete", this.complete).append("initial", this.initial).append("process", (Object)this.process).append("state", this.state == null ? null : Integer.valueOf(this.state.size())).toString();
    }

    public void beforeInsert() {
        OrmUtils.populateAutoIncValue((Object)this, (EntityManager)KEWServiceLocator.getEntityManagerFactory().createEntityManager());
    }

    public static org.kuali.rice.kew.api.document.node.RouteNodeInstance to(RouteNodeInstance routeNodeInstance) {
        if (routeNodeInstance == null) {
            return null;
        }
        RouteNodeInstance.Builder builder = RouteNodeInstance.Builder.create();
        builder.setActive(routeNodeInstance.isActive());
        builder.setBranchId(routeNodeInstance.getBranch().getBranchId());
        builder.setComplete(routeNodeInstance.isComplete());
        builder.setDocumentId(routeNodeInstance.getDocumentId());
        builder.setId(routeNodeInstance.getRouteNodeInstanceId());
        builder.setInitial(routeNodeInstance.isInitial());
        builder.setName(routeNodeInstance.getName());
        if (routeNodeInstance.getProcess() != null) {
            builder.setProcessId(routeNodeInstance.getProcess().getRouteNodeInstanceId());
        }
        builder.setRouteNodeId(routeNodeInstance.getRouteNode().getRouteNodeId());
        ArrayList<RouteNodeInstanceState.Builder> states = new ArrayList<RouteNodeInstanceState.Builder>();
        for (NodeState stateBo : routeNodeInstance.getState()) {
            RouteNodeInstanceState.Builder stateBuilder = RouteNodeInstanceState.Builder.create();
            stateBuilder.setId(stateBo.getStateId());
            stateBuilder.setKey(stateBo.getKey());
            stateBuilder.setValue(stateBo.getValue());
            states.add(stateBuilder);
        }
        builder.setState(states);
        ArrayList<RouteNodeInstance.Builder> nextNodes = new ArrayList<RouteNodeInstance.Builder>();
        if (routeNodeInstance.getNextNodeInstances() != null) {
            for (RouteNodeInstance next : routeNodeInstance.getNextNodeInstances()) {
                if (next == null) continue;
                nextNodes.add(RouteNodeInstance.Builder.create((RouteNodeInstanceContract)RouteNodeInstance.to(next)));
            }
        }
        builder.setNextNodeInstances(nextNodes);
        return builder.build();
    }
}

