/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.kew.engine.node.Branch;
import org.kuali.rice.kew.engine.node.NodeState;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.node.dao.RouteNodeDAO;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;

public class RouteNodeDAOJpaImpl
implements RouteNodeDAO {
    @PersistenceContext(unitName="kew-unit")
    EntityManager entityManager;
    private static final String CURRENT_ROUTE_NODE_NAMES_SQL = "SELECT rn.nm FROM krew_rte_node_t rn,      krew_rte_node_instn_t rni LEFT JOIN krew_rte_node_instn_lnk_t rnl   ON rnl.from_rte_node_instn_id = rni.rte_node_instn_id WHERE rn.rte_node_id = rni.rte_node_id AND       rni.doc_hdr_id = ? AND       rnl.from_rte_node_instn_id IS NULL";

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void save(RouteNode node) {
        if (node.getRouteNodeId() == null) {
            this.entityManager.persist((Object)node);
        } else {
            OrmUtils.merge((EntityManager)this.entityManager, (Object)node);
        }
    }

    @Override
    public void save(RouteNodeInstance nodeInstance) {
        if (nodeInstance.getRouteNodeInstanceId() == null) {
            this.entityManager.persist((Object)nodeInstance);
        } else {
            OrmUtils.merge((EntityManager)this.entityManager, (Object)nodeInstance);
        }
    }

    @Override
    public void save(NodeState nodeState) {
        if (nodeState.getNodeStateId() == null) {
            this.entityManager.persist((Object)nodeState);
        } else {
            OrmUtils.merge((EntityManager)this.entityManager, (Object)((Object)nodeState));
        }
    }

    @Override
    public void save(Branch branch) {
        if (branch.getBranchId() == null) {
            this.entityManager.persist((Object)branch);
        } else {
            OrmUtils.merge((EntityManager)this.entityManager, (Object)branch);
        }
    }

    @Override
    public RouteNode findRouteNodeById(String nodeId) {
        Query query = this.entityManager.createNamedQuery("RouteNode.FindByRouteNodeId");
        query.setParameter("routeNodeId", (Object)nodeId);
        return (RouteNode)query.getSingleResult();
    }

    @Override
    public RouteNodeInstance findRouteNodeInstanceById(String nodeInstanceId) {
        Query query = this.entityManager.createNamedQuery("RouteNodeInstance.FindByRouteNodeInstanceId");
        query.setParameter("routeNodeInstanceId", (Object)nodeInstanceId);
        return (RouteNodeInstance)query.getSingleResult();
    }

    @Override
    public List<RouteNodeInstance> getActiveNodeInstances(String documentId) {
        Query query = this.entityManager.createNamedQuery("RouteNodeInstance.FindActiveNodeInstances");
        query.setParameter("documentId", (Object)documentId);
        return query.getResultList();
    }

    @Override
    public List<String> getCurrentRouteNodeNames(final String documentId) {
        DataSource dataSource = KEWServiceLocator.getDataSource();
        JdbcTemplate template = new JdbcTemplate(dataSource);
        List names = (List)template.execute(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                return connection.prepareStatement(RouteNodeDAOJpaImpl.CURRENT_ROUTE_NODE_NAMES_SQL);
            }
        }, (PreparedStatementCallback)new PreparedStatementCallback<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<String> doInPreparedStatement(PreparedStatement statement) throws SQLException, DataAccessException {
                ArrayList<String> routeNodeNames = new ArrayList<String>();
                statement.setString(1, documentId);
                try (ResultSet rs = statement.executeQuery();){
                    while (rs.next()) {
                        String name = rs.getString("nm");
                        routeNodeNames.add(name);
                    }
                }
                return routeNodeNames;
            }
        });
        return names;
    }

    @Override
    public List<String> getActiveRouteNodeNames(final String documentId) {
        DataSource dataSource = KEWServiceLocator.getDataSource();
        JdbcTemplate template = new JdbcTemplate(dataSource);
        List names = (List)template.execute(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("SELECT rn.nm FROM krew_rte_node_t rn, krew_rte_node_instn_t rni WHERE rn.rte_node_id = rni.rte_node_id AND rni.doc_hdr_id = ? AND rni.actv_ind = ?");
                return statement;
            }
        }, (PreparedStatementCallback)new PreparedStatementCallback<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<String> doInPreparedStatement(PreparedStatement statement) throws SQLException, DataAccessException {
                ArrayList<String> routeNodeNames = new ArrayList<String>();
                statement.setString(1, documentId);
                statement.setBoolean(2, Boolean.TRUE);
                try (ResultSet rs = statement.executeQuery();){
                    while (rs.next()) {
                        String name = rs.getString("nm");
                        routeNodeNames.add(name);
                    }
                }
                return routeNodeNames;
            }
        });
        return names;
    }

    @Override
    public List<RouteNodeInstance> getTerminalNodeInstances(String documentId) {
        Query query = this.entityManager.createNamedQuery("RouteNodeInstance.FindTerminalNodeInstances");
        query.setParameter("documentId", (Object)documentId);
        ArrayList<RouteNodeInstance> terminalNodes = new ArrayList<RouteNodeInstance>();
        List routeNodeInstances = query.getResultList();
        for (RouteNodeInstance routeNodeInstance : routeNodeInstances) {
            if (!routeNodeInstance.getNextNodeInstances().isEmpty()) continue;
            terminalNodes.add(routeNodeInstance);
        }
        return terminalNodes;
    }

    @Override
    public List<String> getTerminalRouteNodeNames(final String documentId) {
        DataSource dataSource = KEWServiceLocator.getDataSource();
        JdbcTemplate template = new JdbcTemplate(dataSource);
        List names = (List)template.execute(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("SELECT rn.nm  FROM krew_rte_node_t rn,       krew_rte_node_instn_t rni  LEFT JOIN krew_rte_node_instn_lnk_t rnl    ON rnl.from_rte_node_instn_id = rni.rte_node_instn_id  WHERE rn.rte_node_id = rni.rte_node_id AND        rni.doc_hdr_id = ? AND        rni.actv_ind = ? AND        rni.cmplt_ind = ? AND        rnl.from_rte_node_instn_id IS NULL");
                return statement;
            }
        }, (PreparedStatementCallback)new PreparedStatementCallback<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<String> doInPreparedStatement(PreparedStatement statement) throws SQLException, DataAccessException {
                ArrayList<String> routeNodeNames = new ArrayList<String>();
                statement.setString(1, documentId);
                statement.setBoolean(2, Boolean.FALSE);
                statement.setBoolean(3, Boolean.TRUE);
                try (ResultSet rs = statement.executeQuery();){
                    while (rs.next()) {
                        String name = rs.getString("nm");
                        routeNodeNames.add(name);
                    }
                }
                return routeNodeNames;
            }
        });
        return names;
    }

    @Override
    public List getInitialNodeInstances(String documentId) {
        Query query = this.entityManager.createNamedQuery("RouteNodeInstance.FindInitialNodeInstances");
        query.setParameter("documentId", (Object)documentId);
        return query.getResultList();
    }

    @Override
    public NodeState findNodeState(Long nodeInstanceId, String key) {
        Query query = this.entityManager.createNamedQuery("NodeState.FindNodeState");
        query.setParameter("nodeInstanceId", (Object)nodeInstanceId);
        query.setParameter("key", (Object)key);
        return (NodeState)((Object)query.getSingleResult());
    }

    @Override
    public RouteNode findRouteNodeByName(String documentTypeId, String name) {
        Query query = this.entityManager.createNamedQuery("RouteNode.FindRouteNodeByName");
        query.setParameter("documentTypeId", (Object)documentTypeId);
        query.setParameter("routeNodeName", (Object)name);
        return (RouteNode)query.getSingleResult();
    }

    @Override
    public List<RouteNode> findFinalApprovalRouteNodes(String documentTypeId) {
        Query query = this.entityManager.createNamedQuery("RouteNode.FindApprovalRouteNodes");
        query.setParameter("documentTypeId", (Object)documentTypeId);
        query.setParameter("finalApprovalInd", (Object)Boolean.TRUE);
        return new ArrayList<RouteNode>(query.getResultList());
    }

    @Override
    public List findProcessNodeInstances(RouteNodeInstance process) {
        Query query = this.entityManager.createNamedQuery("RouteNodeInstance.FindProcessNodeInstances");
        query.setParameter("processId", (Object)process.getRouteNodeInstanceId());
        return query.getResultList();
    }

    @Override
    public List findRouteNodeInstances(String documentId) {
        Query query = this.entityManager.createNamedQuery("RouteNodeInstance.FindRouteNodeInstances");
        query.setParameter("documentId", (Object)documentId);
        return query.getResultList();
    }

    @Override
    public void deleteLinksToPreNodeInstances(RouteNodeInstance routeNodeInstance) {
        List<RouteNodeInstance> preNodeInstances = routeNodeInstance.getPreviousNodeInstances();
        for (RouteNodeInstance preNodeInstance : preNodeInstances) {
            List<RouteNodeInstance> nextInstances = preNodeInstance.getNextNodeInstances();
            nextInstances.remove(routeNodeInstance);
            this.entityManager.merge((Object)preNodeInstance);
        }
    }

    @Override
    public void deleteRouteNodeInstancesHereAfter(RouteNodeInstance routeNodeInstance) {
        RouteNodeInstance rnInstance = this.findRouteNodeInstanceById(routeNodeInstance.getRouteNodeInstanceId());
        this.entityManager.remove((Object)rnInstance);
    }

    @Override
    public void deleteNodeStateById(Long nodeStateId) {
        Query query = this.entityManager.createNamedQuery("RouteNode.FindNodeStateById");
        query.setParameter("nodeStateId", (Object)nodeStateId);
        NodeState nodeState = (NodeState)((Object)query.getSingleResult());
        this.entityManager.remove((Object)nodeState);
    }

    @Override
    public void deleteNodeStates(List statesToBeDeleted) {
        for (Long stateId : statesToBeDeleted) {
            this.deleteNodeStateById(stateId);
        }
    }
}

