/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.kuali.rice.kew.engine.node.Branch;
import org.kuali.rice.kew.engine.node.NodeState;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.node.dao.RouteNodeDAO;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springmodules.orm.ojb.support.PersistenceBrokerDaoSupport;

public class RouteNodeDAOOjbImpl
extends PersistenceBrokerDaoSupport
implements RouteNodeDAO {
    private static final String ROUTE_NODE_ID = "routeNodeId";
    private static final String ROUTE_NODE_INSTANCE_ID = "routeNodeInstanceId";
    private static final String NODE_INSTANCE_ID = "nodeInstanceId";
    private static final String DOCUMENT_ID = "documentId";
    private static final String ROUTE_NODE_NAME = "routeNodeName";
    private static final String DOCUMENT_TYPE_ID = "documentTypeId";
    private static final String PROCESS_ID = "processId";
    private static final String ACTIVE = "active";
    private static final String COMPLETE = "complete";
    private static final String FINAL_APPROVAL = "finalApprovalInd";
    private static final String KEY = "key";
    private static final String Route_Node_State_ID = "nodeStateId";
    private static final String CURRENT_ROUTE_NODE_NAMES_SQL = "SELECT rn.nm FROM krew_rte_node_t rn,      krew_rte_node_instn_t rni LEFT JOIN krew_rte_node_instn_lnk_t rnl   ON rnl.from_rte_node_instn_id = rni.rte_node_instn_id WHERE rn.rte_node_id = rni.rte_node_id AND       rni.doc_hdr_id = ? AND       rnl.from_rte_node_instn_id IS NULL";

    @Override
    public void save(RouteNode node) {
        this.getPersistenceBrokerTemplate().store((Object)node);
    }

    @Override
    public void save(RouteNodeInstance nodeInstance) {
        this.getPersistenceBrokerTemplate().store((Object)nodeInstance.getBranch());
        this.getPersistenceBrokerTemplate().store((Object)nodeInstance);
    }

    @Override
    public void save(NodeState nodeState) {
        this.getPersistenceBrokerTemplate().store((Object)nodeState);
    }

    @Override
    public void save(Branch branch) {
        this.getPersistenceBrokerTemplate().store((Object)branch);
    }

    @Override
    public RouteNode findRouteNodeById(String nodeId) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo(ROUTE_NODE_ID, (Object)nodeId);
        return (RouteNode)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(RouteNode.class, criteria));
    }

    @Override
    public RouteNodeInstance findRouteNodeInstanceById(String nodeInstanceId) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo(ROUTE_NODE_INSTANCE_ID, (Object)nodeInstanceId);
        return (RouteNodeInstance)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(RouteNodeInstance.class, criteria));
    }

    @Override
    public List<RouteNodeInstance> getActiveNodeInstances(String documentId) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo(DOCUMENT_ID, (Object)documentId);
        criteria.addEqualTo(ACTIVE, (Object)Boolean.TRUE);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(RouteNodeInstance.class, criteria));
    }

    @Override
    public List<String> getCurrentRouteNodeNames(final String documentId) {
        DataSource dataSource = KEWServiceLocator.getDataSource();
        JdbcTemplate template = new JdbcTemplate(dataSource);
        List names = (List)template.execute(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                return connection.prepareStatement(RouteNodeDAOOjbImpl.CURRENT_ROUTE_NODE_NAMES_SQL);
            }
        }, (PreparedStatementCallback)new PreparedStatementCallback<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<String> doInPreparedStatement(PreparedStatement statement) throws SQLException, DataAccessException {
                ArrayList<String> routeNodeNames = new ArrayList<String>();
                statement.setString(1, documentId);
                try (ResultSet rs = statement.executeQuery();){
                    while (rs.next()) {
                        String name = rs.getString("nm");
                        routeNodeNames.add(name);
                    }
                }
                return routeNodeNames;
            }
        });
        return names;
    }

    @Override
    public List<String> getActiveRouteNodeNames(final String documentId) {
        DataSource dataSource = KEWServiceLocator.getDataSource();
        JdbcTemplate template = new JdbcTemplate(dataSource);
        List names = (List)template.execute(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("SELECT rn.nm FROM krew_rte_node_t rn, krew_rte_node_instn_t rni WHERE rn.rte_node_id = rni.rte_node_id AND rni.doc_hdr_id = ? AND rni.actv_ind = ?");
                return statement;
            }
        }, (PreparedStatementCallback)new PreparedStatementCallback<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<String> doInPreparedStatement(PreparedStatement statement) throws SQLException, DataAccessException {
                ArrayList<String> routeNodeNames = new ArrayList<String>();
                statement.setString(1, documentId);
                statement.setBoolean(2, Boolean.TRUE);
                try (ResultSet rs = statement.executeQuery();){
                    while (rs.next()) {
                        String name = rs.getString("nm");
                        routeNodeNames.add(name);
                    }
                }
                return routeNodeNames;
            }
        });
        return names;
    }

    @Override
    public List<String> getTerminalRouteNodeNames(final String documentId) {
        DataSource dataSource = KEWServiceLocator.getDataSource();
        JdbcTemplate template = new JdbcTemplate(dataSource);
        List names = (List)template.execute(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("SELECT rn.nm  FROM krew_rte_node_t rn,       krew_rte_node_instn_t rni  LEFT JOIN krew_rte_node_instn_lnk_t rnl    ON rnl.from_rte_node_instn_id = rni.rte_node_instn_id  WHERE rn.rte_node_id = rni.rte_node_id AND        rni.doc_hdr_id = ? AND        rni.actv_ind = ? AND        rni.cmplt_ind = ? AND        rnl.from_rte_node_instn_id IS NULL");
                return statement;
            }
        }, (PreparedStatementCallback)new PreparedStatementCallback<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<String> doInPreparedStatement(PreparedStatement statement) throws SQLException, DataAccessException {
                ArrayList<String> routeNodeNames = new ArrayList<String>();
                statement.setString(1, documentId);
                statement.setBoolean(2, Boolean.FALSE);
                statement.setBoolean(3, Boolean.TRUE);
                try (ResultSet rs = statement.executeQuery();){
                    while (rs.next()) {
                        String name = rs.getString("nm");
                        routeNodeNames.add(name);
                    }
                }
                return routeNodeNames;
            }
        });
        return names;
    }

    @Override
    public List<RouteNodeInstance> getTerminalNodeInstances(String documentId) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo(DOCUMENT_ID, (Object)documentId);
        criteria.addEqualTo(ACTIVE, (Object)Boolean.FALSE);
        criteria.addEqualTo(COMPLETE, (Object)Boolean.TRUE);
        ArrayList<RouteNodeInstance> terminalNodes = new ArrayList<RouteNodeInstance>();
        List routeNodeInstances = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(RouteNodeInstance.class, criteria));
        for (RouteNodeInstance routeNodeInstance : routeNodeInstances) {
            if (!routeNodeInstance.getNextNodeInstances().isEmpty()) continue;
            terminalNodes.add(routeNodeInstance);
        }
        return terminalNodes;
    }

    @Override
    public List getInitialNodeInstances(String documentId) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("initialDocumentRouteHeaderValues.documentId", (Object)documentId);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(RouteNodeInstance.class, criteria));
    }

    @Override
    public NodeState findNodeState(Long nodeInstanceId, String key) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo(NODE_INSTANCE_ID, (Object)nodeInstanceId);
        criteria.addEqualTo(KEY, (Object)key);
        return (NodeState)((Object)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(NodeState.class, criteria)));
    }

    @Override
    public RouteNode findRouteNodeByName(String documentTypeId, String name) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo(ROUTE_NODE_NAME, (Object)name);
        criteria.addEqualTo(DOCUMENT_TYPE_ID, (Object)documentTypeId);
        return (RouteNode)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(RouteNode.class, criteria));
    }

    @Override
    public List<RouteNode> findFinalApprovalRouteNodes(String documentTypeId) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo(DOCUMENT_TYPE_ID, (Object)documentTypeId);
        criteria.addEqualTo(FINAL_APPROVAL, (Object)Boolean.TRUE);
        return new ArrayList<RouteNode>(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(RouteNode.class, criteria)));
    }

    @Override
    public List findProcessNodeInstances(RouteNodeInstance process) {
        Criteria crit = new Criteria();
        crit.addEqualTo(PROCESS_ID, (Object)process.getRouteNodeInstanceId());
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(RouteNodeInstance.class, crit));
    }

    @Override
    public List findRouteNodeInstances(String documentId) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo(DOCUMENT_ID, (Object)documentId);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(RouteNodeInstance.class, criteria));
    }

    @Override
    public void deleteLinksToPreNodeInstances(RouteNodeInstance routeNodeInstance) {
        List<RouteNodeInstance> preNodeInstances = routeNodeInstance.getPreviousNodeInstances();
        for (RouteNodeInstance preNodeInstance : preNodeInstances) {
            List<RouteNodeInstance> nextInstances = preNodeInstance.getNextNodeInstances();
            nextInstances.remove(routeNodeInstance);
            this.save(preNodeInstance);
        }
    }

    @Override
    public void deleteRouteNodeInstancesHereAfter(RouteNodeInstance routeNodeInstance) {
        this.getPersistenceBrokerTemplate().delete((Object)routeNodeInstance);
    }

    @Override
    public void deleteNodeStateById(Long nodeStateId) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo(Route_Node_State_ID, (Object)nodeStateId);
        NodeState nodeState = (NodeState)((Object)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(NodeState.class, criteria)));
        this.getPersistenceBrokerTemplate().delete((Object)nodeState);
    }

    @Override
    public void deleteNodeStates(List statesToBeDeleted) {
        for (Long stateId : statesToBeDeleted) {
            this.deleteNodeStateById(stateId);
        }
    }
}

